/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.impl;

import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.mq.RocketMQMsgProducer;
import cn.com.duiba.service.DevAppTrustConfService;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.thirdparty.enums.HttpRequestResultType;
import cn.com.duiba.thirdparty.mq.msg.ValidatePrizeTagMsg;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.HttpRequestLog;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DevAppTrustConfServiceImpl
implements DevAppTrustConfService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DevAppTrustConfServiceImpl.class);
    @Autowired
    private HttpAsyncClientPool httpAsyncClientPool;
    @Autowired
    private RocketMQMsgProducer rocketMQMsgProducer;

    @Override
    public void sendDevPrizeTagMsg(final ValidatePrizeTagMsg validatePrizeTagMsg) {
        if (validatePrizeTagMsg == null) {
            return;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("uid", String.valueOf(validatePrizeTagMsg.getUid()));
        param.put("actId", String.valueOf(validatePrizeTagMsg.getActId()));
        param.put("prizeMark", validatePrizeTagMsg.getPrizeMark());
        param.put("appKey", validatePrizeTagMsg.getAppKey());
        param.put("timestamp", String.valueOf(System.currentTimeMillis()));
        param.put("appSecret", validatePrizeTagMsg.getAppSecret());
        param.put("sign", SignTool.sign(param));
        param.remove("appSecret");
        String httpUrl = AssembleTool.assembleUrl(validatePrizeTagMsg.getApiUrl(), param);
        LOGGER.info("\u8bbf\u95ee\u5f00\u53d1\u8005\u4fe1\u7528\u63a5\u53e3url {}", (Object)httpUrl);
        HttpGet http = new HttpGet(httpUrl);
        this.httpAsyncClientPool.submit(String.valueOf(validatePrizeTagMsg.getAppid()), (HttpUriRequest)http, new FutureCallback<HttpResponse>(){

            public void completed(HttpResponse result) {
                try {
                    validatePrizeTagMsg.setResultType(HttpRequestResultType.COMPLETED);
                    String body = EntityUtils.toString((HttpEntity)result.getEntity());
                    DevAppTrustConfServiceImpl.this.parseResponseBody(body, validatePrizeTagMsg);
                }
                catch (Exception e) {
                    LOGGER.error("visit developer api failed", (Throwable)e);
                }
                finally {
                    DevAppTrustConfServiceImpl.this.finallyBlock(validatePrizeTagMsg, validatePrizeTagMsg.getCallbackTopic(), validatePrizeTagMsg.getCallbackTag(), validatePrizeTagMsg.getCallbackKey(), "");
                }
            }

            public void failed(Exception ex) {
                try {
                    validatePrizeTagMsg.setResultType(HttpRequestResultType.FAILED);
                    validatePrizeTagMsg.setGivePrize(Integer.valueOf(1));
                }
                catch (Exception e) {
                    LOGGER.error("visit developer api failed", (Throwable)e);
                }
                finally {
                    DevAppTrustConfServiceImpl.this.finallyBlock(validatePrizeTagMsg, validatePrizeTagMsg.getCallbackTopic(), validatePrizeTagMsg.getCallbackTag(), validatePrizeTagMsg.getCallbackKey(), "");
                }
            }

            public void cancelled() {
                try {
                    validatePrizeTagMsg.setResultType(HttpRequestResultType.CANCELLED);
                    validatePrizeTagMsg.setGivePrize(Integer.valueOf(1));
                }
                catch (Exception e) {
                    LOGGER.error("visit developer api failed", (Throwable)e);
                }
                finally {
                    DevAppTrustConfServiceImpl.this.finallyBlock(validatePrizeTagMsg, validatePrizeTagMsg.getCallbackTopic(), validatePrizeTagMsg.getCallbackTag(), validatePrizeTagMsg.getCallbackKey(), "");
                }
            }
        });
    }

    private void parseResponseBody(String body, ValidatePrizeTagMsg resultMsg) {
        LOGGER.info("\u8bbf\u95ee\u5f00\u53d1\u8005\u4fe1\u7528\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c {}", (Object)body);
        try {
            JSONObject bodyJson = JSON.parseObject((String)body);
            boolean isSuccess = bodyJson.getBoolean("success");
            if (isSuccess) {
                JSONObject data = bodyJson.getJSONObject("data");
                Integer givePrize = data.getInteger("givePrize");
                resultMsg.setGivePrize(givePrize);
            }
        }
        catch (Exception e) {
            LOGGER.warn("parse ValidatePrizeTagMsg json fail, appId={}, body={}", (Object)resultMsg.getAppid(), (Object)body);
            resultMsg.setGivePrize(Integer.valueOf(1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finallyBlock(ValidatePrizeTagMsg resp, String msgTopic, String msgTag, String msgKey, String code) {
        String body = null;
        try {
            body = JSON.toJSONString((Object)resp);
            this.rocketMQMsgProducer.sendMsg(msgTopic, msgTag, msgKey, body, false, null);
        }
        catch (Exception e) {
            LOGGER.error("validatePrizeTag callback: appid:" + resp.getAppid() + " apiUrl:" + resp.getApiUrl(), (Throwable)e);
        }
        finally {
            HttpRequestLog.logUrl("[action validatePrizeTag] [tag response] [code " + code + "] [appid " + resp.getAppid() + "] [apiUrl " + resp.getApiUrl() + "] [body " + body + "]");
        }
    }
}

