/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.impl;

import cn.com.duiba.api.bo.credits.CreditsRequest;
import cn.com.duiba.api.bo.credits.CreditsResponse;
import cn.com.duiba.api.bo.subcredits.SubCreditsResultMsgDto;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.service.impl.AbstractCreditsLogExtractor;
import cn.com.duiba.thirdparty.dto.ConsumerCreditsLogSaveDto;
import cn.com.duiba.thirdparty.enums.CreditsLogChangeTypeEnum;
import cn.com.duiba.thirdparty.enums.CreditsLogStatusEnum;
import java.util.Date;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
class MqSubCreditsLogExtractor
extends AbstractCreditsLogExtractor {
    MqSubCreditsLogExtractor() {
    }

    @Override
    public boolean supportsInternal(CreditsRequest request, CreditsResponse response) {
        return request instanceof SubCreditsMsgWrapper && response instanceof SubCreditsResultMsgDto;
    }

    @Override
    protected Map<String, String> extractRequestParams(CreditsRequest request) {
        SubCreditsMsgWrapper req = (SubCreditsMsgWrapper)request;
        return req.getSubCreditsMsg().getAuthParams();
    }

    @Override
    protected ConsumerCreditsLogSaveDto extractInternal(CreditsRequest request, CreditsResponse response) {
        SubCreditsMsgWrapper req = (SubCreditsMsgWrapper)request;
        SubCreditsResultMsgDto resp = (SubCreditsResultMsgDto)response;
        ConsumerCreditsLogSaveDto creditsLog = new ConsumerCreditsLogSaveDto();
        creditsLog.setConsumerId(req.getSubCreditsMsg().getConsumerId());
        creditsLog.setAppId(req.getSubCreditsMsg().getAppId());
        creditsLog.setChangeType(CreditsLogChangeTypeEnum.SUB);
        creditsLog.setLogStatus(CreditsLogStatusEnum.SUCCESS);
        creditsLog.setOrderTime(new Date(req.getSubCreditsMsg().getTimestamp()));
        creditsLog.setDeveloperBizId(resp.getBizId());
        creditsLog.setBizId(req.getSubCreditsMsg().getBizId());
        creditsLog.setRelationType(req.getSubCreditsMsg().getRelationType().getMsg());
        creditsLog.setRelationId(req.getSubCreditsMsg().getRelationId());
        return creditsLog;
    }
}

