/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tool;

import java.security.MessageDigest;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class WatsonsSignUtil {
    private static Logger logger = Logger.getLogger(WatsonsSignUtil.class);

    public static String byte2hex(byte[] b) {
        StringBuilder hs = new StringBuilder();
        String stmp = "";
        for (byte aB : b) {
            stmp = Integer.toHexString(aB & 0xFF);
            if (stmp.length() == 1) {
                hs.append("0").append(stmp);
                continue;
            }
            hs.append(stmp);
        }
        return hs.toString().toUpperCase();
    }

    public static TreeMap<String, String> convertEncodeToMap(Map<String, String> params) {
        if (params == null) {
            return null;
        }
        Iterator<Map.Entry<String, String>> it = params.entrySet().iterator();
        TreeMap<String, String> map = new TreeMap<String, String>();
        while (it.hasNext()) {
            Map.Entry<String, String> obj = it.next();
            String name = obj.getKey().toString();
            Object[] valueObj = (Object[])obj.getValue();
            String value = valueObj[0].toString();
            map.put(name, value);
        }
        return map;
    }

    public static String getParamStr(TreeMap<String, String> params) {
        Iterator<String> iter = params.keySet().iterator();
        StringBuilder orgin = new StringBuilder("");
        while (iter.hasNext()) {
            String name = iter.next();
            orgin.append(name).append(params.get(name));
        }
        return orgin.toString();
    }

    public static String getDigest(String paramStr, String token) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            String firstMd = WatsonsSignUtil.byte2hex(md.digest(paramStr.getBytes("utf-8"))).toUpperCase();
            firstMd = firstMd + token;
            return WatsonsSignUtil.byte2hex(md.digest(firstMd.getBytes("utf-8"))).toUpperCase();
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getSign(TreeMap<String, String> params, String token) {
        if (params == null) {
            return null;
        }
        String paramStr = WatsonsSignUtil.getParamStr(params);
        return WatsonsSignUtil.getDigest(paramStr, token);
    }
}

