package cn.com.duiba.biz.credits;

import cn.com.duiba.constant.CiticBankConfig;
import cn.com.duiba.constant.CiticBankXiAnConfig;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by HePeng on 2019/05/13 11:26.
 */
@Service
public class CiticBankApi {
    @Autowired
    private CiticBankConfig citicBankConfig;
    @Autowired
    private CiticBankXiAnConfig citicBankXiAnConfig;

    public boolean isCiticBank(Long appId) {
        return appId != null
                && CollectionUtils.isNotEmpty(citicBankConfig.getAppIdSet())
                && citicBankConfig.getAppIdSet().contains(appId);
    }

    /**
     * 是否是西安中信
     * @param appId
     * @return
     */
    public boolean isXiAnApp(Long appId) {
        return citicBankXiAnConfig.getAppIdSet().contains(appId);
    }

}
