package cn.com.duiba.biz.credits;

import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import org.apache.http.client.methods.HttpRequestBase;

/**
 * @author zyj
 * @date 2018/12/12
 */
public interface EzrApiService {

    /**
     * 是否是对接过ezr平台的开发者
     * @param appId
     * @return
     */
    Boolean isEzr(Long appId);

    /**
     * 封装扣积分请求参数
     * @param subCreditsMsgWrapper
     * @return
     */
    SubCreditsMsgWrapper getRequestCredits(SubCreditsMsgWrapper subCreditsMsgWrapper);

    /**
     * 封装加积分请求参数
     * @param request
     * @return
     */
    CreditsMessageDto getAddCreditsMessage(CreditsMessageDto request);

    /**
     * 兑换结果通知
     * @param notifyUrl
     * @param record
     * @param appDO
     * @return
     */
    HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record, AppDO appDO);

    /**
     * 转换body
     * @param body
     * @return
     */
    String parseCreditsRsp(String body);
}
