package cn.com.duiba.biz.credits;

import cn.com.duiba.api.bo.subcredits.SubCreditsMsgDto;
import cn.com.duiba.constant.GangZhongLvConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.hutool.core.util.XmlUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * @author XuJing
 * @since 2020/4/17 10:20 上午
 */
@Service
public class GangZhongLvApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(GangZhongLvApi.class);

    @Autowired
    private GangZhongLvConfig gangZhongLvConfig;

    public Boolean isGangZhongLv(Long appId) {
        Set<Long> appIds = gangZhongLvConfig.getAppIds();
        if (null == appIds) {
            return false;
        }
        return appIds.contains(appId);
    }

    /**
     * 构造加积分请求
     *
     * @param request
     * @return
     */
    public HttpRequestBase getAddCreditsMessage(CreditsMessageDto request) {
        // 截取请求url
        String httpUrl = request.getHttpUrl();
        // 截取url请求参数，构造新的请求参数
        String paramStr = httpUrl.substring(httpUrl.indexOf('?') + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramStr);
        return getAddCreditsRequest(params, httpUrl);
    }

    private HttpPost getAddCreditsRequest(Map<String, String> params, String httpUrl) {
        HttpPost post = new HttpPost(httpUrl);
        String auth = gangZhongLvConfig.getAddUserName() + ":" + gangZhongLvConfig.getAddPassword();
        post.addHeader("Content-Type", "application/json; charset=UTF-8");
        post.addHeader("Authorization", "Basic " + Base64.encodeBase64String(auth.getBytes()));
        post.setEntity(new StringEntity(JSON.toJSONString(buildAddCreditsAuthParams(params, params.get("credits"))), "utf-8"));
        return post;
    }

    /**
     * 构造减积分请求 remote
     *
     * @param message
     * @return
     */
    public HttpRequestBase getSubCreditsMessage(CreditsMessage message) {
        String url = message.getHttpUrl();
        String paramsStr = url.substring(url.indexOf('?') + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);

        message.setHttpType(CreditsMessageDto.HTTP_POST);
        message.setHttpUrl(url);
        message.setAuthParams(params);
        return this.getXmlRequest(message.getHttpUrl(), params, true);
    }

    /**
     * 构造减积分请求 mq
     *
     * @param message
     * @return
     */
    public HttpRequestBase getSubCreditsMessage(SubCreditsMsgWrapper message) {
        String url = message.getHttpUrl();
        String paramsStr = url.substring(url.indexOf('?') + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);

        message.getSubCreditsMsg().setHttpType(SubCreditsMsgDto.HTTP_POST);
        message.setHttpUrl(url);
        message.getSubCreditsMsg().setAuthParams(params);

        return this.getXmlRequest(message.getHttpUrl(), params, true);
    }

    /**
     * 构造积分兑换请求
     *
     * @param request
     * @return
     */
    public HttpRequestBase getVirtualRequest(SupplierRequest request) {
        String url = request.getHttpUrl();
        String paramsStr = url.substring(url.indexOf('?') + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        String goodsNum = params.get("params");
        request.setAuthParams(params);
        if (goodsNum.startsWith(gangZhongLvConfig.getVirtualPre())) {
            return this.getXmlRequest(request.getHttpUrl(), params, false);
        }
        if (goodsNum.startsWith(gangZhongLvConfig.getVirtualCreditsPre())) {
            params.put("credits", goodsNum.replace(gangZhongLvConfig.getVirtualCreditsPre(), ""));
            return getAddCreditsRequest(params, gangZhongLvConfig.getAddUrl());
        }
        return AssembleTool.assembleRequest(request.getHttpUrl(), request.getAuthParams());

    }

    /**
     * 构造加积分请求参数
     *
     * @param urlParams
     * @return
     */
    private Map<String, Object> buildAddCreditsAuthParams(Map<String, String> urlParams, String credits) {
        Map<String, String> params = Maps.newHashMap();
        Map<String, Object> authParams = Maps.newHashMap();
        params.put("Member Number", getCreditsOrId(urlParams.get("uid"), false));
        params.put("Exchange Channel", "DUBA");
        params.put("Exchange Place", "PointsShop");
        params.put("Exchange Type", "Points Input");
        params.put("Exchange Product Code", gangZhongLvConfig.getAddProductNo());
        params.put("Apply Exchange Point", credits);
        params.put("Partner Order Number", urlParams.get("orderNum"));
        params.put("Description", urlParams.get("description"));
        authParams.put("body", params);
        return authParams;

    }


    private HttpRequestBase getXmlRequest(String httpUrl, Map<String, String> params, Boolean isSub) {
        String content;
        if (isSub) {
            content = getSubXmlString(params);
        } else {
            content = getVirtualXmlString(params);
        }
        HttpPost request = new HttpPost(httpUrl);
        request.addHeader("Content-Type", "text/xml; charset=UTF-8");
        request.addHeader("SOAPAction", "\"document/http://siebel.com/CustomUI:MPHRedeemService-InterfaceRedeem\"");
        request.setEntity(new StringEntity(content, "utf-8"));

        return request;
    }

    /**
     * 积分抵扣xml拼接
     *
     * @param params
     * @return
     */
    private String getSubXmlString(Map<String, String> params) {
        return "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:web=\"http://siebel.com/webservices\" xmlns:cus=\"http://siebel.com/CustomUI\" xmlns:mph=\"http://www.siebel.com/xml/MPH%20Member%20Exchange%20IO\">" +
                "   <soapenv:Header>" +
                "      <web:SessionToken/>" +
                "      <web:SessionType>NONE</web:SessionType>" +
                "      <web:PasswordText>" + gangZhongLvConfig.getPassword() + "</web:PasswordText>" +
                "      <web:UsernameToken>" + gangZhongLvConfig.getUsername() + "</web:UsernameToken>" +
                "   </soapenv:Header>" +
                "   <soapenv:Body>" +
                "      <cus:MPHRedeemService-InterfaceRedeem_Input>" +
                "         <mph:ListOfMphMemberExchangeIo>" +
                "            <mph:MphMemberExchange>" +
                "            <mph:ExchangePoints>" + params.get("credits") + "</mph:ExchangePoints>" +
                "            <mph:ExchangeProductCode>" + gangZhongLvConfig.getSubProductNo() + "</mph:ExchangeProductCode>" +
                "            <mph:ExchangeChannel>DUBA</mph:ExchangeChannel>" +
                "            <mph:MPHCardNumber>" + params.get("uid") + "</mph:MPHCardNumber>" +
                "            <mph:ExchangeType>Points deduction</mph:ExchangeType>" +
                "            <mph:ExchangePlace>PointsShop</mph:ExchangePlace>" +
                "            <mph:MPHOrderNumber>" + params.get("orderNum") + "</mph:MPHOrderNumber>" +
                "         </mph:MphMemberExchange>" +
                "         </mph:ListOfMphMemberExchangeIo>" +
                "      </cus:MPHRedeemService-InterfaceRedeem_Input>" +
                "   </soapenv:Body>" +
                "</soapenv:Envelope>";
    }

    private String getVirtualXmlString(Map<String, String> params) {
        return "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:web=\"http://siebel.com/webservices\" xmlns:cus=\"http://siebel.com/CustomUI\" xmlns:mph=\"http://www.siebel.com/xml/MPH%20Member%20Exchange%20IO\">" +
                "   <soapenv:Header>" +
                "      <web:SessionToken/>" +
                "      <web:SessionType>NONE</web:SessionType>" +
                "      <web:PasswordText>" + gangZhongLvConfig.getPassword() + "</web:PasswordText>" +
                "      <web:UsernameToken>" + gangZhongLvConfig.getUsername() + "</web:UsernameToken>" +
                "   </soapenv:Header>" +
                "   <soapenv:Body>" +
                "      <cus:MPHRedeemService-InterfaceRedeem_Input>" +
                "         <mph:ListOfMphMemberExchangeIo>" +
                "            <mph:MphMemberExchange>" +
                "            <mph:ExchangePoints>0</mph:ExchangePoints>" +
                "            <mph:ExchangeProductCode>" + params.get("params").replace(gangZhongLvConfig.getVirtualPre(), "") + "</mph:ExchangeProductCode>" +
                "            <mph:ExchangeChannel>DUBA</mph:ExchangeChannel>" +
                "            <mph:MPHCardNumber>" + params.get("uid") + "</mph:MPHCardNumber>" +
                "            <mph:ExchangeType>Receive Voucher</mph:ExchangeType>" +
                "            <mph:ExchangePlace>PointsShop</mph:ExchangePlace>" +
                "            <mph:CouponAmount>0</mph:CouponAmount>" +
                "            <mph:MPHOrderNumber>" + params.get("orderNum") + "</mph:MPHOrderNumber>" +
                "            </mph:MphMemberExchange>" +
                "         </mph:ListOfMphMemberExchangeIo>" +
                "      </cus:MPHRedeemService-InterfaceRedeem_Input>" +
                "   </soapenv:Body>" +
                "</soapenv:Envelope>";
    }


    /**
     * 解析积分响应
     *
     * @param body
     * @param addCredits
     * @param authParams
     * @return
     */
    public String parseCreditsRsp(String body, Boolean addCredits, Map<String, String> authParams) {
        Map<String, String> map = new HashMap<>();
        try {
            if (addCredits) {
                JSONObject bodyJson = JSONObject.parseObject(body);
                String items = bodyJson.getString("items");
                HashMap<String, String> resMap = JSON.parseObject(items, HashMap.class);
                String code = resMap.get("Code");
                if ("0".equals(code)) {
                    map.put("status", "ok");
                } else {
                    map.put("status", "fail");
                    map.put("errorMessage", resMap.get("Error Message"));
                }
                map.put("credits", getCreditsOrId(authParams.get("uid"), true));
                return JSONObject.toJSONString(map);
            } else {
                Map<String, String> out = (Map<String, String>) (((Map<String, Object>) XmlUtil.xmlToMap(body).get("SOAP-ENV:Body")).get("ns:MPHRedeemService-InterfaceRedeem_Output"));
                String code = out.get("ns:Message_spcCode");
                if ("10".equals(code)) {
                    map.put("status", "ok");
                    map.put("bizId", out.get("ns:Id"));
                } else {
                    map.put("status", "fail");
                    map.put("errorMessage", out.get("ns:Message"));
                }
                map.put("credits", getCreditsOrId(authParams.get("uid"), true));

            }
        } catch (Exception e) {
            LOGGER.error("港中旅酒店新增/扣减积分接口解析错误:{}--是否新增:{}", body, addCredits, e);
            map.put("status", "fail");
            map.put("errorMessage", "解析积分结果错误");
        }
        return JSONObject.toJSONString(map);
    }


    /**
     * 解析积分兑换响应
     *
     * @param request
     * @param body
     * @return
     */
    public String getVirtualResponse(SupplierRequest request, String body) {
        Map<String, String> params = request.getAuthParams();
        String goodsNum = params.get("params");
        String uid = params.get("uid");
        Map<String, String> duibaDoc = new HashMap<>();
        try {
            if (goodsNum.startsWith(gangZhongLvConfig.getVirtualPre())) {
                Map<String, String> out = (Map<String, String>) (((Map<String, Object>) XmlUtil.xmlToMap(body).get("SOAP-ENV:Body")).get("ns:MPHRedeemService-InterfaceRedeem_Output"));
                String code = out.get("ns:Message_spcCode");
                if ("10".equals(code)) {
                    duibaDoc.put("status", "success");
                    duibaDoc.put("supplierBizId", out.get("ns:Id"));
                } else {
                    duibaDoc.put("status", "fail");
                    duibaDoc.put("errorMessage", out.get("ns:Message"));
                }
                duibaDoc.put("credits", getCreditsOrId(uid, true));
            }
            if (goodsNum.startsWith(gangZhongLvConfig.getVirtualCreditsPre())) {
                String addRes = parseCreditsRsp(body, true, params);
                HashMap<String, String> resMap = JSON.parseObject(addRes, HashMap.class);
                if ("ok".equals(resMap.get("status"))) {
                    duibaDoc.put("status", "success");
                } else {
                    duibaDoc.put("status", "fail");
                    duibaDoc.put("errorMessage", resMap.get("errorMessage"));
                }
                duibaDoc.put("credits", resMap.get("credits"));
            }
        } catch (Exception e) {
            LOGGER.error("港中旅酒店优惠券兑换接口解析错误:{} 是否兑换优惠券:{}", body, goodsNum.startsWith(gangZhongLvConfig.getVirtualPre()), e);
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", "积分兑换响应解析错误");
        }
        return JSON.toJSONString(duibaDoc);
    }

    private String getCreditsOrId(String cardNum, Boolean isCredits) {
        String creditsOrId = null;
        try {
            HttpRequest post = HttpUtil.createPost(gangZhongLvConfig.getCreditsSelectUrl());
            Map<String, String> header = new HashMap<>();
            header.put("SOAPAction", "\"document/http://siebel.com/CustomUI:MPHMemberPointsQueryServiceQueryPoints\"");
            header.put("Content-Type", "text/xml; charset=UTF-8");
            post.addHeaders(header);
            post.body(getSelectParam(cardNum));
            post.timeout(5000);
            String result = post.execute().body();
            Map<String, String> out = (Map<String, String>) (((Map<String, Object>) XmlUtil.xmlToMap(result).get("SOAP-ENV:Body")).get("ns:MPHMemberPointsQueryServiceQueryPoints_Output"));
            if ("10".equals(out.get("ns:Message_spcCode"))) {
                if (isCredits) {
                    creditsOrId = out.get("ns:MPH_spcHKCTS_spcPoints");
                } else {
                    creditsOrId = out.get("ns:Member_spcNumber");
                }
            } else {
                LOGGER.error("港中旅定制积分查询接口调用异常 params={},error={}", cardNum, out.get("ns:Message"));
            }
            return creditsOrId;
        } catch (Exception e) {
            LOGGER.error("港中旅定制积分查询接口调用异常 params={},error={}", cardNum, e.getMessage());
            return null;
        }

    }

    private String getSelectParam(String cardNum) {
        return "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:web=\"http://siebel.com/webservices\" xmlns:cus=\"http://siebel.com/CustomUI\">" +
                "   <soapenv:Header>" +
                "      <web:SessionToken/>" +
                "      <web:SessionType>NONE</web:SessionType>" +
                "      <web:PasswordText>" + gangZhongLvConfig.getPassword() + "</web:PasswordText>" +
                "      <web:UsernameToken>" + gangZhongLvConfig.getUsername() + "</web:UsernameToken>" +
                "   </soapenv:Header>" +
                "   <soapenv:Body>" +
                "      <cus:MPHMemberPointsQueryServiceQueryPoints_Input>" +
                "      <cus:Currency>CNY</cus:Currency>" +
                "      <cus:MPH_spcCard_spcNumber>" + cardNum + "</cus:MPH_spcCard_spcNumber>" +
                "      </cus:MPHMemberPointsQueryServiceQueryPoints_Input>" +
                "   </soapenv:Body>" +
                "</soapenv:Envelope>";
    }
}
