package cn.com.duiba.biz.credits;

import cn.com.duiba.api.bo.subcredits.SubCreditsMsgDto;
import cn.com.duiba.constant.QingdaoRcbConfig;
import cn.com.duiba.credits.sdk.CreditConsumeParams;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.service.reconciliation.ReconciliationRecordService;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.thirdparty.dto.reconciliation.ReconciliationRecordDto;
import cn.com.duiba.thirdparty.enums.reconciliation.ReconciliationLogTypeEnum;
import cn.com.duiba.thirdparty.enums.reconciliation.ReconciliationRespStatusEnum;
import cn.com.duiba.tool.AssembleTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.ExecutorService;

/**
 * @program: thirdparty-all
 * @description: 青岛农商行定制api
 * @author: Simba
 * @create: 2020-02-18 15:49
 **/
@Service
public class QingdaoRcbBankApi {

    private static final Logger logger = LoggerFactory.getLogger(QingdaoRcbBankApi.class);

    @Autowired
    private QingdaoRcbConfig qingdaoRcbConfig;

    @Autowired
    private ExecutorService executorService;

    @Autowired
    private ReconciliationRecordService reconciliationRecordService;

    public boolean isQingdaoRcbBank(Long appId) {
    	if(appId == null || CollectionUtils.isEmpty(qingdaoRcbConfig.getAppIdSet())){
    		return false;
		}

        return qingdaoRcbConfig.getAppIdSet().contains(appId);
    }

    /**
     * 青岛农商行-保存对账记录 入口是rpc
     * @param request
     * @return
     */
	public CreditsMessage getSubCreditsMessage(CreditsMessage request) {
        String url = request.getHttpUrl();
        String authParams = url.substring(url.indexOf('?') + 1);
        ReconciliationRecordDto dto = wrapReconciliationLog(Long.valueOf(request.getAppId()), request.getRelationId(), request.getRelationType(), authParams, request.getParams(), ReconciliationLogTypeEnum.SUB_CREDITS);
        executorService.execute(() -> {
            try{
                reconciliationRecordService.saveOrUpdate(dto);
            }catch (Exception e){
                logger.error("save青岛农商行对账记录出错, appId:{}, relationId:{}, optId:{}, relationType:{}, ", dto.getAppId(), dto.getOrderNum(), dto.getOptId(), dto.getOptType(), e);
            }
        });
        return request;
	}

    /**
     * 青岛农商行-保存对账记录 入口是rocketmq
     * @param subCreditsMsgWrapper
     * @return
     */
    public SubCreditsMsgWrapper getSubCreditsMessage(SubCreditsMsgWrapper subCreditsMsgWrapper) {
        ReconciliationRecordDto dto = wrapReconciliationLog(subCreditsMsgWrapper);
        executorService.execute(() -> {
            try{
                reconciliationRecordService.saveOrUpdate(dto);
            }catch (Exception e){
                logger.error("save青岛农商行对账记录出错, appId:{}, relationId:{}, optId:{}, relationType:{}, ", dto.getAppId(), dto.getOrderNum(), dto.getOptId(), dto.getOptType(), e);
            }
        });
        return subCreditsMsgWrapper;
    }

    /**
     * 构造扣积分请求参数-入口是rocketmq
     * 加/扣积分：兑吧订单号、用户id、操作类型（加积分、扣积分）、时间、活动ID、状态（成功、失败）、积分值
     */
    private ReconciliationRecordDto wrapReconciliationLog(SubCreditsMsgWrapper subCreditsMsgWrapper) {
        SubCreditsMsgDto subCreditsMsgDto = subCreditsMsgWrapper.getSubCreditsMsg();
        CreditConsumeParams creditConsumeParams = subCreditsMsgDto.getCreditConsumeParams();
	    Map<String, String> paramMap = subCreditsMsgDto.getParams();

        ReconciliationRecordDto reconciliationRecordDto = new ReconciliationRecordDto();
        reconciliationRecordDto.setOrderNum(subCreditsMsgDto.getRelationId());
        reconciliationRecordDto.setPartnerUserId(creditConsumeParams.getUid());
        reconciliationRecordDto.setLogType(ReconciliationLogTypeEnum.SUB_CREDITS.getCode());
        reconciliationRecordDto.setSendTime(new Date());
        if(MapUtils.isNotEmpty(paramMap)){
            reconciliationRecordDto.setOptId(paramMap.get("opId"));
        }

        if(subCreditsMsgDto.getRelationType() != null){
            reconciliationRecordDto.setOptType(subCreditsMsgDto.getRelationType().getMsg());
        }
        reconciliationRecordDto.setCredits(creditConsumeParams.getCredits());
        reconciliationRecordDto.setAppId(subCreditsMsgDto.getAppId());

        return reconciliationRecordDto;
    }

    /**
     *
     * 构造扣积分请求参数-入口是rpc
     * 加/扣积分：兑吧订单号、用户id、操作类型（加积分、扣积分）、时间、活动ID、状态（成功、失败）、积分值
     */
    private ReconciliationRecordDto wrapReconciliationLog(Long appId, String relationId, String relationType, String authParams, Map<String, String> paramMap, ReconciliationLogTypeEnum logTypeEnum) {
        Map<String, String> authParamMap = AssembleTool.getUrlParams(authParams);
        ReconciliationRecordDto reconciliationRecordDto = new ReconciliationRecordDto();
        reconciliationRecordDto.setOrderNum(relationId);
        reconciliationRecordDto.setPartnerUserId(authParamMap.get("uid"));
        reconciliationRecordDto.setLogType(logTypeEnum.getCode());
        reconciliationRecordDto.setSendTime(new Date());

        if(MapUtils.isNotEmpty(paramMap)){
            reconciliationRecordDto.setOptId(paramMap.get("opId"));
        }

        if(StringUtils.isNotBlank(relationType)){
            reconciliationRecordDto.setOptType(relationType);
        }
        String credits = authParamMap.get("credits");
        if(StringUtils.isNotBlank(credits)){
            reconciliationRecordDto.setCredits(Long.valueOf(credits));
        }

        reconciliationRecordDto.setAppId(appId);

        return reconciliationRecordDto;
    }

    /**
     * 构造加积分请求
     */
    public CreditsMessageDto getAddCreditsMessage(CreditsMessageDto request){
        String url = request.getHttpUrl();
        String authParams = url.substring(url.indexOf('?') + 1);
        ReconciliationRecordDto dto = wrapReconciliationLog(Long.valueOf(request.getAppId()), request.getRelationId(), request.getRelationType(), authParams, request.getParams(), ReconciliationLogTypeEnum.ADD_CREDITS);
        executorService.execute(() -> {
            try{
                reconciliationRecordService.saveOrUpdate(dto);
            }catch (Exception e){
                logger.error("save青岛农商行对账记录出错, appId:{}, relationId:{}, optId:{}, relationType:{}, ", dto.getAppId(), dto.getOrderNum(), dto.getOptId(), dto.getOptType(), e);
            }
        });
        return request;
    }

    public void mallExchangeNotify(ReconciliationRecordDto dto){
        reconciliationRecordService.saveOrUpdate(dto);
    }

    /**
     * 解析积分响应
     * @param appId
     * @param body
     * @param addCredits
     * @param relationId
     * @param relationType
     * @return
     */
    public String parseCreditsRsp(Long appId, String body, Boolean addCredits, String relationId, String relationType) {
        executorService.execute(() -> {
            try{
                ReconciliationRecordDto reconciliationRecordDto = new ReconciliationRecordDto();
                reconciliationRecordDto.setOrderNum(relationId);
                reconciliationRecordDto.setLogType(ReconciliationLogTypeEnum.SUB_CREDITS.getCode());
                reconciliationRecordDto.setAppId(appId);
                reconciliationRecordDto.setOptType(relationType);
                if(addCredits){
                    reconciliationRecordDto.setLogType(ReconciliationLogTypeEnum.ADD_CREDITS.getCode());
                }
                parseRespBody(body, reconciliationRecordDto);

                reconciliationRecordService.update(reconciliationRecordDto);
            }catch (Exception e){
                logger.error("update青岛农商行响应结果出错, appId:{}, relationId:{}, relationType:{}, body:{}, ", appId, relationId, relationType, body, e);
            }
        });

        return body;
    }

    private void parseRespBody(String body, ReconciliationRecordDto dto){
        String respBody = body;
        if(StringUtils.isNotBlank(body)){
            dto.setResponseStatus(ReconciliationRespStatusEnum.FAIL.getCode());
            JSONObject json = JSON.parseObject(body);
            if (json != null && ("success".equalsIgnoreCase(json.getString("status")) || "ok".equalsIgnoreCase(json.getString("status")))) {
                dto.setResponseStatus(ReconciliationRespStatusEnum.SUCCESS.getCode());
            }

            if(respBody.length() > 255){
                respBody = respBody.substring(0, 255);
            }
            dto.setResponseBody(respBody);
        }
    }
}

