package cn.com.duiba.biz.credits.impl;

import cn.com.duiba.biz.credits.PinganCardApi;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.constant.PinganCardConfig;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.JsonTool;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author fengjun
 * @Date 2019-10-30
 * @Email: fengjun@duiba.com.cn
 * @Description:
 */
@Service
public class PinganCardApiImpl implements PinganCardApi {

    private static final Logger logger = LoggerFactory.getLogger(PinganCardApiImpl.class);

    // 数字签名，密钥算法
    private static final String RSA_KEY_ALGORITHM = "RSA";

    // 数字签名签名/验证算法
    private static final String SIGNATURE_ALGORITHM = "MD5withRSA";


    /**
     * 分隔符
     */
    private static final String DELIMITER = "?";


    @Autowired
    private PinganCardConfig pinganCardConfig;
    /**
     * 是否平安卡中心APP
     *
     * @param appId
     * @return
     */
    @Override
    public Boolean isPingan(Long appId) {
        return pinganCardConfig.getAppIds().contains(appId);
    }

    /**
     * 平安卡中心发金币-封装虚拟商品接口参数
     *
     * @param request
     * @return
     */
    @Override
    public SupplierRequest getVirturalRequest(SupplierRequest request) {
        String url = request.getHttpUrl();
        //  解析URL，获取网关地址，请求参数
        List<String> analysisList = analysisUrl(url);
        if (CollectionUtils.isEmpty(analysisList)) {
            return request;
        }
        String host = analysisList.get(0);
        Map<String, String> params = AssembleTool.getUrlParams(analysisList.get(1));
        String paramString =buildGiveGoldenCoinsParams(
                params.get("orderNum")
                ,params.get("uid")
                ,params.get("params"));
        //Map<String, String> authParams =AssembleTool.getUrlParams(paramString);
        //request.setAuthParams(authParams);
        request.setHttpUrl(host+"?"+paramString);
        return request;
    }

    /**
     * 解析虚拟商品接口开发者请求响应
     *
     * @param body
     * @return
     */
    @Override
    public String getVirturalResponse(String body) {
        Map<String, String> duibaDoc = new HashMap<>();
        try {
            String data = checkResponse(body);
            duibaDoc.put("status", "success");
            duibaDoc.put("data", data);
        } catch (Exception e) {
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", e.getMessage());
            logger.info("[PinganCardApiImpl-getVirturalResponse]平安卡中心-虚拟商品请求响应解析异常:", e);
        }
        return JsonTool.objectToJson(duibaDoc);
    }

    /**
     * 解析response
     *
     * @param result
     * @return
     * @throws BizException
     */
    private String checkResponse(String result) throws BizException {
        JSONObject resultJson = JSONObject.parseObject(result);
        if (null == resultJson) {
            throw new BizException("平安卡中心解析返回体失败");
        }
        if (!"000000".equals(resultJson.getString("responseCode"))) {
            logger.warn("平安卡中心双十一剁手 发金币返回失败，{}", resultJson.toJSONString());
            throw new BizException("金币发放异常："+resultJson);
        }else {
            return "发金币成功";
        }


    }


    /**
     * 发金币
     */
    /*private void givePlayerGoldenCoins(UserRequestContext context, JoinUserRequestApi api, String orderId,String activityId) {
        //第一步给用户发放已经获得金币的道具，防止再次获得金币
        String accesstoken = getAccessToken();
        String openId = context.getPartnerUserId();
        String url = buildGiveGoldenCoinsUrl(accesstoken, orderId, openId, activityId);
        logger.info("发金币入参：{}",url);
        JSONObject response = null;
        try {
            response = JSONObject.parseObject(HttpClient.doGet(url));
            logger.info("发金币返回参数：{}",response);
        } catch (Exception e) {
            logger.error("平安卡中心双十一剁手 发金币失败，{}", url);
            throw new BizRuntimeException(100115, "网络异常，请稍候再试");

        }
        if (!"000000".equals(response.getString("responseCode"))) {
            logger.error("平安卡中心双十一剁手 发金币返回失败，{}", response.toJSONString());
            throw new BizRuntimeException(100115, "金币发放异常，请稍候再试");
        }

    }*/

    private String buildGiveGoldenCoinsParams(String outsourceId, String openId, String thirdActiviId) {
        //MD5( timeStamp+openId+thirdPart + ActivityCode + outsourceId+私钥)
        StringBuilder stringBuilder = new StringBuilder();
        Long now = System.currentTimeMillis();

        String originalValue = now + openId + pinganCardConfig.getThirdPart()
                + thirdActiviId + outsourceId + pinganCardConfig.getInterfaceKey();
        String sign = DigestUtils.md5Hex(originalValue);

//        不断重试获取token
        String accessToken=null;
        int tokenFlag=0;

        while (StringUtils.isBlank(accessToken)){
            tokenFlag++;
            accessToken=getAccessToken();

            if (tokenFlag>=4){
                logger.warn("平安卡中心 发金币连续3次失败！");
                break;
            }
        }

        stringBuilder//.append(pinganCardConfig.getGiveCoinsUrl())
                .append("channel=").append(pinganCardConfig.getChannel())
                .append("&accessToken=").append(accessToken)
                .append("&thirdPart=").append(pinganCardConfig.getThirdPart())
                .append("&sign=").append(sign)
                .append("&timeStamp=").append(now)
                .append("&outsourceId=").append(outsourceId)
                .append("&openId=").append(openId)
                .append("&activityCode=").append(thirdActiviId);
        return stringBuilder.toString();
    }


    private String getAccessToken() {
        StringBuilder stringBuilder = new StringBuilder();
        Double random = Math.random() * 10000;
        Long timestamp = System.currentTimeMillis();
        String data = pinganCardConfig.getChannel() + ";" + random.longValue() + ";" + timestamp;
        try {
            //PrivateKey privateKey=getPrivateKey(PRIVATE_KEY);
            String sign = sign(data.getBytes(), pinganCardConfig.getPrivateKey());
            stringBuilder.append(pinganCardConfig.getAccessTokenUrl())
                    .append("channel=").append(pinganCardConfig.getChannel())
                    .append("&random=").append(random.longValue())
                    .append("&timestamp=").append(timestamp)
                    .append("&sign=").append(sign);
            JSONObject response = JSONObject.parseObject(doGet(stringBuilder.toString()));
            return response.getString("accessToken");
        } catch (Exception e) {
            logger.warn("平安卡中心 双十一剁手 生成公钥失败，{}", data, e);
            return null;
        }


    }

    /**
     * 数字签名
     *
     * @param data    待签名数据
     * @param pri_key 私钥
     * @return 签名
     * @throws Exception 抛出异常
     */
    public static String sign(byte[] data, String pri_key) throws Exception {
        // 取得私钥
        byte[] pri_key_bytes = Base64.decodeBase64(pri_key);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(pri_key_bytes);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_KEY_ALGORITHM);
        // 生成私钥
        PrivateKey priKey = keyFactory.generatePrivate(pkcs8KeySpec);
        // 实例化Signature
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        // 初始化Signature
        signature.initSign(priKey);
        // 更新
        signature.update(data);

        return Base64.encodeBase64String(signature.sign());
    }

    private static RequestConfig config = RequestConfig.custom()
            .setConnectionRequestTimeout(2000)
            .setConnectTimeout(2000)
            .setSocketTimeout(2000)
            .build();

    public static String doGet(String url) throws Exception {
        CloseableHttpClient httpclient = HttpClients.custom().setDefaultRequestConfig(config).build();
        CloseableHttpResponse response=null;
        try {
            HttpGet httpget = new HttpGet(url);
            response = httpclient.execute(httpget);
            if (response.getStatusLine().getStatusCode() == 200) {
                return EntityUtils.toString(response.getEntity(), "UTF-8");
            }
        } catch (Exception e) {
            //logger.error("httpclient.doGet:{}" + e.getMessage(), url);
            throw e;
        } finally {
            try {
                if (null!=response){
                    response.close();
                }
            } catch (IOException e) {
               // logger.error("httpclient.close:" + e.getMessage());
            }
        }
        return null;
    }


    /**
     * 解析URL，获取网关地址和参数串
     *
     * @param url
     * @return java.lang.String
     * @throw
     */
    private static List<String> analysisUrl(String url) {
        List<String> analysis = Lists.newArrayList();
        if (StringUtils.isNotBlank(url)) {
            int index = url.indexOf(DELIMITER);
            if (index != -1) {
                analysis.add(url.substring(0, index));
                analysis.add(url.substring(index + 1, url.length()));
            } else {
                analysis.add(url);
                analysis.add("");
            }
        }
        return analysis;
    }
}
