package cn.com.duiba.biz.virtual.supplier;

import cn.com.duiba.biz.credits.GangZhongLvApi;
import cn.com.duiba.biz.credits.QiaQiaApi;
import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.constant.QiaQiaConfig;
import cn.com.duiba.domain.RequestTypeEnum;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.domain.SupplierResponse;
import cn.com.duiba.mq.RocketMQMsgProducer;
import cn.com.duiba.service.CustomService;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.service.MessageService;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.CaiNiaoTool;
import cn.com.duiba.tool.HttpRequestLog;
import cn.com.duiba.tool.JsonTool;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 虚拟商品接口请求
 */
@Service
public class VirtualSupplier {

	private static Logger log = LoggerFactory.getLogger(VirtualSupplier.class);

	@Autowired
	private MessageService messageService;
	@Autowired
	private RocketMQMsgProducer rocketMQMsgProducer;
	@Autowired
	private HttpAsyncClientPool httpAsyncClientPool;
	@Autowired
	private CustomService customService;
	@Autowired
	private GangZhongLvApi gangZhongLvApi;
	@Autowired
	private QiaQiaApi qiaQiaApi;

	/**
	 * 提交到HTTP请求池
	 *
	 * @param mes
	 * @param callbackTopic
	 * @param msgTag
	 * @param msgKey
	 */
	public void asyncSubmit(SupplierRequest mes, final String callbackTopic, final String msgTag, final String msgKey) {
		final SupplierRequest message = customService.getVirturalRequest(mes);
		HttpRequestLog.logUrl("[action virtual][request bizId " + message.getOrderId() + "] [url " + message.getHttpUrl() + "][authParams " + message.getAuthParams() + "]");
 		HttpRequestBase http = getRequest(message);
		httpAsyncClientPool.submit(message.getAppId(), http, new FutureCallback<HttpResponse>() {

			@Override
			public void completed(HttpResponse response) {
				SupplierResponse resp = new SupplierResponse();
				try {
					resp.setOrderId(message.getOrderId());
					resp.setSupplierOrderId(message.getSupplierOrderId());
					resp.setSupplierName(message.getSupplierName());
					resp.setUrl(message.getHttpUrl());
					resp.setCallbackType(SupplierResponse.CALLBACK_TYPE_COMPLETED);
					resp.setAppId(message.getAppId());
					resp.setConsumerId(message.getConsumerId());

					Header header = response.getEntity().getContentEncoding();
					String result;
					if (header != null && header.toString().contains(CaiNiaoTool.CONTENT_ENCODING_GZIP)) {
						result = EntityUtils.toString(new GzipDecompressingEntity(response.getEntity()));
					} else {
						result = EntityUtils.toString(response.getEntity());
					}
					String body = customService.getVirturalResponse(message, result);
					resp.setBody(HttpRequestLog.subBody(body));
				} catch (Exception e) {
					log.error("VirtualSupplier completed", e);
				} finally {
					finallyBlock(message, resp, callbackTopic, msgTag, msgKey, Integer.toString(response.getStatusLine().getStatusCode()));
				}
			}

			@Override
			public void failed(Exception ex) {
				log.error("VirtualSupplier failed orderId:" + message.getOrderId(), ex);
				SupplierResponse resp = new SupplierResponse();
				try {
					resp.setOrderId(message.getOrderId());
					resp.setSupplierOrderId(message.getSupplierOrderId());
					resp.setCallbackType(SupplierResponse.CALLBACK_TYPE_FAILED);
					resp.setAppId(message.getAppId());
					resp.setConsumerId(message.getConsumerId());
					resp.setErrorMessage(ex.getClass().getName() + ":" + ex.getMessage());
				} catch (Exception e) {
					log.error("VirtualSupplier completed", e);
				} finally {
					finallyBlock(message, resp, callbackTopic, msgTag, msgKey, "");
				}
			}

			@Override
			public void cancelled() {
				SupplierResponse resp = new SupplierResponse();
				try {
					resp.setOrderId(message.getOrderId());
					resp.setSupplierOrderId(message.getSupplierOrderId());
					resp.setCallbackType(SupplierResponse.CALLBACK_TYPE_CANCELLED);
					resp.setAppId(message.getAppId());
					resp.setConsumerId(message.getConsumerId());
				} catch (Exception e) {
					log.error("VirtualSupplier cancelled", e);
				} finally {
					finallyBlock(message, resp, callbackTopic, msgTag, msgKey, "");
				}
			}

		}, RequestTypeEnum.VIRTUAL);

	}

	private HttpRequestBase getRequest(SupplierRequest message){//NOSONAR
		HttpRequestBase http=null;
		Long appId = Long.valueOf(message.getAppId());
		if(customService.isMobike(appId)){
			http= AssembleTool.assembleRequest(message.getHttpUrl(), message.getAuthParams());
			String time=message.getParams().get("time");
			if(StringUtils.isNotEmpty(time)){//摩拜需要在header中传递参数
				http.setHeader(new BasicHeader("time",time));
				http.setHeader(new BasicHeader("accesstoken",message.getParams().get("accesstoken")));
			}
		} else if(customService.isIqiyi(appId)
				|| customService.isWeibo(appId)
				|| customService.isPayqb(appId)
				|| customService.isSuning(appId)){
			http= AssembleTool.assembleRequest(message.getHttpUrl(), message.getAuthParams());
		} else if(customService.isAliTrip(appId)){
			http = CaiNiaoTool.setHttpRequestHeader(message.getHttpUrl(), message.getAuthParams());
		} else if(customService.isHaiDiLao(appId)){
			http = customService.setHaidilaoVirtualHttpHeader( message, http);
		} else if (customService.isFunHeadlines(appId)) {
			http = customService.resetFunHeadlinesVirtualHttpType(message, http);
		} else if(customService.isRenrenTv(appId)) {
		    http = customService.setRenrenVirtualHttpHeader(message);
        } else if(customService.isSns(appId)){
			http = AssembleTool.assembleRequest(message.getHttpUrl(), message.getAuthParams());
			customService.setSnsAddHttpHeader(message.getAuthParams(), http);
		} else if (customService.isBeingmate(appId)) {
			http = AssembleTool.assembleRequest(message.getHttpUrl(), message.getAuthParams());
			customService.setBeingmateHttpHeader(http);
		}else if(gangZhongLvApi.isGangZhongLv(appId)){
			http=gangZhongLvApi.getVirtualRequest(message);
		} else if (customService.isWatsons(appId)) {
			if (!SpringEnvironmentUtils.isProdEnv()) {
				log.info("屈臣氏虚拟商品充值请求参数：{}", JSON.toJSONString(message.getAuthParams()));
			}
			http = AssembleTool.assembleRequest(message.getHttpUrl(), message.getAuthParams());
		} else if (customService.isHeBeiMobile(appId)) {
			http = AssembleTool.assembleRequestJson(message.getHttpUrl(), JSON.toJSONString(message.getAuthParams()));
		} else if (qiaQiaApi.isQiaQia(appId)) {
			http = qiaQiaApi.getVirtualRequest(message);
		} else {
			http = new HttpGet(message.getHttpUrl());
		}
		return http;
	}

	private void finallyBlock(SupplierRequest message, SupplierResponse response, String callbackTopic, String msgTag, String msgKey, String code) {
		try {
			response.setUrl(message.getHttpUrl());
			response.setSupplierName(message.getSupplierName());
			response.setSupplierOrderId(message.getSupplierOrderId());
			response.setOrderId(message.getOrderId());
			response.setAppId(message.getAppId());
			response.setConsumerId(message.getConsumerId());
			String body = JsonTool.objectToJson(response);
			HttpRequestLog.logUrl("[action virtual] [tag response] [code "+code+"] [bizId " + message.getOrderId() + "] [body " + response.getBody() + "] [callback " + response.getCallbackType() + "]");
			if(callbackTopic.contains("MQ")){
				rocketMQMsgProducer.sendMsg(callbackTopic, msgTag, msgKey, body,false,null);
			}else{
				messageService.sendMsg(callbackTopic,msgTag,msgKey,body);
			}
		} catch (Exception e) {
			log.error("VirtualSupplier callback:" + message.getOrderId(), e);
		}
	}

}
