package cn.com.duiba.dao.impl;

import cn.com.duiba.constant.DatabaseSchema;
import cn.com.duiba.dao.BaseDAO;
import cn.com.duiba.dao.ConsumerCreditsLogDAO;
import cn.com.duiba.domain.ConsumerCreditsLogDO;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Repository;

import java.util.Map;
import static cn.com.duiba.tool.TableHelper.*;

/**
 * Created by fangdong on 2018/10/17
 */
@Repository("consumerCreditsLogDAO")
public class ConsumerCreditsLogDAOImpl extends BaseDAO implements ConsumerCreditsLogDAO {

    @Override
    public Long insert(ConsumerCreditsLogDO log) {
        Map<String, Object> map = getTbSuffixParamsMap(log.getConsumerId());
        map.putAll(BeanUtils.transBeanToMap(log));

        super.insert("insert", map);
        return log.getId();
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CONSUMER_CRECORD;
    }

}
