package cn.com.duiba.remoteimpl.rcb;

import cn.com.duiba.biz.credits.QingdaoRcbBankApi;
import cn.com.duiba.thirdparty.api.rcb.RemoteRcbBankService;
import cn.com.duiba.thirdparty.dto.reconciliation.ReconciliationRecordDto;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

/**
 * Created by xutao on 2020/6/9.
 */
@RestController
public class RemoteRcbBankServiceImpl implements RemoteRcbBankService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteRcbBankServiceImpl.class);

    @Autowired
    private QingdaoRcbBankApi qingdaoRcbBankApi;

    @Override
    public void mallExchangeNotify(ReconciliationRecordDto reconciliationRecordDto) {
        LOGGER.info("青岛农商行普兑通知，reconciliationRecordDto:{}", JSON.toJSON(reconciliationRecordDto));
        if(!qingdaoRcbBankApi.isQingdaoRcbBank(reconciliationRecordDto.getAppId())){
            return;
        }
        qingdaoRcbBankApi.mallExchangeNotify(reconciliationRecordDto);
    }
}
