package cn.com.duiba.tool.sn;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class Permutation {

    public static String sort(Map payloadMap, String charset) throws UnsupportedEncodingException {
        Map sortedMap = new TreeMap();
        if ((payloadMap != null) && (payloadMap.size() > 0)) {
            sortedMap.putAll(payloadMap);
        }
        StringBuilder sb = new StringBuilder();
        Set<Map.Entry<String, Object>> entrySet = sortedMap.entrySet();
        boolean hasParam = false;
        for (Map.Entry entry : entrySet) {
            String name = (String) entry.getKey();
            String valStr = null;
            Object value = entry.getValue();
            if (value instanceof Map)
                valStr = sort((Map) value, charset);
            else if (value instanceof List)
                valStr = sortList((List) value, charset);
            else {
                valStr = (value == null) ? "" : value.toString();
            }
            if (hasParam)
                sb.append("&");
            else {
                hasParam = true;
            }
            sb.append(name).append("=").append(URLEncoder.encode(valStr, charset));
        }
        return sb.toString();
    }

    private static String sortList(List value, String charset) throws UnsupportedEncodingException {
        StringBuilder listStr = new StringBuilder();
        List list = value;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) instanceof Map)
                listStr.append(sort((Map) list.get(i), charset));
            else if (list.get(i) instanceof List)
                listStr.append(sortList((List) list.get(i), charset));
            else {
                listStr.append((list.get(i) == null) ? "" : list.get(i).toString());
            }
        }
        return listStr.toString();
    }
}
