/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.api.bo.credits.CreditsRequest;
import cn.com.duiba.api.bo.credits.CreditsResponse;
import cn.com.duiba.biz.credits.CustomQueryCreditsToDeveloper;
import cn.com.duiba.biz.credits.ErweihuoApi;
import cn.com.duiba.biz.credits.GangZhongLvApi;
import cn.com.duiba.biz.credits.ReconciliationBizService;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.dao.HttpMessageDAO;
import cn.com.duiba.domain.HttpMessageDO;
import cn.com.duiba.domain.RequestTypeEnum;
import cn.com.duiba.order.center.api.dto.CreditsCallbackMessage;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.service.ConsumerCreditsLogService;
import cn.com.duiba.service.CustomService;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.service.HttpRetryRulesService;
import cn.com.duiba.service.MessageService;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.thirdparty.enums.CallbackChannelTypeEnum;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.HttpRequestLog;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.NumberUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.util.EntityUtils;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AddCreditsToDeveloper {
    private static final Logger LOG = LoggerFactory.getLogger(AddCreditsToDeveloper.class);
    @Autowired
    private HttpAsyncClientPool httpAsyncClientPool;
    @Autowired
    private MessageService messageService;
    @Autowired
    private HttpRetryRulesService httpRetryRulesService;
    @Autowired
    private HttpMessageDAO httpMessageDAO;
    @Autowired
    private DefaultMQProducer rocketMqProducer;
    @Autowired
    private CustomService customService;
    @Autowired
    private ConsumerCreditsLogService consumerCreditsLogService;
    @Resource(name="httpCallbackExecutorService")
    private ExecutorService httpCallbackExecutorService;
    @Autowired
    private ErweihuoApi erweihuoApi;
    @Autowired
    private CustomQueryCreditsToDeveloper customQueryCreditsToDeveloper;
    @Autowired
    private GangZhongLvApi gangZhongLvApi;
    @Autowired
    private ReconciliationBizService reconciliationBizService;

    public void submit(final HttpMessageDO message) {
        CreditsMessageDto creditsMessageDto;
        CreditsMessageDto creditsMessage = JsonTool.jsonToObject(message.getBizParams(), CreditsMessageDto.class);
        try {
            if (creditsMessage == null) {
                return;
            }
            creditsMessageDto = this.customService.getRequestAddCredits(creditsMessage);
            this.reconciliationBizService.saveAddCreditsMsg(creditsMessageDto);
        }
        catch (BizException e) {
            LOG.info("\u52a0\u79ef\u5206\u6d41\u7a0b\u4e2d\u65ad aid={}, cid={}, rid={}, rType={}", new Object[]{creditsMessage.getAppId(), creditsMessage.getConsumerId(), creditsMessage.getRelationId(), creditsMessage.getRelationType()});
            return;
        }
        HttpRequestBase http = this.customService.getAddCreditsHttpRequest(creditsMessage);
        if (http == null) {
            if ("post".equals(creditsMessageDto.getHttpType())) {
                Map authParams = creditsMessageDto.getAuthParams();
                if (MapUtils.isNotEmpty((Map)authParams)) {
                    authParams.remove("appSecret");
                }
                http = AssembleTool.assembleRequest(creditsMessageDto.getHttpUrl(), authParams);
            } else {
                http = new HttpGet(creditsMessageDto.getHttpUrl());
            }
        }
        HttpRequestLog.logUrl("[action addCredits] [request bizId " + creditsMessageDto.getRelationId() + "] [type " + creditsMessageDto.getRelationType() + "] [url " + creditsMessageDto.getHttpUrl() + "][authParams " + creditsMessageDto.getAuthParams() + "][consumerId " + creditsMessageDto.getConsumerId() + "]");
        this.setHeaders(creditsMessageDto, http);
        this.httpAsyncClientPool.submit(creditsMessageDto.getAppId(), (HttpUriRequest)http, new FutureCallback<HttpResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void completed(HttpResponse response) {
                CreditsCallbackMessage resp = new CreditsCallbackMessage();
                try {
                    resp.setCallbackType("completed");
                    Header header = response.getEntity().getContentEncoding();
                    String result = header != null && header.toString().contains("gzip") ? EntityUtils.toString((HttpEntity)new GzipDecompressingEntity(response.getEntity())) : EntityUtils.toString((HttpEntity)response.getEntity());
                    String body = AddCreditsToDeveloper.this.customService.getResponseCredits(NumberUtils.parseLong((String)creditsMessageDto.getAppId(), (long)0L), result, Boolean.TRUE, creditsMessageDto.getAuthParams());
                    AddCreditsToDeveloper.this.reconciliationBizService.updateCreditsRsp(Long.valueOf(creditsMessageDto.getAppId()), body, Boolean.TRUE, creditsMessageDto.getRelationId(), creditsMessageDto.getRelationType());
                    resp.setMessage(HttpRequestLog.subBody(body));
                }
                catch (Exception e) {
                    LOG.error("toDeveloper completed", (Throwable)e);
                }
                finally {
                    AddCreditsToDeveloper.this.finallyBlock(message, creditsMessageDto, resp);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void failed(Exception ex) {
                LOG.error("toDeveloper failed bizId:" + creditsMessageDto.getRelationId() + " bizType:" + creditsMessageDto.getRelationType(), (Throwable)ex);
                CreditsCallbackMessage resp = new CreditsCallbackMessage();
                try {
                    resp.setCallbackType("failed");
                    resp.setMessage(ex.getClass().getName() + ":" + ex.getMessage());
                }
                catch (Exception e) {
                    LOG.error("toDeveloper failed", (Throwable)e);
                }
                finally {
                    AddCreditsToDeveloper.this.finallyBlock(message, creditsMessageDto, resp);
                }
            }

            public void cancelled() {
                LOG.error("toDeveloper cancelled bizId:" + creditsMessageDto.getRelationId() + " bizType:" + creditsMessageDto.getRelationType());
                CreditsCallbackMessage resp = new CreditsCallbackMessage();
                resp.setCallbackType("failed");
                resp.setMessage("http cancelled");
                AddCreditsToDeveloper.this.finallyBlock(message, creditsMessageDto, resp);
            }
        }, RequestTypeEnum.ADD_CREDITS);
    }

    private void setHeaders(CreditsMessageDto message, HttpRequestBase http) {
        Long appId = Long.valueOf(message.getAppId());
        if (this.customService.isHaiDiLao(appId)) {
            CreditsMessage dto = (CreditsMessage)BeanUtils.copy((Object)message, CreditsMessage.class);
            this.customService.setHaidilaoSubAndAddHttpHeader(dto, http);
        } else if (this.customService.isRenrenTv(appId)) {
            this.customService.setRenrenTvSubOrAddHttpHeader(message.getAuthParams(), http);
        } else if (this.customService.isSns(appId)) {
            this.customService.setSnsAddHttpHeader(message.getAuthParams(), http);
        } else if (this.customService.isJJY(appId)) {
            this.customService.setJiuJiuHttpHeader(message.getAuthParams(), http);
        }
    }

    public void finallyBlock(HttpMessageDO message, CreditsMessageDto req, CreditsCallbackMessage resp) {
        HttpRequestLog.logUrl("[action addCredits] [response bizId " + req.getRelationId() + "] [type " + req.getRelationType() + "] [callback " + resp.getCallbackType() + "] [body " + resp.getMessage() + "]");
        if (this.nextRetry(message, resp)) {
            return;
        }
        try {
            if (this.erweihuoApi.isErweihuo(NumberUtils.parseLong((String)req.getAppId(), (long)0L))) {
                this.customQueryCreditsToDeveloper.dealCredits(message, req, resp);
            }
            this.sendBlockMq(message, req, resp);
            this.saveCreditsLog(req, resp);
        }
        catch (Exception e) {
            LOG.error("credits callback: bizId:" + req.getRelationId() + " bizType:" + req.getRelationType(), (Throwable)e);
        }
    }

    public void sendBlockMq(HttpMessageDO message, CreditsMessageDto req, CreditsCallbackMessage resp) {
        resp.setRelationId(req.getRelationId());
        resp.setRelationType(req.getRelationType());
        resp.setParams(req.getParams());
        resp.setAppId(req.getAppId());
        resp.setConsumerId(req.getConsumerId());
        resp.setHttpUrl(req.getHttpUrl());
        String body = JsonTool.objectToJson(resp);
        String callbackTopic = req.getCallbackTopic();
        String callbackTag = req.getCallbackTag();
        String callbackKey = req.getCallbackKey();
        if (req.getParams() != null && CallbackChannelTypeEnum.ROCKETMQ.getType().equals(req.getParams().get("callbackMessageType"))) {
            this.sendRocketMQMessage(callbackTopic, callbackTag, callbackKey, body);
        } else {
            this.messageService.sendMsg(callbackTopic, callbackTag, callbackKey, body);
        }
    }

    public boolean nextRetry(HttpMessageDO message, CreditsCallbackMessage resp) {
        try {
            if (this.isSuccess(resp)) {
                this.httpMessageDAO.delete(message.getId());
                return false;
            }
            if (message.getNumber() >= this.httpRetryRulesService.getRetryNumber(message)) {
                this.httpMessageDAO.delete(message.getId());
                return false;
            }
            this.httpRetryRulesService.updateNextTime(message);
            return true;
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                LOG.error("nextRetry error:{}", (Object)JSONObject.toJSONString((Object)message), (Object)e.getCause());
            }
            LOG.error("nextRetry error:{}", (Object)JSONObject.toJSONString((Object)message), (Object)e);
            return false;
        }
    }

    public boolean isSuccess(CreditsCallbackMessage resp) {
        try {
            String body;
            return "completed".equals(resp.getCallbackType()) && ((body = resp.getMessage().toLowerCase()).contains("ok") || body.contains("success"));
        }
        catch (Exception e) {
            LOG.error("isSuccess", (Throwable)e);
            return true;
        }
    }

    private void sendRocketMQMessage(String topic, String tag, String key, String message) {
        Message msg = new Message(topic, tag, key, message.getBytes(Charset.forName("utf-8")));
        try {
            this.rocketMqProducer.send(msg);
        }
        catch (Exception e) {
            LOG.error("addCredits sendRocketMQMessage", (Object)e.getMessage());
        }
    }

    private void saveCreditsLog(CreditsMessageDto request, CreditsCallbackMessage response) {
        this.httpCallbackExecutorService.execute(() -> {
            if (response == null || StringUtils.isBlank((String)response.getMessage())) {
                return;
            }
            try {
                JSONObject json;
                if ("completed".equals(response.getCallbackType()) && (json = JSON.parseObject((String)response.getMessage())) != null && ("success".equalsIgnoreCase(json.getString("status")) || "ok".equalsIgnoreCase(json.getString("status")))) {
                    this.consumerCreditsLogService.save((CreditsRequest)request, (CreditsResponse)response);
                }
            }
            catch (Exception e) {
                String errMsg = this.getErrMsg(e);
                LOG.info("\u79ef\u5206\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25, bizId={}, bizType={}", new Object[]{request.getRelationId(), request.getRelationType(), errMsg});
            }
        });
    }

    private String getErrMsg(Exception e) {
        String causeMsg = "";
        if (StringUtils.isNotBlank((String)e.getMessage())) {
            causeMsg = e.getMessage().length() > 200 ? e.getMessage().substring(0, 200) : e.getMessage();
        }
        return causeMsg;
    }
}

