/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.api.bo.subcredits.SubCreditsMsgDto;
import cn.com.duiba.api.bo.subcredits.SubCreditsResultMsgDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.constant.IcbcElifeConfig;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.dao.custom.IcbcElifeRollbackCreditLogDAO;
import cn.com.duiba.domain.IcbcElifeRollbackCreditLogDO;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.enums.icbcelife.HandlerMannerEnum;
import cn.com.duiba.enums.icbcelife.IcbcElifeActNameEnum;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.HttpRequestLog;
import cn.com.duiba.tool.IcbcSignTool;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IcbcElifeApi {
    private Logger logger = LoggerFactory.getLogger(IcbcElifeApi.class);
    private static final String TRADE_ID = "tradeId";
    private static final String USER_ID = "userId";
    private static final String SCORE = "score";
    private static final String ACT_NAME = "actName";
    private static final String APP_KEY = "app_key";
    private static final String DATA = "data";
    private static final String SIGN = "sign";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String FORMAT = "format";
    private static final String NAME = "name";
    private static final String VERSION = "version";
    private static final String TIME_STAMP = "timestamp";
    private static final String DESC = "description";
    private static final String ORDER_NUM = "orderNum";
    private static final String UID = "uid";
    private static final String CREDITS = "credits";
    private static final String TRADE_TYPE = "tradeType";
    private static final String STATUS = "status";
    private static final String HANDLER = "HandlerManner";
    private static final String ADD_SCORE = "score.add";
    private static final String SUB_SCORE = "score.deduct";
    private static final String CHECK_SCORE = "score.check";
    @Autowired
    private IcbcElifeConfig icbcElifeConfig;
    @Resource(name="httpClient")
    private CloseableHttpClient httpClient;
    @Autowired
    private IcbcElifeRollbackCreditLogDAO icbcElifeRollbackCreditLogDAO;
    @Resource(name="httpCallbackExecutorService")
    private ExecutorService httpCallbackExecutorService;
    @Autowired
    private AppDAO appDAO;

    public CreditsMessage getSubCreditsMessage(CreditsMessage request) {
        try {
            String url = request.getHttpUrl();
            String host = url.substring(0, url.indexOf(63));
            String params = url.substring(url.indexOf(63) + 1);
            Map<String, String> paramMap = AssembleTool.getUrlParams(params);
            request.setHttpType("post");
            request.setHttpUrl(host);
            Map<String, String> authParams = this.buildAuthParams(paramMap, SUB_SCORE, "");
            request.setAuthParams(authParams);
            return request;
        }
        catch (Exception e) {
            this.logger.info("getSubCreditsMessage call CreditsMessage error , CreditsMessage = {}", (Object)JSONObject.toJSONString((Object)request), (Object)e);
            return request;
        }
    }

    public SubCreditsMsgWrapper getSubCreditsMessage(SubCreditsMsgWrapper subCreditsMsgWrapper) {
        try {
            SubCreditsMsgDto subCreditsMsgDto = subCreditsMsgWrapper.getSubCreditsMsg();
            String url = subCreditsMsgWrapper.getHttpUrl();
            String host = url.substring(0, url.indexOf(63));
            String urlParams = url.substring(url.indexOf(63) + 1, url.length());
            Map<String, String> crediMap = AssembleTool.getUrlParams(urlParams);
            subCreditsMsgDto.setHttpType(2);
            subCreditsMsgWrapper.setHttpUrl(host);
            Map<String, String> authParams = this.buildAuthParams(crediMap, SUB_SCORE, subCreditsMsgWrapper.getSubCreditsMsg().getCreditConsumeParams().getItemCode());
            subCreditsMsgWrapper.getSubCreditsMsg().setAuthParams(authParams);
            return subCreditsMsgWrapper;
        }
        catch (Exception e) {
            this.logger.info("getSubCreditsMessage call getSubCreditsMessage error , subCreditsMsgWrapper = {}", (Object)JSONObject.toJSONString((Object)subCreditsMsgWrapper), (Object)e);
            return subCreditsMsgWrapper;
        }
    }

    public CreditsMessageDto getAddCreditsMessage(CreditsMessageDto request) throws BizException {
        try {
            request.setHttpType("post");
            String url = request.getHttpUrl();
            String host = url.indexOf(63) == -1 ? url : url.substring(0, url.indexOf(63));
            request.setHttpUrl(host);
            Map<String, String> authParams = this.buildAuthParams(request.getAuthParams(), ADD_SCORE, "");
            request.setAuthParams(authParams);
            return request;
        }
        catch (Exception ex) {
            this.logger.info("getAddCreditsMessage call getSubCreditsMessage error , request = {}", (Object)JSONObject.toJSONString((Object)request), (Object)ex);
            throw new BizException("\u5de5\u884c\u5361\u52a0\u79ef\u5206\u6d41\u7a0b\u4e2d\u65ad");
        }
    }

    public String parseCreditsRsp(String body) {
        JSONObject jsonBody;
        try {
            jsonBody = JSON.parseObject((String)body);
        }
        catch (Exception e) {
            this.logger.error("JSON.parseObject:", (Throwable)e);
            return body;
        }
        JSONObject json = JsonTool.getAllJson(jsonBody);
        HashMap<String, String> duibaDoc = new HashMap<String, String>();
        String status = json.getString("code");
        if ("0".equals(status)) {
            duibaDoc.put(STATUS, "ok");
            duibaDoc.put(CREDITS, String.valueOf(json.getLongValue(SCORE)));
        } else {
            duibaDoc.put("errorCode", status);
            duibaDoc.put(STATUS, "fail");
            duibaDoc.put("errorMessage", json.getString("msg"));
        }
        return JsonTool.objectToJson(duibaDoc);
    }

    private Map<String, String> buildAuthParams(Map<String, String> originAuthParams, String type, String itemCode) throws UnsupportedEncodingException {
        IcbcElifeActNameEnum code;
        HashMap authParams = Maps.newHashMap();
        HashMap dataParam = Maps.newHashMap();
        dataParam.put(TRADE_ID, originAuthParams.get(ORDER_NUM));
        dataParam.put(USER_ID, originAuthParams.get(UID));
        dataParam.put(SCORE, originAuthParams.get(CREDITS));
        String actCode = "";
        String transfer = originAuthParams.get("transfer");
        if (StringUtils.isNotBlank((String)transfer)) {
            String[] transArr = transfer.split("=");
            if (transArr.length == 2) {
                actCode = transArr[1];
            } else {
                String[] transArrDecode = (transfer = URLDecoder.decode(transfer, "UTF-8")).split("=");
                if (transArrDecode.length == 2) {
                    actCode = transArrDecode[1];
                }
            }
        }
        if (StringUtils.isNotBlank((String)itemCode)) {
            actCode = itemCode;
        }
        if (null != (code = IcbcElifeActNameEnum.getByName(originAuthParams.get(DESC)))) {
            actCode = code.getCode();
        }
        dataParam.put(ACT_NAME, actCode);
        authParams.put(APP_KEY, this.icbcElifeConfig.getAppKey());
        authParams.put(ACCESS_TOKEN, "");
        authParams.put(FORMAT, "json");
        authParams.put(NAME, type);
        authParams.put(VERSION, "1.0");
        authParams.put(TIME_STAMP, DateUtils.getSecondStr((Date)new Date()));
        authParams.put(DATA, URLEncoder.encode(JSON.toJSONString((Object)dataParam), "UTF-8"));
        authParams.put(SIGN, IcbcSignTool.createSign(authParams, this.icbcElifeConfig.getAppSecret()));
        return authParams;
    }

    public boolean rollbackCredits(NotifyQueueDO queue) {
        String notifyUrl = this.appDAO.getAppByCache(queue.getAppId()).getCreditsConsumeNotifyUrl();
        if (StringUtils.isBlank((String)notifyUrl)) {
            return false;
        }
        Map<String, Object> checkSubMap = this.checkSubCredits(queue, notifyUrl);
        Integer type = (Integer)checkSubMap.get(HANDLER);
        if (HandlerMannerEnum.END.getType() == type.intValue() || !Objects.equals(checkSubMap.get(TRADE_TYPE), "1")) {
            return true;
        }
        if (HandlerMannerEnum.RETRY.getType() == type.intValue()) {
            return false;
        }
        Integer score = (Integer)checkSubMap.get(SCORE);
        String actCode = (String)checkSubMap.get(ACT_NAME);
        IcbcElifeRollbackCreditLogDO icbcElifeRollbackCreditLogDO = this.buildIcbcElifeRollbackCreditLog(actCode, queue);
        HandlerMannerEnum checkRollback = this.verificationBizId(icbcElifeRollbackCreditLogDO, score.intValue(), notifyUrl);
        return HandlerMannerEnum.END.getType() == checkRollback.getType();
    }

    private HandlerMannerEnum verificationBizId(IcbcElifeRollbackCreditLogDO icbclog, long score, String notifyUrl) {
        try {
            IcbcElifeRollbackCreditLogDO ierbcl = this.icbcElifeRollbackCreditLogDAO.select(icbclog.getAppId(), icbclog.getOrderNum());
            if (ierbcl == null) {
                String uuid = UUID.randomUUID().toString().replaceAll("-", "") + "_" + icbclog.getOrderNum();
                icbclog.setBizId(uuid);
                icbclog.setIsAddCreditsSucess(false);
                this.icbcElifeRollbackCreditLogDAO.insert(icbclog);
                return this.addRollbackCredits(icbclog, String.valueOf(score), ADD_SCORE, notifyUrl);
            }
            if (ierbcl.getIsAddCreditsSucess()) {
                return HandlerMannerEnum.END;
            }
            if (StringUtils.isBlank((String)icbclog.getBizId())) {
                this.logger.error("bizId is null: {}" + JSONObject.toJSONString((Object)icbclog));
                throw new BizException("bizId is null");
            }
            HandlerMannerEnum checkhme = this.checkRollbackCredits(icbclog.getBizId(), notifyUrl);
            if (HandlerMannerEnum.EXECUTE.getType() == checkhme.getType()) {
                return this.addRollbackCredits(icbclog, String.valueOf(score), ADD_SCORE, notifyUrl);
            }
            return checkhme;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            return HandlerMannerEnum.RETRY;
        }
    }

    private Map<String, Object> checkSubCredits(NotifyQueueDO queue, String notifyUrl) {
        String result = this.checkCredits(queue.getDuibaOrderNum(), notifyUrl);
        HashMap map = Maps.newHashMap();
        try {
            JSONObject jsonBody = JSON.parseObject((String)result);
            JSONObject jsonCheck = JsonTool.getAllJson(jsonBody);
            if ("fail".equals(jsonCheck.getString(STATUS))) {
                map.put(HANDLER, HandlerMannerEnum.END.getType());
            } else {
                map.put(SCORE, jsonCheck.getIntValue(SCORE));
                map.put(ACT_NAME, jsonCheck.getString(ACT_NAME));
                map.put(TRADE_TYPE, jsonCheck.getString(TRADE_TYPE));
                map.put(STATUS, jsonCheck.getString(STATUS));
                map.put(TRADE_ID, jsonCheck.getString(TRADE_ID));
                map.put(HANDLER, HandlerMannerEnum.EXECUTE.getType());
            }
        }
        catch (Exception e) {
            this.logger.error("rollbackCredits JSON.parseObject:", (Throwable)e);
            map.put(HANDLER, HandlerMannerEnum.RETRY.getType());
        }
        return map;
    }

    private HandlerMannerEnum checkRollbackCredits(String bizId, String notifyUrl) {
        String result = this.checkCredits(bizId, notifyUrl);
        JSONObject jsonBody = null;
        try {
            jsonBody = JSON.parseObject((String)result);
            JSONObject jsonCheck = JsonTool.getAllJson(jsonBody);
            if ("success".equals(jsonCheck.getString(STATUS))) {
                return HandlerMannerEnum.END;
            }
            return HandlerMannerEnum.EXECUTE;
        }
        catch (Exception e) {
            this.logger.error("rollbackCredits JSON.parseObject: {}", (Object)jsonBody, (Object)e);
            return HandlerMannerEnum.RETRY;
        }
    }

    private String checkCredits(String orderNum, String notifyUrl) {
        String result = "";
        try {
            HashMap authParams = Maps.newHashMap();
            HashMap dataParam = Maps.newHashMap();
            dataParam.put(TRADE_ID, orderNum);
            authParams.put(APP_KEY, this.icbcElifeConfig.getAppKey());
            authParams.put(ACCESS_TOKEN, "");
            authParams.put(FORMAT, "json");
            authParams.put(NAME, CHECK_SCORE);
            authParams.put(VERSION, "1.0");
            authParams.put(TIME_STAMP, DateUtils.getSecondStr((Date)new Date()));
            authParams.put(DATA, URLEncoder.encode(JSON.toJSONString((Object)dataParam), "UTF-8"));
            authParams.put(SIGN, IcbcSignTool.createSign(authParams, this.icbcElifeConfig.getAppSecret()));
            result = this.doPost(authParams, orderNum, notifyUrl);
        }
        catch (Exception e) {
            this.logger.error("icbcElife checkCredits error, result:{} ", (Object)result, (Object)e);
        }
        return result;
    }

    private HandlerMannerEnum addRollbackCredits(IcbcElifeRollbackCreditLogDO logDO, String score, String type, String notifyUrl) {
        int rollbackType = 1;
        String result = "";
        try {
            HashMap dataParam = Maps.newHashMap();
            dataParam.put(ORDER_NUM, logDO.getBizId());
            dataParam.put(UID, logDO.getPartnerUserId());
            dataParam.put(CREDITS, score);
            Map<String, String> authParams = this.buildAuthParams(dataParam, type, logDO.getActCode());
            logDO.setRequestParam(JSON.toJSONString(authParams));
            result = this.doPost(authParams, logDO.getOrderNum(), notifyUrl);
            JSONObject jsonBody = JSON.parseObject((String)result);
            JSONObject jsonCheck = JsonTool.getAllJson(jsonBody);
            String status = jsonCheck.getString("code");
            rollbackType = "0".equals(status) ? HandlerMannerEnum.END.getType() : HandlerMannerEnum.RETRY.getType();
        }
        catch (Exception e) {
            this.logger.error("icbcElife rollbackCredits error ", (Throwable)e);
            result = e.getMessage();
            rollbackType = HandlerMannerEnum.RETRY.getType();
        }
        logDO.setResponseBody(result);
        boolean isSucess = false;
        if (rollbackType == HandlerMannerEnum.END.getType()) {
            isSucess = true;
        }
        this.saveAddCreditsLog(logDO, isSucess);
        return HandlerMannerEnum.getByType(rollbackType);
    }

    private String doPost(Map<String, String> authParams, String orderNum, String notifyUrl) {
        String result = "";
        HttpPost post = new HttpPost(notifyUrl);
        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>(authParams.size());
        for (Map.Entry<String, String> entry : authParams.entrySet()) {
            String value = entry.getValue();
            if (value == null) continue;
            pairs.add(new BasicNameValuePair(entry.getKey(), value));
        }
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, Charset.forName("UTF-8")));
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post);){
            result = EntityUtils.toString((HttpEntity)response.getEntity());
            HttpRequestLog.logUrl("[action Credits-rollback][response bizId " + orderNum + "] [result " + result + "]");
        }
        catch (Exception e) {
            this.logger.info("\u5de5\u884c\u5361\u5b9a\u5236\u79ef\u5206\u56de\u6eda\u63a5\u53e3\u8c03\u7528\u5f02\u5e38 orderNum={}", (Object)orderNum, (Object)e);
            result = e.getMessage();
        }
        return result;
    }

    private IcbcElifeRollbackCreditLogDO buildIcbcElifeRollbackCreditLog(String actCode, NotifyQueueDO queue) {
        IcbcElifeRollbackCreditLogDO icbcElifeRollbackCreditLogDO = new IcbcElifeRollbackCreditLogDO();
        icbcElifeRollbackCreditLogDO.setActCode(actCode);
        icbcElifeRollbackCreditLogDO.setAppId(queue.getAppId());
        icbcElifeRollbackCreditLogDO.setBizId(queue.getDeveloperBizId());
        icbcElifeRollbackCreditLogDO.setConsumerId(queue.getConsumerId());
        icbcElifeRollbackCreditLogDO.setOrderNum(queue.getDuibaOrderNum());
        icbcElifeRollbackCreditLogDO.setPartnerUserId(queue.getPartnerUserId());
        return icbcElifeRollbackCreditLogDO;
    }

    public void addIcbcElifeBizId(SubCreditsMsgWrapper req, SubCreditsResultMsgDto resp) {
        long appId = req.getSubCreditsMsg().getAppId();
        if (!this.isIcbcApp(appId)) {
            return;
        }
        String orderNum = req.getSubCreditsMsg().getCreditConsumeParams().getOrderNum();
        if (StringUtils.isBlank((String)orderNum)) {
            return;
        }
        resp.setBizId(orderNum + "_ICBC");
    }

    private void saveAddCreditsLog(IcbcElifeRollbackCreditLogDO logDO, boolean isSucess) {
        this.httpCallbackExecutorService.execute(() -> {
            if (logDO == null) {
                return;
            }
            try {
                IcbcElifeRollbackCreditLogDO result = this.icbcElifeRollbackCreditLogDAO.select(logDO.getAppId(), logDO.getOrderNum());
                logDO.setIsAddCreditsSucess(isSucess);
                if (isSucess) {
                    logDO.setRecordSucessCount(1);
                }
                if (StringUtils.isNotBlank((String)logDO.getRequestParam()) && logDO.getRequestParam().length() > 500) {
                    logDO.setRequestParam(logDO.getRequestParam().substring(0, 500));
                }
                if (StringUtils.isNotBlank((String)logDO.getResponseBody()) && logDO.getResponseBody().length() > 1000) {
                    logDO.setResponseBody(logDO.getResponseBody().substring(0, 1000));
                }
                if (result == null) {
                    this.icbcElifeRollbackCreditLogDAO.insert(logDO);
                } else {
                    this.icbcElifeRollbackCreditLogDAO.update(logDO);
                }
            }
            catch (Exception e) {
                this.logger.info("\u79ef\u5206\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25, bizId={}, orderNum={}", new Object[]{logDO.getBizId(), logDO.getOrderNum(), e});
            }
        });
    }

    public boolean isIcbcApp(Long appId) {
        return null != appId && this.icbcElifeConfig.getAppIds().contains(appId);
    }
}

