/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.api.bo.subcredits.SubCreditsMsgDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.constant.MiaojieConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.HttpRequestLog;
import cn.com.duiba.tool.JsonTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MiaojieApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(MiaojieApi.class);
    @Autowired
    private MiaojieConfig miaojieConfig;
    @Resource(name="httpClient")
    private CloseableHttpClient httpClient;

    public boolean isMiaojieApp(Long appId) {
        return this.miaojieConfig.getAppIds().contains(appId);
    }

    public CreditsMessage getSubCreditsMessage(CreditsMessage request) throws BizException {
        String timestamp = String.valueOf(System.currentTimeMillis());
        String sign = this.createSign(timestamp);
        String urlCredits = this.getSignUrl(this.miaojieConfig.getCreditsUrl(), timestamp, sign);
        request.setHttpUrl(urlCredits);
        Map originAuthParams = request.getAuthParams();
        String orderNum = (String)originAuthParams.get("orderNum");
        String credits = (String)originAuthParams.get("credits");
        String transfer = (String)originAuthParams.get("transfer");
        String[] transfers = transfer.split("#");
        if (transfers.length != 2) {
            LOGGER.error("MiaojieApi call getSubCreditsMessage transfers error , CreditsMessage = {},transfers={}", (Object)JSONObject.toJSONString((Object)request), (Object)transfers);
            throw new BizException("\u5999\u6d01\u6263\u79ef\u5206\u6d41\u7a0b\u4e2d\u65ad");
        }
        String openIdStr = transfers[0];
        String openId = openIdStr.substring(openIdStr.indexOf("openId=") + 7);
        String mobileStr = transfers[1];
        String mobile = mobileStr.substring(mobileStr.indexOf("mobile=") + 7);
        String type = (String)originAuthParams.get("type");
        String content = StringUtils.equals((String)"hdtool", (String)type) ? "\u5151\u5427\u53c2\u4e0e\u6d3b\u52a8\u6263\u51cf" : (StringUtils.equals((String)"game", (String)type) ? "\u5151\u5427\u53c2\u4e0e\u6e38\u620f\u6263\u51cf" : (StringUtils.equals((String)"alipay", (String)type) || StringUtils.equals((String)"qb", (String)type) || StringUtils.equals((String)"coupon", (String)type) || StringUtils.equals((String)"object", (String)type) || StringUtils.equals((String)"phonebill", (String)type) || StringUtils.equals((String)"phoneflow", (String)type) || StringUtils.equals((String)"virtual", (String)type) ? "\u5151\u5427\u7ebf\u4e0a\u6d88\u8d39\u6263\u51cf" : "\u5151\u5427\u6263\u51cf"));
        HashMap authParams = Maps.newHashMap();
        authParams.put("type", "1");
        authParams.put("mobile", mobile);
        authParams.put("pointInt", credits);
        authParams.put("recordId", orderNum);
        authParams.put("openId", openId);
        authParams.put("content", content);
        authParams.put("postType", "raw");
        authParams.put("unicodeType", "UTF-8");
        request.setAuthParams((Map)authParams);
        request.setHttpType("post");
        return request;
    }

    public SubCreditsMsgWrapper getSubCreditsMessage(SubCreditsMsgWrapper subCreditsMsgWrapper) throws BizException {
        String timestamp = String.valueOf(System.currentTimeMillis());
        String sign = this.createSign(timestamp);
        String urlCredits = this.getSignUrl(this.miaojieConfig.getCreditsUrl(), timestamp, sign);
        subCreditsMsgWrapper.setHttpUrl(urlCredits);
        SubCreditsMsgDto msg = subCreditsMsgWrapper.getSubCreditsMsg();
        Map originAuthParams = msg.getAuthParams();
        String orderNum = (String)originAuthParams.get("orderNum");
        String credits = (String)originAuthParams.get("credits");
        String transfer = (String)originAuthParams.get("transfer");
        String[] transfers = transfer.split("#");
        if (transfers.length != 2) {
            LOGGER.error("MiaojieApi call getSubCreditsMessage transfers error , subCreditsMsgWrapper = {},transfers={}", (Object)JSONObject.toJSONString((Object)subCreditsMsgWrapper), (Object)transfers);
            throw new BizException("\u5999\u6d01\u6263\u79ef\u5206\u6d41\u7a0b\u4e2d\u65ad");
        }
        String openIdStr = transfers[0];
        String openId = openIdStr.substring(openIdStr.indexOf("openId=") + 7);
        String mobileStr = transfers[1];
        String mobile = mobileStr.substring(mobileStr.indexOf("mobile=") + 7);
        String type = (String)originAuthParams.get("type");
        String content = StringUtils.equals((String)"hdtool", (String)type) ? "\u5151\u5427\u53c2\u4e0e\u6d3b\u52a8\u6263\u51cf" : (StringUtils.equals((String)"game", (String)type) ? "\u5151\u5427\u53c2\u4e0e\u6e38\u620f\u6263\u51cf" : (StringUtils.equals((String)"alipay", (String)type) || StringUtils.equals((String)"qb", (String)type) || StringUtils.equals((String)"coupon", (String)type) || StringUtils.equals((String)"object", (String)type) || StringUtils.equals((String)"phonebill", (String)type) || StringUtils.equals((String)"phoneflow", (String)type) || StringUtils.equals((String)"virtual", (String)type) ? "\u5151\u5427\u7ebf\u4e0a\u6d88\u8d39\u6263\u51cf" : "\u5151\u5427\u6263\u51cf"));
        HashMap authParams = Maps.newHashMap();
        authParams.put("type", "1");
        authParams.put("mobile", mobile);
        authParams.put("pointInt", credits);
        authParams.put("recordId", orderNum);
        authParams.put("openId", openId);
        authParams.put("content", content);
        authParams.put("postType", "raw");
        authParams.put("unicodeType", "UTF-8");
        msg.setAuthParams((Map)authParams);
        msg.setHttpType(2);
        return subCreditsMsgWrapper;
    }

    public CreditsMessageDto getAddCreditsMessage(CreditsMessageDto request) throws BizException {
        String timestamp = String.valueOf(System.currentTimeMillis());
        String sign = this.createSign(timestamp);
        String urlCredits = this.getSignUrl(this.miaojieConfig.getCreditsUrl(), timestamp, sign);
        request.setHttpUrl(urlCredits);
        Map originAuthParams = request.getAuthParams();
        String orderNum = (String)originAuthParams.get("orderNum");
        String credits = (String)originAuthParams.get("credits");
        String transfer = (String)originAuthParams.get("transfer");
        String[] transfers = transfer.split("#");
        if (transfers.length != 2) {
            LOGGER.error("MiaojieApi call getAddCreditsMessage transfers error , request = {},transfers={}", (Object)JSONObject.toJSONString((Object)request), (Object)transfers);
            throw new BizException("\u5999\u6d01\u52a0\u79ef\u5206\u6d41\u7a0b\u4e2d\u65ad");
        }
        String openIdStr = transfers[0];
        String openId = openIdStr.substring(openIdStr.indexOf("openId=") + 7);
        String mobileStr = transfers[1];
        String mobile = mobileStr.substring(mobileStr.indexOf("mobile=") + 7);
        String type = (String)originAuthParams.get("type");
        String content = StringUtils.equals((String)"hdtool", (String)type) ? "\u5151\u5427\u53c2\u4e0e\u6d3b\u52a8\u8d60\u9001" : (StringUtils.equals((String)"game", (String)type) ? "\u5151\u5427\u53c2\u4e0e\u6e38\u620f\u8d60\u9001" : (StringUtils.equals((String)"sign", (String)type) ? "\u5151\u5427\u7b7e\u5230\u8d60\u9001" : "\u5151\u5427\u8d60\u9001"));
        String failType = (String)originAuthParams.get("failType");
        if (failType != null) {
            if (StringUtils.equals((String)"1", (String)failType)) {
                content = "\u5151\u5427\u8ba2\u5355\u5931\u8d25\u8fd4\u8fd8\u79ef\u5206";
            } else if (StringUtils.equals((String)"2", (String)failType)) {
                content = "\u5151\u5427\u8ba2\u5355\u53d6\u6d88\u8fd4\u8fd8\u79ef\u5206";
            }
        }
        HashMap authParams = Maps.newHashMap();
        authParams.put("type", "2");
        authParams.put("mobile", mobile);
        authParams.put("pointInt", credits);
        authParams.put("recordId", orderNum);
        authParams.put("openId", openId);
        authParams.put("content", content);
        authParams.put("postType", "raw");
        authParams.put("unicodeType", "UTF-8");
        request.setAuthParams((Map)authParams);
        request.setHttpType("post");
        return request;
    }

    public String getMiaojieResponseCredis(String body, Map<String, String> authParams) {
        JSONObject jsonBody;
        try {
            jsonBody = JSON.parseObject((String)body);
        }
        catch (Exception e) {
            LOGGER.error("JSON.parseObject:body={},error={}", (Object)body, (Object)e.getMessage());
            return body;
        }
        JSONObject json = JsonTool.getAllJson(jsonBody);
        HashMap<String, String> duibaDoc = new HashMap<String, String>();
        String code = json.getString("code");
        String pointCode = json.getString("point_code");
        if ("SUCCESS".equals(code) && "SUC".equals(pointCode)) {
            duibaDoc.put("status", "ok");
        } else {
            duibaDoc.put("status", "fail");
        }
        duibaDoc.put("errorMessage", json.getString("message"));
        duibaDoc.put("bizId", authParams.get("recordId") + "_miaojie");
        String timestamp = String.valueOf(System.currentTimeMillis());
        String sign = this.createSign(timestamp);
        String urlGrade = this.getSignUrl(this.miaojieConfig.getGradeUrl(), timestamp, sign);
        JSONObject params = new JSONObject();
        params.put("openId", (Object)authParams.get("openId"));
        params.put("mobile", (Object)authParams.get("mobile"));
        String credits = this.getCredits(urlGrade, params);
        duibaDoc.put("credits", credits);
        return JsonTool.objectToJson(duibaDoc);
    }

    private String getCredits(String urlGrade, JSONObject params) {
        String credits = null;
        try {
            HttpPost post = new HttpPost(urlGrade);
            StringEntity entity = new StringEntity(params.toJSONString());
            entity.setContentEncoding("utf-8");
            entity.setContentType("application/json");
            post.setEntity((HttpEntity)entity);
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post);){
                String jsondata;
                JSONObject jsondataJ;
                String result = EntityUtils.toString((HttpEntity)response.getEntity());
                JSONObject jsonret = JSONObject.parseObject((String)result);
                String code = jsonret.getString("code");
                if (StringUtils.equals((String)"SUCCESS", (String)code) && (jsondataJ = JSONObject.parseObject((String)(jsondata = jsonret.getString("jsondata")))) != null) {
                    credits = jsondataJ.getString("point");
                }
            }
            catch (Exception e) {
                LOGGER.info("\u5999\u6d01\u5b9a\u5236\u79ef\u5206\u67e5\u8be2\u63a5\u53e3\u8c03\u7528\u5f02\u5e38 params={},error={}", (Object)params.toJSONString(), (Object)e.getMessage());
            }
            return credits;
        }
        catch (Exception e) {
            LOGGER.info("\u5999\u6d01\u5b9a\u5236\u79ef\u5206\u67e5\u8be2\u63a5\u53e3\u8c03\u7528\u5f02\u5e38 params={},error={}", (Object)params.toJSONString(), (Object)e.getMessage());
            return null;
        }
    }

    private String getSignUrl(String url, String timestamp, String sign) {
        return url + "?appkey=" + this.miaojieConfig.getAppkey() + "&timestamp=" + timestamp + "&sign=" + sign;
    }

    private String createSign(String timestamp) {
        String str = timestamp + "&" + this.miaojieConfig.getAppsecret();
        String urlEncode = null;
        try {
            urlEncode = URLEncoder.encode(str.toLowerCase(), "utf-8").toLowerCase();
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("encode error={}", (Object)e.getMessage());
        }
        String strMd5 = DigestUtils.md5Hex((String)urlEncode);
        return strMd5.toLowerCase();
    }

    public HttpRequestBase getMiaojieRequestNotify(NotifyQueueDO record) throws BizException {
        if (StringUtils.isBlank((String)record.getError4developer())) {
            return new HttpPost("http://test.lianwangshenqi.com");
        }
        String transfer = record.getTransfer();
        String timestamp = String.valueOf(System.currentTimeMillis());
        String sign = this.createSign(timestamp);
        String urlNotify = this.getSignUrl(this.miaojieConfig.getNotifyUrl(), timestamp, sign);
        String[] transfers = transfer.split("#");
        if (transfers.length != 2) {
            LOGGER.error("MiaojieApi call getMiaojieRequestNotify transfers error , NotifyQueueDO = {},transfers={}", (Object)JSONObject.toJSONString((Object)record), (Object)transfers);
            throw new BizException("\u5999\u6d01\u52a0\u79ef\u5206\u6d41\u7a0b\u4e2d\u65ad");
        }
        String mobileStr = transfers[1];
        String mobile = mobileStr.substring(mobileStr.indexOf("mobile=") + 7);
        JSONObject param = JSONObject.parseObject((String)record.getError4developer());
        param.put("mobile", (Object)mobile);
        HttpRequestLog.logUrl("[action notify request][bizId " + record.getDuibaOrderNum() + "] [param " + JSONObject.toJSONString((Object)param) + "]");
        HttpPost request = new HttpPost(urlNotify);
        request.setHeader("Content-Type", "application/json");
        request.setEntity((HttpEntity)new StringEntity(param.toJSONString(), Charset.forName("utf-8")));
        return request;
    }

    public String getMiaojieResponseNotify(String body) {
        JSONObject jsonBody;
        try {
            jsonBody = JSON.parseObject((String)body);
        }
        catch (Exception e) {
            LOGGER.error("JSON.parseObject:", (Throwable)e);
            return body;
        }
        JSONObject json = JsonTool.getAllJson(jsonBody);
        String code = json.getString("code");
        String orderPutCode = json.getString("orderPut_code");
        if ("SUCCESS".equals(code) && "SUC".equals(orderPutCode)) {
            return "ok";
        }
        return body;
    }
}

