/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.biz.credits.SubVirtualCurrencyToDeveloper;
import cn.com.duiba.dao.HttpMessageDAO;
import cn.com.duiba.domain.HttpMessageDO;
import cn.com.duiba.job.AbstractDuibaSimpleElasticJob;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.thirdparty.dto.VirtualCurrencyMessage;
import cn.com.duiba.tool.JsonTool;
import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.elasticjob.autoconfigure.annotation.ElasticJob;
import io.elasticjob.lite.api.ShardingContext;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ElasticJob(name="subVirtualCurrencyRetryJob", cron="0/30 * * * * ?", shardingTotalCount=1, overwrite=true)
public class SubVirtualCurrencyRetryJob
extends AbstractDuibaSimpleElasticJob {
    private Logger log = LoggerFactory.getLogger(SubVirtualCurrencyRetryJob.class);
    Cache<Long, AtomicLong> cache = CacheBuilder.newBuilder().expireAfterWrite(3L, TimeUnit.MINUTES).build();
    @Autowired
    private HttpMessageDAO httpMessageDAO;
    @Autowired
    private SubVirtualCurrencyToDeveloper subVirtualCurrencyToDeveloper;
    @Autowired
    private HttpAsyncClientPool httpAsyncClientPool;

    @Override
    public void doProcess(ShardingContext shardingContext) {
        long s = System.currentTimeMillis();
        List<HttpMessageDO> dos = this.httpMessageDAO.findNeedRetry("subVirtualCurrency", 2000);
        if (CollectionUtils.isEmpty(dos)) {
            return;
        }
        for (HttpMessageDO httpMessageDO : dos) {
            if (!this.checkParams(httpMessageDO)) continue;
            if (this.httpAsyncClientPool.canSubmitToAppPool(httpMessageDO.getAppId().toString())) {
                VirtualCurrencyMessage virtualCurrencyMessage = JsonTool.jsonToObject(httpMessageDO.getBizParams(), VirtualCurrencyMessage.class);
                String msgTopic = virtualCurrencyMessage.getMsgTopic();
                String msgTag = virtualCurrencyMessage.getMsgTag();
                String msgKey = virtualCurrencyMessage.getMsgKey();
                Long messageId = httpMessageDO.getId();
                Integer messageNumber = httpMessageDO.getNumber();
                this.subVirtualCurrencyToDeveloper.submit(virtualCurrencyMessage, msgTopic, msgTag, msgKey, messageId, messageNumber);
                continue;
            }
            AtomicLong addCache = (AtomicLong)this.cache.getIfPresent((Object)httpMessageDO.getAppId());
            if (addCache == null) {
                this.cache.put((Object)httpMessageDO.getAppId(), (Object)new AtomicLong(1L));
                continue;
            }
            addCache.incrementAndGet();
        }
        if (this.cache.size() > 0L) {
            for (Map.Entry entry : this.cache.asMap().entrySet()) {
                this.log.warn("scan cannot be submit to queue, appId:{}, times:{}", entry.getKey(), (Object)((AtomicLong)entry.getValue()).get());
            }
        }
        long e = System.currentTimeMillis();
        this.log.info("subVirtualCurrency scan size:{} time:{} ms", (Object)dos.size(), (Object)(e - s));
    }

    private boolean checkParams(HttpMessageDO db) {
        if (db == null || db.getAppId() == null || StringUtils.isBlank((String)db.getBizParams())) {
            return false;
        }
        VirtualCurrencyMessage virtualCurrencyMessage = JsonTool.jsonToObject(db.getBizParams(), VirtualCurrencyMessage.class);
        return virtualCurrencyMessage != null;
    }
}

