/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.api.bo.subcredits.SubCreditsMsgDto;
import cn.com.duiba.api.tools.abc.SHAEncrypt4ABCUtils;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.constant.ZHCreditsConfig;
import cn.com.duiba.dao.custom.ZHCreditsLogDAO;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.ZHCreditsLogDO;
import cn.com.duiba.enums.zhcreditslog.LogStatusEnum;
import cn.com.duiba.enums.zhcreditslog.LogTypeEnum;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.HttpRequestLog;
import cn.com.duiba.tool.JsonTool;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ZHCreditsApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZHCreditsApi.class);
    private static final String DEF_TEXT = "\u79ef\u5206\u8fd4\u8fd8";
    private static final String USER_NM_KEY = "userNm";
    private static final String DESCRIPTION_KEY = "description";
    @Autowired
    private ZHCreditsConfig config;
    @Autowired
    private ZHCreditsLogDAO zhCreditsLogDAO;
    @Resource(name="httpClient")
    private CloseableHttpClient httpClient;

    public boolean isZHApp(Long appId) {
        return this.config.isZHApp(appId);
    }

    public void rollbackCredits(String orderNum) {
        ZHCreditsLogDO lastLog = this.zhCreditsLogDAO.findByOrderNumAndLogType(orderNum, LogTypeEnum.SUB_CREDITS);
        if (lastLog == null) {
            LOGGER.info("\u4e2d\u5b8f\u79ef\u5206\u56de\u6eda\u5931\u8d25--msg=\u672a\u627e\u5230\u6263\u79ef\u5206\u8bb0\u5f55, orderNum={}", (Object)orderNum);
            return;
        }
        try {
            HttpPost post = new HttpPost(this.config.getNewQueryCreditsHost());
            JSONObject remarks = this.generateRollBackRemarks(lastLog);
            ZHCreditsLogDO newLog = this.createAndGetRequestSn(lastLog.getCredits() + "", lastLog.getOrderNum(), lastLog.getAppId(), LogTypeEnum.ROLL_BACK_CREDITS, lastLog.getCid(), lastLog.getUid(), lastLog.getRequestSn(), remarks.toJSONString());
            JSONObject params = new JSONObject();
            params.put("partnerCode", (Object)this.config.getPartnerCode());
            params.put("requestId", (Object)newLog.getRequestSn());
            String timestamp = System.currentTimeMillis() + "";
            params.put("timestamp", (Object)timestamp);
            params.put("transCode", (Object)this.config.getUpdateCreditsTransCode());
            params.put("sign", (Object)SHAEncrypt4ABCUtils.encrypt((String)(this.config.getSalt() + this.config.getPartnerCode() + newLog.getRequestSn() + timestamp)));
            JSONObject reqData = new JSONObject();
            reqData.put("domainCode", (Object)this.config.getWpaId());
            reqData.put("extId", (Object)lastLog.getUid());
            reqData.put("pointSource", (Object)"MCD-DB");
            reqData.put("pointType", (Object)"ROLLBACK");
            reqData.put("originValue", (Object)(lastLog.getCredits() + ""));
            reqData.put("bizId", (Object)("RollBack" + orderNum));
            JSONObject bizInfo = new JSONObject();
            bizInfo.put("consumedBizId", (Object)orderNum);
            reqData.put("bizInfo", (Object)bizInfo);
            params.put("reqData", (Object)reqData);
            StringEntity entity = new StringEntity(params.toJSONString());
            entity.setContentEncoding("utf-8");
            entity.setContentType("application/json");
            post.setEntity((HttpEntity)entity);
            HttpRequestLog.logUrl("[action subCredits-rollback]] [logId = " + newLog.getId() + "][request bizId " + orderNum + "]  [params " + params.toJSONString() + "]");
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post);){
                String result = EntityUtils.toString((HttpEntity)response.getEntity());
                HttpRequestLog.logUrl("[action subCredits-rollback]] [logId = " + newLog.getId() + "][response bizId " + orderNum + "] [result " + result + "]");
                this.zhCreditsLogDAO.updateResponseInfo(newLog.getId(), result);
            }
            catch (Exception e) {
                LOGGER.info("\u4e2d\u5b8f\u5b9a\u5236\u79ef\u5206\u56de\u6eda\u63a5\u53e3\u8c03\u7528\u5f02\u5e38 orderNum={}, cid={}", new Object[]{orderNum, lastLog.getCid(), e});
            }
        }
        catch (Exception ex) {
            LOGGER.info("\u4e2d\u5b8f\u5b9a\u5236\u79ef\u5206\u56de\u6eda\u63a5\u53e3\u7cfb\u7edf\u5f02\u5e38 orderNum={}, cid={}", new Object[]{orderNum, lastLog.getCid(), ex});
        }
    }

    private JSONObject generateRollBackRemarks(ZHCreditsLogDO lastLog) {
        JSONObject remarks = new JSONObject();
        remarks.put("lastRequestSn", (Object)lastLog.getRequestSn());
        String oldRemarks = lastLog.getRemarks();
        if (StringUtils.isBlank((CharSequence)oldRemarks)) {
            remarks.put(USER_NM_KEY, (Object)"");
            remarks.put(DESCRIPTION_KEY, (Object)DEF_TEXT);
            return remarks;
        }
        try {
            JSONObject json = JSONObject.parseObject((String)oldRemarks);
            String desc = json.getString(DESCRIPTION_KEY);
            if (StringUtils.isBlank((CharSequence)desc)) {
                desc = DEF_TEXT;
            }
            remarks.put(USER_NM_KEY, (Object)json.getString(USER_NM_KEY));
            remarks.put(DESCRIPTION_KEY, (Object)desc);
            return remarks;
        }
        catch (Exception e) {
            LOGGER.info("\u89e3\u6790remarks\u9519\u8bef", (Throwable)e);
            remarks.put(USER_NM_KEY, (Object)"");
            remarks.put(DESCRIPTION_KEY, (Object)DEF_TEXT);
            return remarks;
        }
    }

    public CreditsMessageDto getAddCreditsMessage(CreditsMessageDto request) throws BizException {
        try {
            request.setHttpUrl(this.config.getNewQueryCreditsHost());
            Map originAuthParams = request.getAuthParams();
            String orderNum = (String)originAuthParams.get("orderNum");
            String uid = (String)originAuthParams.get("uid");
            String credits = (String)originAuthParams.get("credits");
            String description = (String)originAuthParams.get(DESCRIPTION_KEY);
            String transfer = (String)originAuthParams.get("transfer");
            Long cid = Long.valueOf(request.getConsumerId());
            JSONObject remarks = new JSONObject();
            remarks.put(USER_NM_KEY, (Object)transfer);
            remarks.put(DESCRIPTION_KEY, (Object)description);
            ZHCreditsLogDO log = this.createAndGetRequestSn(credits, orderNum, Long.valueOf(request.getAppId()), LogTypeEnum.ADD_CREDITS, cid, uid, null, remarks.toJSONString());
            HashMap authParams = Maps.newHashMap();
            JSONObject body = new JSONObject();
            body.put("partnerCode", (Object)this.config.getPartnerCode());
            body.put("requestId", (Object)log.getRequestSn());
            String timestamp = System.currentTimeMillis() + "";
            body.put("timestamp", (Object)timestamp);
            body.put("transCode", (Object)this.config.getUpdateCreditsTransCode());
            body.put("sign", (Object)SHAEncrypt4ABCUtils.encrypt((String)(this.config.getSalt() + this.config.getPartnerCode() + log.getRequestSn() + timestamp)));
            JSONObject reqData = new JSONObject();
            reqData.put("domainCode", (Object)this.config.getWpaId());
            reqData.put("extId", (Object)uid);
            reqData.put("pointSource", (Object)"MCD-DB");
            reqData.put("pointType", (Object)"DB-COMMON");
            reqData.put("originValue", (Object)credits);
            reqData.put("bizId", (Object)orderNum);
            body.put("reqData", (Object)reqData);
            authParams.put("body", body.toString());
            authParams.put("isZhCreditsRequest", "1");
            request.setAuthParams((Map)authParams);
            request.setHttpType("post");
            return request;
        }
        catch (Exception ex) {
            LOGGER.info("ZHCreditsApi call getSubCreditsMessage error , request = {}", (Object)JSONObject.toJSONString((Object)request), (Object)ex);
            throw new BizException("\u4e2d\u5b8f\u6263\u79ef\u5206\u6d41\u7a0b\u4e2d\u65ad");
        }
    }

    public CreditsMessage getSubCreditsMessage(CreditsMessage request) throws BizException {
        try {
            request.setHttpUrl(this.config.getNewQueryCreditsHost());
            Map originAuthParams = request.getAuthParams();
            String orderNum = (String)originAuthParams.get("orderNum");
            String uid = (String)originAuthParams.get("uid");
            String description = (String)originAuthParams.get(DESCRIPTION_KEY);
            String transfer = (String)originAuthParams.get("transfer");
            String credits = (String)originAuthParams.get("credits");
            Long cid = Long.valueOf(request.getConsumerId());
            JSONObject remarks = new JSONObject();
            remarks.put(USER_NM_KEY, (Object)transfer);
            remarks.put(DESCRIPTION_KEY, (Object)description);
            String requestSn = this.createAndGetRequestSn(credits, orderNum, Long.valueOf(request.getAppId()), LogTypeEnum.SUB_CREDITS, cid, uid, null, remarks.toJSONString()).getRequestSn();
            HashMap authParams = Maps.newHashMap();
            JSONObject body = new JSONObject();
            body.put("partnerCode", (Object)this.config.getPartnerCode());
            body.put("requestId", (Object)requestSn);
            String timestamp = System.currentTimeMillis() + "";
            body.put("timestamp", (Object)timestamp);
            body.put("transCode", (Object)this.config.getUpdateCreditsTransCode());
            body.put("sign", (Object)SHAEncrypt4ABCUtils.encrypt((String)(this.config.getSalt() + this.config.getPartnerCode() + requestSn + timestamp)));
            JSONObject reqData = new JSONObject();
            reqData.put("domainCode", (Object)this.config.getWpaId());
            reqData.put("extId", (Object)uid);
            reqData.put("pointSource", (Object)"MCD-DB");
            reqData.put("pointType", (Object)"CONSUME");
            reqData.put("originValue", (Object)credits);
            reqData.put("bizId", (Object)orderNum);
            body.put("reqData", (Object)reqData);
            authParams.put("body", body.toString());
            authParams.put("isZhCreditsRequest", "1");
            request.setAuthParams((Map)authParams);
            request.setHttpType("post");
            return request;
        }
        catch (Exception ex) {
            LOGGER.info("ZHCreditsApi call getSubCreditsMessage error , request = {}", (Object)JSONObject.toJSONString((Object)request), (Object)ex);
            throw new BizException("\u4e2d\u5b8f\u6263\u79ef\u5206\u6d41\u7a0b\u4e2d\u65ad");
        }
    }

    public SubCreditsMsgWrapper getSubCreditsMessage(SubCreditsMsgWrapper subCreditsMsgWrapper) throws BizException {
        try {
            subCreditsMsgWrapper.setHttpUrl(this.config.getNewQueryCreditsHost());
            SubCreditsMsgDto msg = subCreditsMsgWrapper.getSubCreditsMsg();
            Map originAuthParams = msg.getAuthParams();
            String orderNum = (String)originAuthParams.get("orderNum");
            String uid = (String)originAuthParams.get("uid");
            String credits = (String)originAuthParams.get("credits");
            String description = (String)originAuthParams.get(DESCRIPTION_KEY);
            String transfer = (String)originAuthParams.get("transfer");
            Long cid = msg.getConsumerId();
            JSONObject remarks = new JSONObject();
            remarks.put(USER_NM_KEY, (Object)transfer);
            remarks.put(DESCRIPTION_KEY, (Object)description);
            String requestSn = this.createAndGetRequestSn(credits, orderNum, msg.getAppId(), LogTypeEnum.SUB_CREDITS, cid, uid, null, remarks.toJSONString()).getRequestSn();
            HashMap authParams = Maps.newHashMap();
            JSONObject body = new JSONObject();
            body.put("partnerCode", (Object)this.config.getPartnerCode());
            body.put("requestId", (Object)requestSn);
            String timestamp = System.currentTimeMillis() + "";
            body.put("timestamp", (Object)timestamp);
            body.put("transCode", (Object)this.config.getUpdateCreditsTransCode());
            body.put("sign", (Object)SHAEncrypt4ABCUtils.encrypt((String)(this.config.getSalt() + this.config.getPartnerCode() + requestSn + timestamp)));
            JSONObject reqData = new JSONObject();
            reqData.put("domainCode", (Object)this.config.getWpaId());
            reqData.put("extId", (Object)uid);
            reqData.put("pointSource", (Object)"MCD-DB");
            reqData.put("pointType", (Object)"CONSUME");
            reqData.put("originValue", (Object)credits);
            reqData.put("bizId", (Object)orderNum);
            body.put("reqData", (Object)reqData);
            authParams.put("body", body.toString());
            authParams.put("isZhCreditsRequest", "1");
            msg.setAuthParams((Map)authParams);
            msg.setHttpType(2);
            return subCreditsMsgWrapper;
        }
        catch (Exception ex) {
            LOGGER.info("ZHCreditsApi call getSubCreditsMessage error , subCreditsMsgWrapper = {}", (Object)JSONObject.toJSONString((Object)subCreditsMsgWrapper), (Object)ex);
            throw new BizException("\u4e2d\u5b8f\u6263\u79ef\u5206\u6d41\u7a0b\u4e2d\u65ad");
        }
    }

    public String parseCreditsRsp(String body, Map<String, String> authParams) {
        ZHCreditsLogDO log;
        JSONObject responseBody;
        try {
            responseBody = JSONObject.parseObject((String)body);
        }
        catch (Exception e) {
            LOGGER.error("JSON.parseObject:", (Throwable)e);
            return body;
        }
        HashMap<String, String> duibaDoc = new HashMap<String, String>();
        if (Objects.equals(responseBody.getString("resCode"), "0000") && Objects.equals(responseBody.getJSONObject("resData").getString("isSaved"), "Y")) {
            duibaDoc.put("status", "ok");
            duibaDoc.put("bizId", "");
        } else {
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", responseBody.getString("resMsg"));
        }
        JSONObject params = JSONObject.parseObject((String)authParams.get("body"));
        String requestId = params.getString("requestId");
        if (requestId != null) {
            duibaDoc.put("bizId", requestId);
        }
        if ((log = this.zhCreditsLogDAO.findByRequestSn(requestId)) != null) {
            this.zhCreditsLogDAO.updateResponseInfo(log.getId(), body);
            String credits = this.queryConsumerCredits(log.getUid());
            if (credits != null) {
                duibaDoc.put("credits", credits);
            }
        }
        return JsonTool.objectToJson(duibaDoc);
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private String queryConsumerCredits(String uid) {
        String string;
        Throwable throwable;
        CloseableHttpResponse response;
        String requestSn;
        block29: {
            block30: {
                String resCode;
                JSONObject json;
                block23: {
                    String string2;
                    block27: {
                        block28: {
                            block24: {
                                String string3;
                                block25: {
                                    block26: {
                                        requestSn = null;
                                        HttpPost post = new HttpPost(this.config.getNewQueryCreditsHost());
                                        requestSn = this.zhCreditsLogDAO.generateNewRequestSn(this.config.getPartnerCode());
                                        JSONObject body = new JSONObject();
                                        body.put("partnerCode", (Object)this.config.getPartnerCode());
                                        body.put("requestId", (Object)requestSn);
                                        String timestamp = System.currentTimeMillis() + "";
                                        body.put("timestamp", (Object)timestamp);
                                        body.put("transCode", (Object)this.config.getGetCreditsTransCode());
                                        body.put("sign", (Object)SHAEncrypt4ABCUtils.encrypt((String)(this.config.getSalt() + this.config.getPartnerCode() + requestSn + timestamp)));
                                        JSONObject reqData = new JSONObject();
                                        reqData.put("domainCode", (Object)this.config.getWpaId());
                                        reqData.put("extId", (Object)uid);
                                        body.put("reqData", (Object)reqData);
                                        StringEntity postEntity = new StringEntity(body.toJSONString(), "utf-8");
                                        postEntity.setContentEncoding("utf-8");
                                        postEntity.setContentType("application/json");
                                        post.setEntity((HttpEntity)postEntity);
                                        response = this.httpClient.execute((HttpUriRequest)post);
                                        throwable = null;
                                        String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
                                        json = JSONObject.parseObject((String)result);
                                        resCode = json.getString("resCode");
                                        if (!Objects.equals(resCode, "0000")) break block23;
                                        JSONObject resData = json.getJSONObject("resData");
                                        if (resData == null) break block24;
                                        string3 = resData.getString("rewardPoint");
                                        if (response == null) break block25;
                                        if (throwable == null) break block26;
                                        try {
                                            response.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                        break block25;
                                    }
                                    response.close();
                                }
                                return string3;
                            }
                            LOGGER.info("\u4e2d\u5b8f\u5b9a\u5236\u79ef\u5206\u67e5\u8be2\u63a5\u53e3\u7528\u6237\u4e0d\u5b58\u5728 openid={}", (Object)uid);
                            string2 = null;
                            if (response == null) break block27;
                            if (throwable == null) break block28;
                            try {
                                response.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            break block27;
                        }
                        response.close();
                    }
                    return string2;
                }
                LOGGER.info("\u4e2d\u5b8f\u5b9a\u5236\u79ef\u5206\u67e5\u8be2\u63a5\u53e3\u8c03\u7528\u5f02\u5e38 code={}, msg={}, requestSn={}", new Object[]{resCode, json.getString("resMsg"), requestSn});
                LOGGER.info(json.toString());
                string = null;
                if (response == null) break block29;
                if (throwable == null) break block30;
                try {
                    response.close();
                }
                catch (Throwable throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                break block29;
            }
            response.close();
        }
        return string;
        catch (Throwable throwable5) {
            try {
                try {
                    throwable = throwable5;
                    throw throwable5;
                }
                catch (Throwable throwable6) {
                    if (response != null) {
                        if (throwable != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                        } else {
                            response.close();
                        }
                    }
                    throw throwable6;
                }
            }
            catch (Exception e) {
                try {
                    LOGGER.info("\u4e2d\u5b8f\u5b9a\u5236\u79ef\u5206\u67e5\u8be2\u63a5\u53e3\u8c03\u7528\u5f02\u5e38 uid={}, requestSn={}", new Object[]{uid, requestSn, e});
                    return null;
                }
                catch (Exception ex) {
                    LOGGER.info("\u4e2d\u5b8f\u5b9a\u5236\u79ef\u5206\u67e5\u8be2\u63a5\u53e3\u8c03\u7528\u5f02\u5e38 uid={} requestSn={}", new Object[]{uid, requestSn, ex});
                    return null;
                }
            }
        }
    }

    private ZHCreditsLogDO createAndGetRequestSn(String credits, String orderNum, Long appId, LogTypeEnum type, Long cid, String uid, String lastRequestSn, String remarks) throws BizException {
        ZHCreditsLogDO log;
        switch (type) {
            case SUB_CREDITS: {
                log = new ZHCreditsLogDO();
                String requestSn = this.zhCreditsLogDAO.generateNewRequestSn(this.config.getPartnerCode());
                log.setRequestSn(requestSn);
                log.setAppId(appId);
                log.setCredits(Long.valueOf(credits));
                log.setLogType(type.getType());
                log.setLogStatus(LogStatusEnum.CREATED.getCode());
                log.setOrderNum(orderNum);
                log.setCid(cid);
                log.setUid(uid);
                log.setRemarks(remarks);
                this.zhCreditsLogDAO.insert(log);
                break;
            }
            case ADD_CREDITS: {
                log = this.zhCreditsLogDAO.findByOrderNumAndLogType(orderNum, LogTypeEnum.ADD_CREDITS);
                if (log != null) break;
                log = new ZHCreditsLogDO();
                String requestSn = this.zhCreditsLogDAO.generateNewRequestSn(this.config.getPartnerCode());
                log.setRequestSn(requestSn);
                log.setAppId(appId);
                log.setCredits(Long.valueOf(credits));
                log.setLogType(type.getType());
                log.setLogStatus(LogStatusEnum.CREATED.getCode());
                log.setOrderNum(orderNum);
                log.setCid(cid);
                log.setUid(uid);
                log.setRemarks(remarks);
                this.zhCreditsLogDAO.insert(log);
                break;
            }
            case ROLL_BACK_CREDITS: {
                log = new ZHCreditsLogDO();
                String requestSn = this.zhCreditsLogDAO.generateNewRequestSn(this.config.getPartnerCode());
                log.setRequestSn(requestSn);
                log.setAppId(appId);
                log.setCredits(Long.valueOf(credits));
                log.setLogType(type.getType());
                log.setLogStatus(LogStatusEnum.CREATED.getCode());
                log.setOrderNum(orderNum);
                log.setLastRequestSn(lastRequestSn);
                log.setCid(cid);
                log.setUid(uid);
                log.setRemarks(remarks);
                this.zhCreditsLogDAO.insert(log);
                break;
            }
            default: {
                throw new BizException("\u4e2d\u5b8f\u6263\u79ef\u5206\u6d41\u7a0b\u4e2d\u65ad");
            }
        }
        return log;
    }
}

