/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.virtual;

import cn.com.duiba.biz.credits.CainiaoApi;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.domain.TopSecretDO;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.CaiNiaoTool;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AliTripApi {
    private static final Logger logger = LoggerFactory.getLogger(CainiaoApi.class);
    private static final ImmutableSet<Long> ALITRIP_APP_IDS = ImmutableSet.of((Object)43739L, (Object)43740L);
    private static final ImmutableMap<String, String> PARAM_FEILD_MAP = new ImmutableMap.Builder().put((Object)"appKey", (Object)"duiba_app_key").put((Object)"orderNum", (Object)"order_num").put((Object)"developBizId", (Object)"develop_biz_id").build();
    private static final ImmutableMap<String, String> RESULT_FEILD_MAP = new ImmutableMap.Builder().put((Object)"supplier_biz_id", (Object)"supplierBizId").put((Object)"error_message", (Object)"errorMessage").build();
    public static final String ALITRIP_VIRTUAL_AWARD_METHOD = "alitrip.wireless.duiba.award";
    public static final String ALITRIP_VIRTUAL_AWARD_REQUEST = "alitrip_virtual_award_request";
    public static final String ALITRIP_VIRTUAL_AWARD_RESPONSE = "alitrip_wireless_duiba_award_response";
    @Autowired
    private AppDAO appDAO;

    private TopSecretDO getTopSecretDO(String appId) {
        String appKey = "24327934";
        String secret = "c290043acee4a46c99c47c6382b99f2c";
        if (Objects.equals("43739", appId)) {
            appKey = "1024327934";
            secret = "sandboxacee4a46c99c47c6382b99f2c";
        }
        TopSecretDO topSecretDO = new TopSecretDO();
        topSecretDO.setAppKey(appKey);
        topSecretDO.setAppSecret(secret);
        return topSecretDO;
    }

    public static boolean isAliTrip(Long appId) {
        return ALITRIP_APP_IDS.contains((Object)appId);
    }

    public SupplierRequest getVirtualRequest(SupplierRequest request) {
        String url = request.getHttpUrl();
        String host = url.substring(0, url.indexOf(63));
        String urlParams = url.substring(url.indexOf(63) + 1, url.length());
        Map<String, String> requestMap = AssembleTool.getUrlParams(urlParams);
        TopSecretDO topSecretDO = this.getTopSecretDO(request.getAppId());
        topSecretDO.setAddPrefix(true);
        if (MapUtils.isEmpty(requestMap)) {
            throw new IllegalStateException("alitrip api params is empty!");
        }
        requestMap.remove("sign");
        requestMap.put("duiba_appSecret", this.appDAO.getAppSecret(this.appDAO.getAppByCache(Long.valueOf(request.getAppId()))));
        Map<String, String> authParams = CaiNiaoTool.buildParamMap(requestMap, ALITRIP_VIRTUAL_AWARD_METHOD, ALITRIP_VIRTUAL_AWARD_REQUEST, PARAM_FEILD_MAP, topSecretDO);
        request.setHttpUrl(host);
        request.setAuthParams(authParams);
        return request;
    }

    public String parseVirtualResponse(String body) {
        JSONObject jsonObject;
        try {
            if (StringUtils.isBlank((String)body)) {
                return body;
            }
            jsonObject = JSONObject.parseObject((String)body);
        }
        catch (Exception e) {
            logger.error("JSON.parseObject:", (Throwable)e);
            return body;
        }
        JSONObject duibaRspJsonWrap = jsonObject.getJSONObject(ALITRIP_VIRTUAL_AWARD_RESPONSE);
        if (duibaRspJsonWrap == null) {
            return body;
        }
        return JSONObject.toJSONString((Object)duibaRspJsonWrap);
    }

    public String getVirtualRespone(String body) {
        String result = this.parseVirtualResponse(body);
        if (StringUtils.isNotBlank((String)result)) {
            for (Map.Entry entry : RESULT_FEILD_MAP.entrySet()) {
                result = result.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
            }
        }
        return result;
    }
}

