/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.dao;

import cn.com.duiba.constant.DatabaseSchema;
import cn.com.duiba.wolf.spring.datasource.AutoRoutingDataSource;
import java.util.List;
import javax.sql.DataSource;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.datasource.DelegatingDataSource;

public abstract class BaseDAO {
    @Autowired
    @Qualifier(value="sqlSessionTemplate")
    protected SqlSessionTemplate sqlSession;
    @Autowired
    @Qualifier(value="consumerCrecordSqlSessionTemplate")
    protected SqlSessionTemplate consumerCrecordSqlSession;
    @Autowired
    @Qualifier(value="developerAppSqlSessionTemplate")
    protected SqlSessionTemplate developerAppSqlSession;
    @Autowired
    @Qualifier(value="customSqlSessionTemplate")
    protected SqlSessionTemplate customSqlSession;

    protected SqlSessionTemplate getSqlSession() {
        return this.sqlSession;
    }

    private SqlSessionTemplate getSqlSessionTemplate(boolean isForceUseMasterDataSource) {
        DatabaseSchema databaseSchema = this.chooseSchema();
        if (databaseSchema == null) {
            throw new NullPointerException("please set databaseSchema in class:" + this.getClass().getName());
        }
        SqlSessionTemplate sqlSessionTemplate = null;
        switch (databaseSchema) {
            case CREDITS: {
                sqlSessionTemplate = this.sqlSession;
                break;
            }
            case CONSUMER_CRECORD: {
                sqlSessionTemplate = this.consumerCrecordSqlSession;
                break;
            }
            case DEVELOPER_APP: {
                sqlSessionTemplate = this.developerAppSqlSession;
                break;
            }
            case DUIBA_CUSTOM: {
                sqlSessionTemplate = this.customSqlSession;
                break;
            }
            default: {
                throw new NullPointerException("\u5f53\u4f60\u770b\u5230\u8fd9\u4e2a\u62a5\u9519\u7684\u65f6\u5019,\u4f60\u80af\u5b9a\u6ca1\u6709\u914d\u7f6e\u8fd4\u56de\u6070\u5f53\u7684sqlSessionTemplate,\u9ebb\u70e6\u5c48\u8eab\u8fdb\u6765\u914d\u7f6e\u4e00\u4e0b\u5427");
            }
        }
        DataSource ds = sqlSessionTemplate.getSqlSessionFactory().getConfiguration().getEnvironment().getDataSource();
        if (ds instanceof DelegatingDataSource) {
            ds = ((DelegatingDataSource)ds).getTargetDataSource();
        }
        if (ds instanceof AutoRoutingDataSource) {
            AutoRoutingDataSource autoRoutingDataSource = (AutoRoutingDataSource)ds;
            autoRoutingDataSource.determineCurrentLookupKeyByItSelf(isForceUseMasterDataSource);
        }
        return sqlSessionTemplate;
    }

    public int insert(String statement) {
        return this.getSqlSessionTemplate(true).insert(this.getStamentNameSpace(statement));
    }

    public int update(String statement) {
        return this.getSqlSessionTemplate(true).update(this.getStamentNameSpace(statement));
    }

    public <T> T selectOne(String statement, Object parameter) {
        return (T)this.getSqlSessionTemplate(false).selectOne(this.getStamentNameSpace(statement), parameter);
    }

    public int insert(String statement, Object parameter) {
        return this.getSqlSessionTemplate(true).insert(this.getStamentNameSpace(statement), parameter);
    }

    public int update(String statement, Object parameter) {
        return this.getSqlSessionTemplate(true).update(this.getStamentNameSpace(statement), parameter);
    }

    public <E> List<E> selectList(String statement, Object parameter) {
        return this.getSqlSessionTemplate(false).selectList(this.getStamentNameSpace(statement), parameter);
    }

    protected String getStamentNameSpace(String method) {
        return this.getClass().getName() + "." + method;
    }

    protected abstract DatabaseSchema chooseSchema();
}

