/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.dao.impl;

import cn.com.duiba.constant.DatabaseSchema;
import cn.com.duiba.dao.AppNewExtraDao;
import cn.com.duiba.dao.BaseDAO;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class AppNewExtraDaoImpl
extends BaseDAO
implements AppNewExtraDao {
    public static final String APPID = "appId";
    public static final String BD = "bd";
    public static final String DAILY_ACT_LOGIN_UV = "dailyActLoginUv";
    public static final String ONLINE_DATE = "onlineDate";
    public static final String FLOWRULE = "flowRule";
    public static final String COUPON_STOCK_WARN = "couponStockWarn";
    public static final String OBJECT_STOCK_WARN = "objectStockWarn";
    public static final String NOT_LOGIN_PLAY_GAME = "notLoginPlayGame";
    public static final String SEC_KILL_VALIDATION_KEY = "secKillValidation";
    public static final String EXCHANGE_VALIDATION_KEY = "exchangeValidation";
    public static final String CONSUME_VIRTUAL_CARD = "consumeVirtualCard";
    public static final String CONSUME_VIRTUAL_CARD_NOTIFY = "consumeVirtualCardNotify";
    public static final String DELIVER_OBJECT_ORDER_NOTIFY = "DeliverObjectOrderNotify";
    public static final String ACCESSACCOUNT = "accessAccount";
    private Cache<String, String> appCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();

    @Override
    public String findVirtualCardConsume(Long appId) {
        String val = (String)this.appCache.getIfPresent((Object)(appId + "_" + CONSUME_VIRTUAL_CARD));
        if (val == null && StringUtils.isNotBlank((String)(val = (String)this.getSqlSession().selectOne("findVirtualCardConsume", (Object)appId)))) {
            this.appCache.put((Object)(appId + "_" + CONSUME_VIRTUAL_CARD), (Object)val);
        }
        return val;
    }

    @Override
    public String findVirtualCardConsumeNotify(Long appId) {
        String val = (String)this.appCache.getIfPresent((Object)(appId + "_" + CONSUME_VIRTUAL_CARD_NOTIFY));
        if (val == null && StringUtils.isNotBlank((String)(val = (String)this.getSqlSession().selectOne("findVirtualCardConsumeNotify", (Object)appId)))) {
            this.appCache.put((Object)(appId + "_" + CONSUME_VIRTUAL_CARD_NOTIFY), (Object)val);
        }
        return val;
    }

    @Override
    public String findDeliverObjectOrderNotify(Long appId) {
        String val = (String)this.appCache.getIfPresent((Object)(appId + "_" + DELIVER_OBJECT_ORDER_NOTIFY));
        if (val == null && StringUtils.isNotBlank((String)(val = (String)this.getSqlSession().selectOne("findDeliverObjectOrderNotify", (Object)appId)))) {
            this.appCache.put((Object)(appId + "_" + DELIVER_OBJECT_ORDER_NOTIFY), (Object)val);
        }
        return val;
    }

    @Override
    public String findAccessAccountStatus(Long appId) {
        String val = (String)this.appCache.getIfPresent((Object)(appId + "_" + ACCESSACCOUNT));
        if (val == null && StringUtils.isNotBlank((String)(val = (String)this.getSqlSession().selectOne("findAccessAccountStatu", (Object)appId)))) {
            this.appCache.put((Object)(appId + "_" + ACCESSACCOUNT), (Object)val);
        }
        return val;
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS;
    }
}

