/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.reconciliation.impl;

import cn.com.duiba.dao.custom.ReconciliationRecordDao;
import cn.com.duiba.param.ReconciliationRecordParam;
import cn.com.duiba.service.reconciliation.ReconciliationRecordService;
import cn.com.duiba.thirdparty.dto.reconciliation.ReconciliationRecordDto;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReconciliationRecordServiceImpl
implements ReconciliationRecordService {
    private static final Logger logger = LoggerFactory.getLogger(ReconciliationRecordServiceImpl.class);
    @Autowired
    private ReconciliationRecordDao reconciliationRecordDao;

    @Override
    public ReconciliationRecordDto saveOrUpdate(ReconciliationRecordDto dto) {
        List<ReconciliationRecordDto> dtoList = this.reconciliationRecordDao.findByUidOrderNum(dto.getOrderNum(), dto.getAppId(), dto.getPartnerUserId(), dto.getLogType(), dto.getOptId(), dto.getOptType());
        if (CollectionUtils.isEmpty(dtoList)) {
            this.reconciliationRecordDao.insert(dto);
        } else {
            ReconciliationRecordDto reconciliationRecordDto = dtoList.get(0);
            dto.setId(reconciliationRecordDto.getId());
            this.reconciliationRecordDao.update(dto);
        }
        return dto;
    }

    @Override
    public Integer update(ReconciliationRecordDto dto) {
        List<ReconciliationRecordDto> dtoList = this.reconciliationRecordDao.findByUidOrderNum(dto.getOrderNum(), dto.getAppId(), dto.getPartnerUserId(), dto.getLogType(), dto.getOptId(), dto.getOptType());
        if (CollectionUtils.isEmpty(dtoList) || dtoList.size() > 1) {
            logger.warn("query record: {}", (Object)JSONObject.toJSONString(dtoList));
            return 0;
        }
        ReconciliationRecordDto updateDto = new ReconciliationRecordDto();
        updateDto.setId(dtoList.get(0).getId());
        updateDto.setResponseBody(dto.getResponseBody());
        updateDto.setResponseStatus(dto.getResponseStatus());
        return this.reconciliationRecordDao.update(updateDto);
    }

    @Override
    public List<ReconciliationRecordDto> findRecordBySendTime(ReconciliationRecordParam reconciliationRecordParam) {
        if (reconciliationRecordParam == null) {
            return Collections.emptyList();
        }
        return this.reconciliationRecordDao.findRecordBySendTime(reconciliationRecordParam);
    }

    @Override
    public int findRecordCountBySendTime(ReconciliationRecordParam reconciliationRecordParam) {
        if (reconciliationRecordParam == null) {
            return 0;
        }
        return this.reconciliationRecordDao.findRecordCountBySendTime(reconciliationRecordParam);
    }
}

