/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tool;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.constant.HaidilaoSdkConstant;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HaidilaoSignTool {
    private static final Charset CLOUDAPI_ENCODING = Charset.forName("UTF-8");
    private static final Logger logger = LoggerFactory.getLogger(HaidilaoSignTool.class);

    public static String sign(String method, String appSecret, Map<String, String> headerParams, String pathWithParams, Map<String, String> queryParams, Map<String, String> formParams) {
        try {
            Mac hmacSha256 = Mac.getInstance("HmacSHA256");
            byte[] keyBytes = appSecret.getBytes(HaidilaoSdkConstant.CLOUDAPI_ENCODING);
            hmacSha256.init(new SecretKeySpec(keyBytes, 0, keyBytes.length, "HmacSHA256"));
            String signString = HaidilaoSignTool.combineParamsTogether(method, headerParams, pathWithParams, queryParams, formParams);
            byte[] signResult = hmacSha256.doFinal(signString.getBytes(HaidilaoSdkConstant.CLOUDAPI_ENCODING));
            return Base64.encodeBase64String((byte[])signResult);
        }
        catch (Exception e) {
            logger.info("\u6d77\u5e95\u635e\u63a5\u53e3\u7b7e\u540d\u5931\u8d25\uff0c", (Throwable)e);
            throw new ThirdpatyException("\u6d77\u5e95\u635e\u63a5\u53e3\u7b7e\u540d\u5931\u8d25", e);
        }
    }

    private static String combineParamsTogether(String method, Map<String, String> headerParams, String pathWithParams, Map<String, String> queryParams, Map<String, String> formParams) {
        StringBuilder sb = new StringBuilder();
        sb.append(method).append("\n");
        if (headerParams.get("Accept") != null) {
            sb.append(headerParams.get("Accept"));
        }
        sb.append("\n");
        if (headerParams.get("Content-MD5") != null) {
            sb.append(headerParams.get("Content-MD5"));
        }
        sb.append("\n");
        if (headerParams.get("Content-Type") != null) {
            sb.append(headerParams.get("Content-Type"));
        }
        sb.append("\n");
        if (headerParams.get("Date") != null) {
            sb.append(headerParams.get("Date"));
        }
        sb.append("\n");
        sb.append(HaidilaoSignTool.buildHeaders(headerParams));
        sb.append("\n");
        sb.append(HaidilaoSignTool.buildResource(pathWithParams, queryParams, formParams));
        return sb.toString();
    }

    private static String buildResource(String pathWithParams, Map<String, String> queryParams, Map<String, String> formParams) {
        StringBuilder result = new StringBuilder();
        result.append(pathWithParams);
        TreeMap<String, String> parameter = new TreeMap<String, String>();
        if (MapUtils.isNotEmpty(queryParams)) {
            parameter.putAll(queryParams);
        }
        if (MapUtils.isNotEmpty(formParams)) {
            parameter.putAll(formParams);
        }
        if (parameter.size() > 0) {
            result.append("?");
            ArrayList<String> comboMap = new ArrayList<String>();
            for (Map.Entry entry : parameter.entrySet()) {
                String comboResult = (String)entry.getKey() + (StringUtils.isNotEmpty((CharSequence)((CharSequence)entry.getValue())) ? "=" + (String)entry.getValue() : "");
                comboMap.add(comboResult);
            }
            Joiner joiner = Joiner.on((String)"&");
            result.append(joiner.join(comboMap));
        }
        return result.toString();
    }

    private static String buildHeaders(Map<String, String> headers) {
        if (MapUtils.isNotEmpty(headers)) {
            Predicate<String> signFilter = new Predicate<String>(){

                public boolean apply(String input) {
                    return input.startsWith("X-Ca-");
                }
            };
            TreeMap headersToSign = new TreeMap(Maps.filterKeys(headers, (Predicate)signFilter));
            String signHeaders = Joiner.on((char)',').join(headersToSign.keySet());
            headers.put("X-Ca-Signature-Headers", signHeaders);
            Joiner.MapJoiner joiner = Joiner.on((String)"\n").withKeyValueSeparator(":");
            return joiner.join(headersToSign);
        }
        return "";
    }

    public static String getContentMd5(String bodyStream) {
        try {
            byte[] bytes = bodyStream.getBytes("UTF-8");
            if (bytes == null) {
                throw new IllegalArgumentException("bytes can not be null");
            }
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            md.update(bytes);
            byte[] md5Result = md.digest();
            String base64Result = Base64.encodeBase64String((byte[])md5Result);
            return base64Result.length() > 24 ? base64Result.substring(0, 23) : base64Result;
        }
        catch (Exception e) {
            logger.info("\u6d77\u5e95\u635e\u5b9a\u5236\u63a5\u53e3\u5904\u7406 Content-MD5 \u5f02\u5e38\uff0c-{}", (Throwable)e);
            throw new ThirdpatyException("\u6d77\u5e95\u635e\u5b9a\u5236\u63a5\u53e3\u5904\u7406 Content-MD5 \u5f02\u5e38", e);
        }
    }
}

