package cn.com.duiba.biz.credits;

import cn.com.duiba.api.bo.subcredits.SubCreditsMsgDto;
import cn.com.duiba.constant.JiuJiuYaConstants;
import cn.com.duiba.domain.RequestTypeEnum;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.net.URLDecoder;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;

/**
 * @Author: lufeng
 * @Description: 久久丫api接口 http://doc.bigaka.com/web/#/2?page_id=205
 * @Date: Created in 2019/7/31
 */
@Service
public class JJYApi {

    private static final Logger LOGGER = LoggerFactory.getLogger(JJYApi.class);

    @Autowired
    private JiuJiuYaConstants jiuJiuYaConstants;

    /**
     *  兑吧app在留夫鸭平台的appid
     */
    private static Map<String, String> codeAppIdMaps = new ImmutableMap.Builder<String, String>()
            .put("310117", "$1$UZlOGk6B$/2X97agCaZOkGzgqXF4.R1")
            .put("6543", "$1$oyfHoWps$3euCg.HlWrGHoqVKG/8050")
            .build();

    /**
     * 兑吧app在留夫鸭平台的secret
     */
    private static Map<String, String> codeSecrets = new ImmutableMap.Builder<String, String>()
            .put("310117", "$1$u5dzVzFY$BOi6AE87LPpXONj099JJ11")
            .put("6543", "$1$kYGw9ATM$EcLzJLvHPcuzmBfrz8KCI0")
            .build();

    /**
     * 久久丫appId集合
     */
    private static ImmutableSet<Long> jjyAppIds = ImmutableSet.of(64115L, 64116L,73131L);

    /**
     * 请求类型
     */
    private static final String POSTTYPE = "postType";
    /**
     * 请求类型方式--搜狐需要post以raw串的方式请求，因公用方法是kv，故该处加上raw标识，后续请求特殊处理
     */
    private static final String RAW = "raw";

    /**
     * 判断是否是久久丫的appId
     * @param appId
     * @return
     */
    public boolean isJJY(Long appId) {
        return null != appId && jiuJiuYaConstants.getDuibaAppIds().contains(appId);
    }

    private boolean isValid() {
        return System.currentTimeMillis() > jiuJiuYaConstants.getValidTime();
    }

    /**
     * 设置久久丫会员积分报文head
     * @param http
     */
    public void setJJYHttpHead(Map<String, String> authParams, HttpRequestBase http) {
        if (isValid()){
            setNewHeader(authParams, http);
            return;
        }
        String storeCode = authParams.get("storeCode");
        if (StringUtils.isBlank(storeCode) || !codeAppIdMaps.containsKey(storeCode)) {
            LOGGER.warn("传入的storeCode异常, storeCode={}", storeCode);
            return;
        }
        String appId = codeAppIdMaps.get(storeCode);
        String appSecret = codeSecrets.get(storeCode);
        http.setHeader("app_id", appId);
        http.setHeader("secret", appSecret);
        String ts = DateUtils.getMillisecond().substring(0,14);
        http.setHeader("ts", ts);
        http.setHeader("model", "customer");
        http.setHeader("store_code", storeCode);
        http.setHeader("method", "updatePoint");
        http.setHeader("Content-Type", "application/json");
        authParams.remove(POSTTYPE);
        authParams.remove("unicodeType");
        authParams.remove("storeCode");
        String msg = JsonTool.objectToJson(authParams);
        String origin = appId+appSecret+ts+msg;
        String sign = DigestUtils.md5Hex(origin).toLowerCase();
        http.setHeader("sign", sign);
    }

    private void setNewHeader(Map<String, String> authParams, HttpRequestBase http){
        String storeCode = authParams.get("store_code");
        authParams.remove(POSTTYPE);
        authParams.remove("unicodeType");
        authParams.remove("storeCode");
        TreeMap<String, String> params = new TreeMap<>(authParams);
        String appId = jiuJiuYaConstants.getJjyAppId();
        String appSecret = jiuJiuYaConstants.getJjySecret();
        params.put("store_code", storeCode);
        String msg = JSON.toJSONString(params);
        String ts = DateUtils.getMillisecond().substring(0, 14);
        String str = appId + appSecret + ts + msg;
        String sign = DigestUtils.md5Hex(str).toLowerCase();
        http.setHeader("app_id", appId);
        http.setHeader("ts", ts);
        http.setHeader("sign", sign);
        http.setHeader("model", "customer");
        http.setHeader("store_code", storeCode);
        http.setHeader("method", "updatePoint");
        http.setHeader("request-channel", "6866");
        http.setHeader("Content-Type", "application/json");
    }

    /**
     * 扣积分请求方式为POST请求
     * @param request
     * @return
     */
    public CreditsMessage getSubCreditsMessage(CreditsMessage request) {
        String url = request.getHttpUrl();
        //post请求,截取出url去除参数的部分,设置为请求url
        String host = url.substring(0, url.indexOf('?'));
        request.setHttpUrl(host);
        //将原get请求的参数转化成map
        String params = url.substring(url.indexOf('?') + 1, url.length());
        Map<String, String> crediMap = AssembleTool.getUrlParams(params);
        Map<String, String> jjyMap = transferToJJYMap(crediMap, RequestTypeEnum.SUB_CREDITS.getCode());
        //放入请求类型标识
        jjyMap.put(POSTTYPE,RAW);
        jjyMap.put("unicodeType", "UTF-8");
        //放入商店code
        if (isValid()) {
            jjyMap.put("store_code", crediMap.get("transfer"));
        } else {
            jjyMap.put("storeCode", crediMap.get("transfer"));
        }
        request.setAuthParams(jjyMap);
        request.setHttpType(CreditsMessage.HTTP_POST);
        return request;
    }

    /**
     * 构造久久丫扣积分请求.
     *
     * @param subCreditsMsgWrapper
     * @return
     */
    public SubCreditsMsgWrapper getSubCreditsMessage(SubCreditsMsgWrapper subCreditsMsgWrapper) {
        String url = subCreditsMsgWrapper.getHttpUrl();
        String host = url.substring(0, url.indexOf('?'));
        subCreditsMsgWrapper.setHttpUrl(host);
        String urlParams = url.substring(url.indexOf('?') + 1, url.length());
        // 将请求URL的参数转换为MAP
        Map<String, String> crediMap = AssembleTool.getUrlParams(urlParams);
        Map<String, String> jjyMap = transferToJJYMap(crediMap, RequestTypeEnum.SUB_CREDITS.getCode());
        //放入请求类型标识
        jjyMap.put(POSTTYPE,RAW);
        jjyMap.put("unicodeType", "UTF-8");
        //放入商店code
        if (isValid()) {
            jjyMap.put("store_code", crediMap.get("transfer"));
        } else {
            jjyMap.put("storeCode", crediMap.get("transfer"));
        }
        subCreditsMsgWrapper.getSubCreditsMsg().setAuthParams(jjyMap);
        subCreditsMsgWrapper.getSubCreditsMsg().setHttpType(SubCreditsMsgDto.HTTP_POST);
        return subCreditsMsgWrapper;
    }

    /**
     * 构造久久丫加积分请求
     * @param request
     * @return
     */
    public CreditsMessageDto getAddCreditsMessage(CreditsMessageDto request) {
        String url = request.getHttpUrl();
        //post请求,截取出url去除参数的部分,设置为请求url
        String host = url.substring(0, url.indexOf('?'));
        request.setHttpUrl(host);
        //将原get请求的参数转化成map
        String urlParams = url.substring(url.indexOf('?') + 1, url.length());
        Map<String, String> crediMap = AssembleTool.getUrlParams(urlParams);
        Map<String, String> jjyMap = transferToJJYMap(crediMap, RequestTypeEnum.ADD_CREDITS.getCode());
        //放入请求类型标识
        jjyMap.put(POSTTYPE,RAW);
        jjyMap.put("unicodeType", "UTF-8");
        //放入商店code
        jjyMap.put("transfer", crediMap.get("transfer"));
        if (isValid()) {
            jjyMap.put("store_code", crediMap.get("transfer"));
        }
        request.setAuthParams(jjyMap);
        request.setHttpType(CreditsMessage.HTTP_POST);
        return request;
    }

    private Map<String, String> transferToJJYMap(Map<String, String> map, int type) {
        Map<String, String> jjyMap = Maps.newHashMap();
        if (isValid()) {
            jjyMap.put("open_id", map.get("uid"));
            jjyMap.put("third_party_type", "1");

        } else {
            jjyMap.put("customer_id", map.get("uid"));
        }
        String point = map.get("credits");
        if (type == RequestTypeEnum.SUB_CREDITS.getCode()) {
            jjyMap.put("point", "-"+point);
            jjyMap.put("remark", "兑吧系统扣积分");
        } else if (type == RequestTypeEnum.ADD_CREDITS.getCode()){
            jjyMap.put("point", point);
            jjyMap.put("remark", "兑吧系统加积分");
        }
        jjyMap.put("serial_id", map.get("orderNum"));
        return jjyMap;
    }

    /**
     * 解析开发者返回数据
     * @param body
     * @return
     */
    public String parseCrditsRsp(String body){
        try{
            String bodyTemp = URLDecoder.decode(body,"utf-8");
            JSONObject jsonObject = JSONObject.parseObject(bodyTemp);
            Map<String, String> map = Maps.newHashMap();
            if ("1".equals(jsonObject.getString("code"))) {
                map.put("status", "ok");
                //对方没有返回业务订单号，但是我们系统又做了重复性校验，所以只能先放个时间戳进去
                map.put("bizId", String.valueOf(new Date().getTime()));
            } else {
                map.put("status", "no");
                map.put("errorMessage", jsonObject.getString("message"));
            }
            return JsonTool.objectToJson(map);
        }catch (Exception e){
            LOGGER.info("JJY parseCrditsRsp error,boby is {}",body,e);
            return body;
        }
    }



    class MsgInfo {
        //会员id
        private String customer_id;
        //需要变更的会员积分数值。负数为减，正数为加
        private String point;
        //积分累计或减少的备注说明
        private String remark;
        //积分流水号,可为空，不为空时保证唯一
        private String serial_id;

        public String getCustomer_id() {
            return customer_id;
        }

        public void setCustomer_id(String customer_id) {
            this.customer_id = customer_id;
        }

        public String getPoint() {
            return point;
        }

        public void setPoint(String point) {
            this.point = point;
        }

        public String getRemark() {
            return remark;
        }

        public void setRemark(String remark) {
            this.remark = remark;
        }

        public String getSerial_id() {
            return serial_id;
        }

        public void setSerial_id(String serial_id) {
            this.serial_id = serial_id;
        }
    }
}
