package cn.com.duiba.biz.credits;

import cn.com.duiba.api.bo.subcredits.SubCreditsMsgDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.constant.MiaojieConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.HttpRequestLog;
import cn.com.duiba.tool.JsonTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by sunyan on 2020/1/9.
 */
@Service
public class MiaojieApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(MiaojieApi.class);

    @Autowired
    private MiaojieConfig miaojieConfig;
    @Resource(name = "httpClient")
    private CloseableHttpClient httpClient;

    /**
     * 判断当前app是否是妙洁的app
     * @param appId
     * @return
     */
    public boolean isMiaojieApp(Long appId) {
        return miaojieConfig.getAppIds().contains(appId);
    }



    /**
     * 组装扣积分对象  remote形式发起的扣积分请求
     * @param request
     * @return
     */
    public CreditsMessage getSubCreditsMessage(CreditsMessage request) throws BizException {
        String timestamp = String.valueOf(System.currentTimeMillis());
        String sign = createSign(timestamp);
        String urlCredits = getSignUrl(miaojieConfig.getCreditsUrl(),timestamp, sign);
        request.setHttpUrl(urlCredits);
        Map<String, String> originAuthParams = request.getAuthParams();
        String orderNum = originAuthParams.get("orderNum");
        String credits = originAuthParams.get("credits");
        String transfer = originAuthParams.get("transfer");
        String[] transfers = transfer.split("#");
        if(transfers.length!=2){
            LOGGER.error("MiaojieApi call getSubCreditsMessage transfers error , CreditsMessage = {},transfers={}",
                    JSONObject.toJSONString(request), transfers);
            throw new BizException("妙洁扣积分流程中断");
        }
        String openIdStr = transfers[0];
        String openId = openIdStr.substring(openIdStr.indexOf("openId=")+7);
        String mobileStr = transfers[1];
        String mobile = mobileStr.substring(mobileStr.indexOf("mobile=")+7);
        String content;
        String type = originAuthParams.get("type");
        if(StringUtils.equals("hdtool",type)){
            content = "兑吧参与活动扣减";
        }else if(StringUtils.equals("game",type)){
            content = "兑吧参与游戏扣减";
        }else if(StringUtils.equals("alipay",type)||
                StringUtils.equals("qb",type)||
                StringUtils.equals("coupon",type)||
                StringUtils.equals("object",type)||
                StringUtils.equals("phonebill",type)||
                StringUtils.equals("phoneflow",type)||
                StringUtils.equals("virtual",type)){
            content = "兑吧线上消费扣减";
        }else{
            content = "兑吧扣减";
        }
        Map<String, String> authParams = Maps.newHashMap();
        authParams.put("type", "1");
        authParams.put("mobile", mobile);
        authParams.put("pointInt", credits);
        authParams.put("recordId", orderNum);
        authParams.put("openId", openId);
        authParams.put("content", content);
        authParams.put("postType","raw");
        authParams.put("unicodeType","UTF-8");
        request.setAuthParams(authParams);
        request.setHttpType(CreditsMessage.HTTP_POST);
        return request;
    }


    /**
     * 组装扣积分对象  mq形式发起的扣积分请求
     * @param subCreditsMsgWrapper
     * @return
     */
    public SubCreditsMsgWrapper getSubCreditsMessage(SubCreditsMsgWrapper subCreditsMsgWrapper) throws BizException {
        String timestamp = String.valueOf(System.currentTimeMillis());
        String sign = createSign(timestamp);
        String urlCredits = getSignUrl(miaojieConfig.getCreditsUrl(),timestamp, sign);
        subCreditsMsgWrapper.setHttpUrl(urlCredits);
        SubCreditsMsgDto msg = subCreditsMsgWrapper.getSubCreditsMsg();
        Map<String, String> originAuthParams = msg.getAuthParams();
        String orderNum = originAuthParams.get("orderNum");
        String credits = originAuthParams.get("credits");
        String transfer = originAuthParams.get("transfer");
        String[] transfers = transfer.split("#");
        if(transfers.length!=2){
            LOGGER.error("MiaojieApi call getSubCreditsMessage transfers error , subCreditsMsgWrapper = {},transfers={}",
                    JSONObject.toJSONString(subCreditsMsgWrapper), transfers);
            throw new BizException("妙洁扣积分流程中断");
        }
        String openIdStr = transfers[0];
        String openId = openIdStr.substring(openIdStr.indexOf("openId=")+7);
        String mobileStr = transfers[1];
        String mobile = mobileStr.substring(mobileStr.indexOf("mobile=")+7);
        String content;
        String type = originAuthParams.get("type");
        if(StringUtils.equals("hdtool",type)){
            content = "兑吧参与活动扣减";
        }else if(StringUtils.equals("game",type)){
            content = "兑吧参与游戏扣减";
        }else if(StringUtils.equals("alipay",type)||
                StringUtils.equals("qb",type)||
                StringUtils.equals("coupon",type)||
                StringUtils.equals("object",type)||
                StringUtils.equals("phonebill",type)||
                StringUtils.equals("phoneflow",type)||
                StringUtils.equals("virtual",type)){
            content = "兑吧线上消费扣减";
        }else{
            content = "兑吧扣减";
        }
        Map<String, String> authParams = Maps.newHashMap();
        authParams.put("type", "1");
        authParams.put("mobile", mobile);
        authParams.put("pointInt", credits);
        authParams.put("recordId", orderNum);
        authParams.put("openId", openId);
        authParams.put("content", content);
        authParams.put("postType","raw");
        authParams.put("unicodeType","UTF-8");
        msg.setAuthParams(authParams);
        msg.setHttpType(SubCreditsMsgDto.HTTP_POST);
        return subCreditsMsgWrapper;
    }


    /**
     * 组装加积分对象 正常加积分
     * @param request
     * @return
     */
    public CreditsMessageDto getAddCreditsMessage(CreditsMessageDto request) throws BizException {
        String timestamp = String.valueOf(System.currentTimeMillis());
        String sign = createSign(timestamp);
        //组装基础积分url
        String urlCredits = getSignUrl(miaojieConfig.getCreditsUrl(),timestamp, sign);
        request.setHttpUrl(urlCredits);
        Map<String, String> originAuthParams = request.getAuthParams();
        String orderNum = originAuthParams.get("orderNum");
        String credits = originAuthParams.get("credits");
        String transfer = originAuthParams.get("transfer");
        String[] transfers = transfer.split("#");
        if(transfers.length!=2){
            LOGGER.error("MiaojieApi call getAddCreditsMessage transfers error , request = {},transfers={}",
                    JSONObject.toJSONString(request), transfers);
            throw new BizException("妙洁加积分流程中断");
        }
        String openIdStr = transfers[0];
        String openId = openIdStr.substring(openIdStr.indexOf("openId=")+7);
        String mobileStr = transfers[1];
        String mobile = mobileStr.substring(mobileStr.indexOf("mobile=")+7);
        String content;
        String type = originAuthParams.get("type");
        if(StringUtils.equals("hdtool",type)){
            content = "兑吧参与活动赠送";
        }else if(StringUtils.equals("game",type)){
            content = "兑吧参与游戏赠送";
        }else if(StringUtils.equals("sign",type)){
            content = "兑吧签到赠送";
        }else{
            content = "兑吧赠送";
        }
        String failType = originAuthParams.get("failType");
        if(failType!=null){
            if(StringUtils.equals("1",failType)){
                content = "兑吧订单失败返还积分";
            }else if (StringUtils.equals("2",failType)){
                content = "兑吧订单取消返还积分";
            }
        }
        Map<String, String> authParams = Maps.newHashMap();
        authParams.put("type", "2");
        authParams.put("mobile", mobile);
        authParams.put("pointInt", credits);
        authParams.put("recordId", orderNum);
        authParams.put("openId", openId);
        authParams.put("content", content);
        authParams.put("postType","raw");
        authParams.put("unicodeType","UTF-8");
        request.setAuthParams(authParams);
        request.setHttpType(CreditsMessage.HTTP_POST);
        return request;
    }

    /**
     * 转义扣积分响应数据
     *
     * @param body
     * @return
     */
    public String getMiaojieResponseCredis(String body,Map<String, String> authParams) {
        JSONObject jsonBody;
        try {
            jsonBody = JSON.parseObject(body);
        } catch (Exception e) {
            LOGGER.error("JSON.parseObject:body={},error={}",body, e.getMessage());
            return body;
        }
        JSONObject json = JsonTool.getAllJson(jsonBody);
        Map<String, String> duibaDoc = new HashMap<>();
        String code = json.getString("code");
        String pointCode = json.getString("point_code");
        if ("SUCCESS".equals(code)&&"SUC".equals(pointCode)) {
            duibaDoc.put("status", "ok");
        } else {
            duibaDoc.put("status", "fail");
        }
        duibaDoc.put("errorMessage", json.getString("message"));
        duibaDoc.put("bizId", authParams.get("recordId")+"_miaojie");
        //获取用户积分
        String timestamp = String.valueOf(System.currentTimeMillis());
        String sign = createSign(timestamp);
        String urlGrade = getSignUrl(miaojieConfig.getGradeUrl(),timestamp, sign);
        JSONObject params = new JSONObject();
        params.put("openId",authParams.get("openId"));
        params.put("mobile",authParams.get("mobile"));
        String credits = getCredits(urlGrade,params);
        duibaDoc.put("credits", credits);
        return JsonTool.objectToJson(duibaDoc);
    }


    private String getCredits(String urlGrade,JSONObject params){
        String credits = null;
        try {
            HttpPost post = new HttpPost(urlGrade);
            StringEntity entity = new StringEntity(params.toJSONString());
            entity.setContentEncoding("utf-8");
            entity.setContentType("application/json");
            post.setEntity(entity);
            try (CloseableHttpResponse response = httpClient.execute(post)) {
                String result = EntityUtils.toString(response.getEntity());
                JSONObject jsonret = JSONObject.parseObject(result);
                String code = jsonret.getString("code");
                if(StringUtils.equals("SUCCESS",code)){
                    String jsondata = jsonret.getString("jsondata");
                    JSONObject jsondataJ = JSONObject.parseObject(jsondata);
                    if(jsondataJ!=null){
                        credits = jsondataJ.getString("point");
                    }
                }
            } catch (Exception e) {
                LOGGER.info("妙洁定制积分查询接口调用异常 params={},error={}", params.toJSONString(), e.getMessage());
            }
            return credits;
        } catch (Exception e) {
            LOGGER.info("妙洁定制积分查询接口调用异常 params={},error={}", params.toJSONString(), e.getMessage());
            return null;
        }
    }



    private String getSignUrl(String url,String timestamp, String sign) {
        return url+"?appkey="+miaojieConfig.getAppkey()+"&timestamp="+timestamp+"&sign="+sign;
    }

    /**
     * 生成签名算法
     * @param timestamp 当前时间的时间戳（毫秒）
     * @return 加密签名
     */
    private String createSign(String timestamp){
        String str = timestamp + "&" + miaojieConfig.getAppsecret() ;
        String urlEncode = null;
        try {
            urlEncode = java.net.URLEncoder.encode(str.toLowerCase(),"utf-8").toLowerCase();
        } catch (UnsupportedEncodingException e) {
            LOGGER.error("encode error={}",e.getMessage());
        }
        String strMd5 = org.apache.commons.codec.digest.DigestUtils.md5Hex(urlEncode);
        return strMd5.toLowerCase();
    }

    /**
     * 结果通知
     * @param record 通知记录
     * @return 通知请求
     */
    public HttpRequestBase getMiaojieRequestNotify(NotifyQueueDO record) throws BizException {
        //妙洁活动通知是同步主订单，扣积分通知不走
        if(StringUtils.isBlank(record.getError4developer())){
            return new HttpPost("http://test.lianwangshenqi.com");
        }

        String transfer = record.getTransfer();
        String timestamp = String.valueOf(System.currentTimeMillis());
        String sign = createSign(timestamp);
        String urlNotify = getSignUrl(miaojieConfig.getNotifyUrl(),timestamp, sign);
        String[] transfers = transfer.split("#");
        if(transfers.length!=2){
            LOGGER.error("MiaojieApi call getMiaojieRequestNotify transfers error , NotifyQueueDO = {},transfers={}",
                    JSONObject.toJSONString(record), transfers);
            throw new BizException("妙洁加积分流程中断");
        }
        String mobileStr = transfers[1];
        String mobile = mobileStr.substring(mobileStr.indexOf("mobile=")+7);
        JSONObject param = JSONObject.parseObject(record.getError4developer());
        param.put("mobile",mobile);
        HttpRequestLog.logUrl("[action notify request][bizId " + record.getDuibaOrderNum() + "] [param " + JSONObject.toJSONString(param) + "]");
        HttpPost request = new HttpPost(urlNotify);
        request.setHeader("Content-Type", "application/json");
        request.setEntity(new StringEntity(param.toJSONString(), Charset.forName("utf-8")));
        return request;
    }

    /**
     * 获取通知响应
     *
     * @param body
     * @return
     */
    public String getMiaojieResponseNotify(String body) {
        JSONObject jsonBody;
        try {
            jsonBody = JSON.parseObject(body);
        } catch (Exception e) {
            LOGGER.error("JSON.parseObject:", e);
            return body;
        }
        JSONObject json = JsonTool.getAllJson(jsonBody);
        String code = json.getString("code");
        String orderPutCode = json.getString("orderPut_code");
        if ("SUCCESS".equals(code)&&"SUC".equals(orderPutCode)) {
            return "ok";
        }
        return body;
    }

}
