package cn.com.duiba.biz.credits.impl;

import cn.com.duiba.api.bo.subcredits.SubCreditsMsgDto;
import cn.com.duiba.biz.credits.EzrApiService;
import cn.com.duiba.constant.EzrConstant;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.wolf.utils.SecurityUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * @author zyj
 * @date 2018/12/12
 */
@Service
public class EzrApiServiceImpl implements EzrApiService{

    @Autowired
    private EzrConstant ezrConstant;

    @Autowired
    private AppDAO appDAO;

    private static Logger log = LoggerFactory.getLogger(EzrApiServiceImpl.class);


    @Override
    public Boolean isEzr(Long appId) {
        return ezrConstant.getAppIds().contains(appId);
    }

    @Override
    public SubCreditsMsgWrapper getRequestCredits(SubCreditsMsgWrapper subCreditsMsgWrapper) {

        //原生请求参数
        Map<String, String> params = subCreditsMsgWrapper.getSubCreditsMsg().getAuthParams();

        //封装后的请求参数
        Map<String, String> authParams = basicCredits(false, params);

        subCreditsMsgWrapper.getSubCreditsMsg().setAuthParams(authParams);
        subCreditsMsgWrapper.getSubCreditsMsg().setHttpType(SubCreditsMsgDto.HTTP_POST);

        String url = subCreditsMsgWrapper.getHttpUrl();
        String host = url.indexOf('?') == -1 ? url : url.substring(0, url.indexOf('?'));
        subCreditsMsgWrapper.setHttpUrl(host);
        return subCreditsMsgWrapper;
    }

    @Override
    public CreditsMessageDto getAddCreditsMessage(CreditsMessageDto request) {
        //原生请求参数
        Map<String, String> params = request.getAuthParams();

        //封装后的请求参数
        Map<String, String> authParams = basicCredits(true, params);

        request.setAuthParams(authParams);
        request.setHttpType(CreditsMessageDto.HTTP_POST);

        String url = request.getHttpUrl();
        String host = url.indexOf('?') == -1 ? url : url.substring(0, url.indexOf('?'));
        request.setHttpUrl(host);
        return request;
    }

    @Override
    public HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record, AppDO app) {
        Map<String, String> authParams = new HashMap<>();
        authParams.put("success", String.valueOf(record.getResult()));
        authParams.put("apk", app.getAppKey());
        authParams.put("appSecret", appDAO.getAppSecret(app));
        authParams.put("orderNum", record.getDuibaOrderNum());
        authParams.put("bizId", record.getDeveloperBizId());
        authParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        authParams.put("uid", record.getPartnerUserId());
        String sign = SignTool.sign(authParams);
        //生成签名之后移除appSecret
        authParams.remove("appSecret");
        authParams.put("sign",sign);
        return new HttpGet(AssembleTool.assembleUrl(notifyUrl, authParams));
    }

    @Override
    public String parseCreditsRsp(String body) {
        JSONObject jsonBody;
        try {
            jsonBody = JSON.parseObject(body);
        } catch (Exception e) {
            log.info("JSON.parseObject:", e);
            return body;
        }
        JSONObject json = JsonTool.getAllJson(jsonBody);
        Map<String, String> duibaDoc = new HashMap<>();
        duibaDoc.put("errorMessage", json.getString("Msg"));
        duibaDoc.put("status", "true".equals(json.getString("Status")) ?  "ok" : "fail" );
        duibaDoc.put("bizId", json.getString("TransId"));
        duibaDoc.put("credits", json.getString("Bonus"));
        return JsonTool.objectToJson(duibaDoc);
    }

    /**
     * 设置加积分或者减积分的参数
     * @param addOrSub True表示加积分,False表示减积分
     * @param params 从请求取出的验证参数
     * @return
     */
    private Map<String, String> basicCredits(Boolean addOrSub,Map<String, String> params){
        //需要传递的POST请求对象
        Map<String,String> authParams = new LinkedHashMap<>();
        //真正的业务参数
        JSONObject jsonObject = new JSONObject();
        String orderNum = params.get("orderNum");
        //A表示加积分,B表示减积分
        jsonObject.put("TradeNo",addOrSub ? "A" + orderNum : "B" + orderNum);
        jsonObject.put("Code",params.get("uid"));
        jsonObject.put("ShopCode",ezrConstant.getXtepShopCode());
        String description = params.get("description");
        jsonObject.put("TransBonus",addOrSub ? params.get("credits") : "-" + params.get("credits"));
        //因为此处Remark参数不能为空,为防止异常情况给个默认值 "积分变动"
        jsonObject.put("Remark",StringUtils.isBlank(description) ? "积分变动" : description);
        //当前时间戳
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String timestamp = simpleDateFormat.format(new Date());
        authParams.put("AppId", ezrConstant.getXtepAppId());
        authParams.put("Timestamp",timestamp);
        authParams.put("Token", ezrConstant.getXtepToken());
        String signStr = AssembleTool.paramSplic(authParams);
        //加密
        String sign = SecurityUtils.encode2StringBySHA(signStr).toUpperCase();
        //拼接请求参数
        //sign生成完毕移除Token
        authParams.remove("Token");
        authParams.put("Sign",sign);
        authParams.put("Args",jsonObject.toString());
        authParams.put("AppSystem",ezrConstant.getXtepAppSystem());
        return authParams;
    }
}
