package cn.com.duiba.constant;

import com.google.common.base.Splitter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @Description: 屈臣氏-定制虚拟商品接口参数配置
 * @Author: fxr
 * @Date: 2019/1/3
 */
@Component
@RefreshScope
public class WatsonsConfig {

    /**
     * 屈臣氏在兑吧的appId
     */
    @Value("${watsons.watsonsAppId}")
    private String watsonsAppId;

    /**
     * 兑吧标识（请求屈臣氏时，标识兑吧身份）
     */
    @Value("${watsons.duibaIdentifier}")
    private String duibaIdentifier;

    @Value("${watsons.certiId}")
    private String certiId;

    @Value("${watsons.token}")
    private String token;

    @Value("${watsons.mallCode}")
    private String mallCode;

    private Set<Long> watsonsAppIdSet;


    @Value("${watsons.duibaIdentifier1}")
    private String duibaIdentifier1;

    @Value("${watsons.certiId1}")
    private String certiId1;

    @Value("${watsons.token1}")
    private String token1;


    public String getDuibaIdentifier() {
        return duibaIdentifier;
    }

    public String getWatsonsAppId() {
        return watsonsAppId;
    }

    public String getCertiId() {
        return certiId;
    }

    public String getToken() {
        return token;
    }

    public String getMallCode() {
        return mallCode;
    }

    public String getDuibaIdentifier1() {
        return duibaIdentifier1;
    }

    public String getCertiId1() {
        return certiId1;
    }

    public String getToken1() {
        return token1;
    }

    public Set<Long> getWatsonsAppIdSet() {
        if(StringUtils.isBlank(watsonsAppId)){
            return Collections.emptySet();
        }
        if(CollectionUtils.isNotEmpty(watsonsAppIdSet)){
            return watsonsAppIdSet;
        }
        watsonsAppIdSet = Splitter.on(",").omitEmptyStrings().splitToList(watsonsAppId).stream()
                .map(s -> Long.parseLong(s)).collect(Collectors.toSet());
        return watsonsAppIdSet;
    }
}
