package cn.com.duiba.dto;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import org.apache.commons.lang3.RandomStringUtils;
import org.joda.time.DateTime;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by fangdong on 2019/07/22
 */
@JacksonXmlRootElement(localName = "Head")
public class WjrcbRequestMessageHead implements Serializable {
    private static final long serialVersionUID = -8495012620948256084L;

    @JacksonXmlProperty(localName = "_TransactionId")
    private String transactionId;

    @JacksonXmlProperty(localName = "_TransDate")
    private String transDate;

    @JacksonXmlProperty(localName = "_TransTime")
    private String transTime;

    @JacksonXmlProperty(localName = "_IdType")
    private String idType;

    @JacksonXmlProperty(localName = "_IdNo")
    private String idNo;

    @JacksonXmlProperty(localName = "_MChannelId")
    private String channelId;

    @JacksonXmlProperty(localName = "_TransJnlNo")
    private String transJnlNo;

    public WjrcbRequestMessageHead() {
        // Constructor
    }

    public WjrcbRequestMessageHead(Date now) {
        DateTime dt = new DateTime(now);
        this.transDate = dt.toString("yyyy-MM-dd");
        this.transTime = dt.toString("HH:mm:ss");
        this.channelId = "DBStore";
        this.transJnlNo = System.currentTimeMillis() + RandomStringUtils.randomNumeric(4);
    }

    public String getTransJnlNo() {
        return transJnlNo;
    }

    public void setTransJnlNo(String transJnlNo) {
        this.transJnlNo = transJnlNo;
    }

    public String getTransactionId() {
        return transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public String getTransDate() {
        return transDate;
    }

    public void setTransDate(String transDate) {
        this.transDate = transDate;
    }

    public String getTransTime() {
        return transTime;
    }

    public void setTransTime(String transTime) {
        this.transTime = transTime;
    }

    public String getIdType() {
        return idType;
    }

    public void setIdType(String idType) {
        this.idType = idType;
    }

    public String getIdNo() {
        return idNo;
    }

    public void setIdNo(String idNo) {
        this.idNo = idNo;
    }

    public String getChannelId() {
        return channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }
}
