package cn.com.duiba.service;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.credits.sdk.CreditNotifyParams;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.thirdparty.dto.HttpRequestMessageDto;
import org.apache.http.client.methods.HttpRequestBase;

import java.util.Map;

/**
 * 接口参数定制服务
 */
public interface CustomService {

    /**
     * 是否是蘑菇街
     *
     * @param appId
     * @return
     */
    public boolean isMogujie(Long appId);

    /**
     * 是否是人人视频
     *
     * @param appId
     * @return
     */
    boolean isRenrenTv(Long appId);

    /**
     * 是否是平安健康
     *
     * @param appId
     * @return
     */
    public boolean isPajk(Long appId);

    /**
     * 是否是淘金币
     *
     * @param appId
     * @return
     */
    boolean isTaojinbi(Long appId);

    boolean isMobike(Long appId);

    /**
     * 是否凤金积分商城
     *
     * @param appId
     * @return
     */
    boolean isFengJin(Long appId);

    boolean isSns(Long appId);

    /**
     * 是否爱奇艺积分商城
     *
     * @param appId
     * @return
     */
    boolean isIqiyi(Long appId);

    /**
     * 阿里体育
     *
     * @param appId
     * @return
     */
    boolean isAlisports(Long appId);

    /**
     * 优酷积分商城
     *
     * @param appId
     * @return
     */
    boolean isYouku(Long appId);

    /**
     * 淘票票
     *
     * @param appId
     * @return
     */
    boolean isTaopiaopiao(Long appId);

    boolean isWatsons(Long appId);

    /**
     * 云集
     * @param appId
     * @return
     */
    boolean isYunJi(Long appId);

    /**
     * 贝因美
     * @param appId
     * @return
     */
    boolean isBeingmate(Long appId);

    /**
     * 苏宁金融
     * @param appId
     * @return
     */
    boolean isSuning(Long appId);

    /**
     * 河北移动
     */
    boolean isHeBeiMobile(Long appId);

    /**
     * 获取减积分请求参数
     *
     * @param req
     * @return
     */
    CreditsMessage getRequestCredits(CreditsMessage req) throws BizException;

    /**
     * 获取减积分请求参数
     *
     * @param subCreditsMsgWrapper
     * @return
     */
    SubCreditsMsgWrapper getRequestCredits(SubCreditsMsgWrapper subCreditsMsgWrapper) throws BizException;

    /**
     * 获取积分响应结果
     *
     * @param body
     * @return
     */
    String getResponseCredits(Long appId, String body, Boolean addCredits, Map<String, String> authParams);

    /**
     * 获取通知请求参数
     *
     * @param notifyUrl
     * @param record
     * @return
     */
    public HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record, String time, AppDO appDO, CreditNotifyParams params);

    /**
     * 获取通知响应结果
     *
     * @param appId
     * @param body
     * @return
     */
    public String getResponseNotify(Long appId, String body);

    public boolean isNotifyWithTransfer(Long appId);

    Map<String, String> toRequestMapWithTransfer(String appSecret, CreditNotifyParams p, String transfer, String uid);

    public SupplierRequest getVirturalRequest(SupplierRequest request);

    public String getVirturalResponse(SupplierRequest message, String body);

    /**
     * 判断是否是菜鸟裹裹appId
     *
     * @param appId
     * @return
     */
    boolean isCainiao(Long appId);

    /**
     * 判断是否是中宏保appId
     * @param appId
     * @return
     */
    boolean isZHBApp(Long appId);

    HttpRequestBase getCrecordHttpRequest(HttpRequestMessageDto msg, AppDO app);

    /**
     * 判断是否是飞猪appId
     *
     * @param appId
     * @return
     */
    boolean isAliTrip(Long appId);

    /**
     * 判断是否是海底捞id
     * */
    boolean isHaiDiLao(Long appId);

	/**
	 * 判断是否是微博的appId
     * @param appId
     * @return
     */
    boolean isWeibo(Long appId);

    /**
     * 判断是否平安壹钱包的appId
     * @param appId
     * @return
     */
    boolean isPayqb(Long appId);

    /**
     * 获取加积分请求参数
     *
     * @param req
     * @return
     */
    CreditsMessageDto getRequestAddCredits(CreditsMessageDto req) throws BizException;

    /**
     * 海底捞 定制 接口 header处理
     * */
    void setHaidilaoSubAndAddHttpHeader(CreditsMessage request, HttpRequestBase http);

    /**
     * 人人视频 加积分/扣积分 接口header定制处理
     * @param authParams
     * @param http
     */
    void setRenrenTvSubOrAddHttpHeader(Map<String, String> authParams, HttpRequestBase http);

    void setSnsAddHttpHeader(Map<String, String> authParams,HttpRequestBase http);

    void setJiuJiuHttpHeader(Map<String, String> authParams,HttpRequestBase http);

    /**
     * 贝因美请求头定制处理
     *
     * @param http
     */
    void setBeingmateHttpHeader(HttpRequestBase http);

    /**
     * 海底捞 定制 接口 header处理
     * */
    HttpRequestBase setHaidilaoVirtualHttpHeader(SupplierRequest message,HttpRequestBase http);

    /**
     * 构建人人视频 虚拟商品请求
     * @param message
     * @return
     */
    HttpRequestBase setRenrenVirtualHttpHeader(SupplierRequest message);

	/**
     *
     * app是否采用post请求方式
     * @return
     */
    boolean isPostApp(Long appId);

    /**
     * 判断是否是搜狐资讯的appId
     * @param appId
     * @return
     */
//    boolean isSohuZiXun(Long appId);

    /**
     * 判断是否是趣头条APP
     * @return
     */
    boolean isFunHeadlines(Long appId);

    /**
     * 判断是否是中信银行APP
     * @return
     */
    boolean isCiticApp(Long appId);

    /**
     * 针对虚拟商品充值，请求参数类没有：请求类型参数，默认使用get请求，趣头条的接口需要post方式请求
     *
     * @param message
     * @param http
     * @return
     */
    HttpRequestBase resetFunHeadlinesVirtualHttpType(SupplierRequest message, HttpRequestBase http);

    boolean isJJY(Long appId);

    HttpRequestBase getSubCreditsHttpRequest(CreditsMessage request);

    HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper request);

    /**
     * 是否农行app
     * @return
     */
    boolean isAbchinaApp(Long appId);

     /**
     *  判断是否为百度APP
     * @param appId
     * @return
     */
    boolean isBaidu(Long appId);
    /**
     *  判断是否为哈啰APP
     * @param appId
     * @return
     */
    boolean isHello(Long appId);

    HttpRequestBase getAddCreditsHttpRequest(CreditsMessageDto creditsMessage);
    /**
     *  判断是否为360借条APP
     * @param appId
     * @return
     */
    boolean isReceipt360(Long appId);

}
