package cn.com.duiba.service.impl;


import cn.com.duiba.biz.credits.AbchinaApi;
import cn.com.duiba.biz.credits.BaiduApi;
import cn.com.duiba.biz.credits.BeingmateApi;
import cn.com.duiba.biz.credits.CainiaoApi;
import cn.com.duiba.biz.credits.CebBankApi;
import cn.com.duiba.biz.credits.CiticApi;
import cn.com.duiba.biz.credits.CustomParamService;
import cn.com.duiba.biz.credits.ErweihuoApi;
import cn.com.duiba.biz.credits.EzrApiService;
import cn.com.duiba.biz.credits.FengJinApi;
import cn.com.duiba.biz.credits.FunHeadlinesApi;
import cn.com.duiba.biz.credits.GangZhongLvApi;
import cn.com.duiba.biz.credits.HaidilaoApi;
import cn.com.duiba.biz.credits.HeBeiMobileApi;
import cn.com.duiba.biz.credits.HelloApi;
import cn.com.duiba.biz.credits.IcbcElifeApi;
import cn.com.duiba.biz.credits.IqiyiApi;
import cn.com.duiba.biz.credits.JJYApi;
import cn.com.duiba.biz.credits.KunshanRCBApi;
import cn.com.duiba.biz.credits.MengJieCreditsApi;
import cn.com.duiba.biz.credits.MiaojieApi;
import cn.com.duiba.biz.credits.MobikeApi;
import cn.com.duiba.biz.credits.MogujieApi;
import cn.com.duiba.biz.credits.PajkApi;
import cn.com.duiba.biz.credits.PayqbApi;
import cn.com.duiba.biz.credits.PinganCardApi;
import cn.com.duiba.biz.credits.QiaQiaApi;
import cn.com.duiba.biz.credits.QqBrowserApi;
import cn.com.duiba.biz.credits.Receipt360Api;
import cn.com.duiba.biz.credits.RenrenTvApi;
import cn.com.duiba.biz.credits.RuixinApi;
import cn.com.duiba.biz.credits.ShandongChinaMobileApi;
import cn.com.duiba.biz.credits.SinaCreditsApi;
import cn.com.duiba.biz.credits.SnsApi;
import cn.com.duiba.biz.credits.SuningApi;
import cn.com.duiba.biz.credits.TaojinbiApi;
import cn.com.duiba.biz.credits.TaopiaopiaoApi;
import cn.com.duiba.biz.credits.WatsonsApi;
import cn.com.duiba.biz.credits.WeiboApi;
import cn.com.duiba.biz.credits.WjrcbApi;
import cn.com.duiba.biz.credits.YoukuApi;
import cn.com.duiba.biz.credits.YunJiApi;
import cn.com.duiba.biz.credits.ZHCreditsApi;
import cn.com.duiba.biz.credits.ZhbSyncApi;
import cn.com.duiba.biz.virtual.AliTripApi;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.config.HelloConfig;
import cn.com.duiba.constant.BeingmateConfig;
import cn.com.duiba.constant.WatsonsConfig;
import cn.com.duiba.credits.sdk.CreditNotifyParams;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.service.CustomService;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.thirdparty.dto.HttpRequestMessageDto;
import cn.com.duiba.tool.HttpRequestLog;
import com.google.common.collect.ImmutableSet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;


/**
 * 接口自定义
 * cusomService应该看待成一个工厂，只起一个forward作用，任何定制的业务逻辑请放到定制的API中，避免散乱于各处
 */
@Service
public class CustomServiceImpl implements CustomService {

    private static Logger log = LoggerFactory.getLogger(CustomServiceImpl.class);

    //24202:沪江开心词场;27068L 搜狗阅读活动; 38854L 搜狗阅读活动测试
    private static final List<Long> NOTIFY_WITH_TRANSFER = Arrays.asList(24202L, 27068L, 38854L, 1l);

    /**
     * 平安健康的appID集合
     */
    private static final List<Long> pajkAppIds = Arrays.asList(27271L, 30703L, 31294L);

    private static final List<Long> mobikeIds=Arrays.asList(33888L,28651L,35830L);

    private static final List<Long> iqiyiIds=Arrays.asList(31819L,33713L,37066L,38347L);

    private static final List<Long> alisportsIds=Arrays.asList(21394L,36558L);

    private static final List<Long> youkuIds=Arrays.asList(45031L,46112L,46113L);

    private static final List<Long> taopiaopiaoIds=Arrays.asList(47077L,47074L);

    private static final List<Long> haidilaoIds = Arrays.asList(47663L,48685L);

    private static final List<Long> weiboAppIds = Arrays.asList(49006L);

    private static final List<Long> usePostAppIds = Arrays.asList(49006L);

    private static final List<Long> payqbAppIds = Arrays.asList(60814L,61644L);

    private static final List<Long> wjrcbAppIds = Arrays.asList(62363L);

    private static final Set<Long> yunjiAppIds = ImmutableSet.of(64951L);

    private static final List<Long> snsAppIds = Arrays.asList(66453L,66420L);

    private static final Set<Long> baiduAppIds = ImmutableSet.of(62524L);

    private static final Set<Long> receipt360AppIds = ImmutableSet.of(71303L,73910L);

    @Autowired
    private WatsonsConfig watsonsConfig;
    @Autowired
    private HelloConfig helloConfig;
    @Autowired
    private BeingmateConfig beingmateConfig;

    @Value("${mogujie.appId}")
    private Long mogujieAppId;

    @Value("${taojinbi.appId}")
    private Long taojinbiAppId;

    //凤金积分商城
    @Value("${fengjin.appId}")
    private String fengJinAppId;

    @Autowired
    private MogujieApi mogujieApi;

    @Autowired
    private RenrenTvApi renrenTvApi;

    @Autowired
    private PajkApi pajkApi;

    @Autowired
    private TaojinbiApi taojinbiApi;

    @Autowired
    private MobikeApi mobikeApi;

    @Autowired
    private FengJinApi fengJinApi;

    @Autowired
    private IqiyiApi iqiyiApi;

    @Autowired
    private CainiaoApi cainiaoApi;

    @Autowired
    private AliTripApi aliTripApi;

    @Autowired
    private YoukuApi youkuApi;

    @Autowired
    private TaopiaopiaoApi taopiaopiaoApi;

    @Autowired
    private HaidilaoApi haidilaoApi;

    @Autowired
    private WeiboApi weiboApi;

    @Autowired
    private EzrApiService ezrApiService;

    @Autowired
    private WatsonsApi watsonsApi;

    @Autowired
    private FunHeadlinesApi funHeadlinesApi;

    @Autowired
    private CiticApi citicApi;

    @Autowired
    private PayqbApi payqbApi;

    @Autowired
    private WjrcbApi wjrcbApi;

    @Autowired
    private JJYApi jjyApi;

    @Autowired
    private YunJiApi yunJiApi;
    @Autowired
    private BaiduApi baiduApi;

    @Autowired
    private AbchinaApi abchinaApi;
    @Autowired
    private ErweihuoApi erweihuoApi;

    @Autowired
    private SnsApi snsApi;

    @Autowired
    private PinganCardApi pinganCardApi;

    @Autowired
    private HelloApi helloApi;

    @Autowired
    private IcbcElifeApi icbcElifeApi;

    @Autowired
    private CustomParamService customParamService;

    @Autowired
    private QqBrowserApi qqBrowserApi;
    @Autowired
    private MengJieCreditsApi mengJieCreditsApi;
    @Autowired
    private BeingmateApi beingmateApi;
    @Autowired
    private SuningApi suningApi;
    @Autowired
    private MiaojieApi miaojieApi;

    @Autowired
    private ShandongChinaMobileApi shandongChinaMobileApi;

    @Autowired
    private RuixinApi ruixinApi;
    @Autowired
    private CebBankApi cebBankApi;
    @Autowired
    private HeBeiMobileApi heBeiMobileApi;

    @Autowired
    private KunshanRCBApi kunshanRCBApi;

    @Autowired
    private GangZhongLvApi gangZhongLvApi;

    @Autowired
    private Receipt360Api receipt360Api;

    @Autowired
    private SinaCreditsApi sinaCreditsApi;

    @Autowired
    private QiaQiaApi qiaQiaApi;

    @Override
    public boolean isHello(Long appId) {
        return helloConfig.getAppids().contains(appId);
    }

    @Override
    public boolean isReceipt360(Long appId) {
        return appId != null && receipt360AppIds.contains(appId);
    }

    @Override
    public HttpRequestBase getAddCreditsHttpRequest(CreditsMessageDto message) {
        if (message.getAppId() == null) {
            return null;
        }
        Long appId = Long.valueOf(message.getAppId());
        if (gangZhongLvApi.isGangZhongLv(appId)) {
            return gangZhongLvApi.getAddCreditsMessage(message);
        }
        if (qiaQiaApi.isQiaQia(appId)) {
            return qiaQiaApi.getAddCreditsMessage(message);
        }

        return null;
    }

    @Override
    public boolean isSns(Long appId) {
        return snsAppIds.contains(appId);
    }
    @Autowired
    private ZHCreditsApi zhCreditsApi;
    @Autowired
    private ZhbSyncApi zhbSyncApi;

    @Override
    public boolean isFengJin(Long appId){
        return fengJinAppId != null && Arrays.asList(fengJinAppId.replace(" ", "").split(",")).contains(appId + "");
    }

    @Override
    public boolean isMogujie(Long appId) {
        return mogujieAppId != null && mogujieAppId.equals(appId);
    }

    @Override
    public boolean isRenrenTv(Long appId) {
        return renrenTvApi.isRenrenTv(appId);
    }

    @Override
    public boolean isCainiao(Long appId) {
        return CainiaoApi.isCainiao(appId);
    }

    @Override
    public boolean isZHBApp(Long appId) {
        return zhbSyncApi.isZHBApp(appId);
    }

    @Override
    public boolean isAliTrip(Long appId) {
        return AliTripApi.isAliTrip(appId);
    }

    @Override
    public boolean isPajk(Long appId) {
        return appId != null && pajkAppIds.contains(appId);
    }

    @Override
    public boolean isTaojinbi(Long appId) {
        return taojinbiAppId != null && taojinbiAppId.equals(appId);
    }
    @Override
    public boolean isMobike(Long appId){
        return mobikeIds.contains(appId);
    }

    @Override
    public boolean isIqiyi(Long appId) {
        return appId != null && iqiyiIds.contains(appId);
    }

    @Override
    public boolean isYouku(Long appId) { return appId != null && youkuIds.contains(appId); }

    @Override
    public boolean isTaopiaopiao(Long appId) { return appId != null && taopiaopiaoIds.contains(appId); }

    @Override
    public boolean isAlisports(Long appId) {
        return appId != null && alisportsIds.contains(appId);
    }

    @Override
    public boolean isHaiDiLao(Long appId) {
        return appId != null && haidilaoIds.contains(appId);
    }

    @Override
    public boolean isWeibo(Long appId){
        return appId != null && weiboAppIds.contains(appId);
    }

    @Override
    public boolean isWatsons(Long appId){
        return appId != null && watsonsConfig.getWatsonsAppIdSet().contains(appId);
    }

    @Override
    public boolean isYunJi(Long appId) {
        return null != appId && yunjiAppIds.contains(appId);
    }

    @Override
    public boolean isBeingmate(Long appId) {
        return null != appId && beingmateConfig.beLongToBeingmate(appId);
    }

    @Override
    public boolean isSuning(Long appId) {
        return suningApi.isSuningApp(appId);
    }

    @Override
    public boolean isHeBeiMobile(Long appId) {
        return heBeiMobileApi.isHeBeiMobile(appId);
    }

    @Override
    public boolean isPayqb(Long appId) {
        return null != appId && payqbAppIds.contains(appId);
    }

    private boolean isWjrcb(Long appId) {
        return null != appId && wjrcbAppIds.contains(appId);
    }

    @Override
    public boolean isJJY(Long appId) {
        return jjyApi.isJJY(appId);
    }

    @Override
    public HttpRequestBase getSubCreditsHttpRequest(CreditsMessage message) {
        if (message.getAppId() == null) {
            return null;
        }
        Long appId = Long.valueOf(message.getAppId());
        if (isWjrcb(appId)) {
            return wjrcbApi.getSubCreditsHttpRequest(message);
        }
        if (gangZhongLvApi.isGangZhongLv(appId)) {
            return gangZhongLvApi.getSubCreditsMessage(message);
        }
        if (qiaQiaApi.isQiaQia(appId)) {
            return qiaQiaApi.getSubCreditsMessage(message);
        }

        return null;
    }

    @Override
    public HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message) {
        if (message.getSubCreditsMsg().getAppId() == null) {
            return null;
        }
        Long appId = message.getSubCreditsMsg().getAppId();
        if (isWjrcb(appId)) {
            return wjrcbApi.getMqSubCreditsHttpRequest(message);
        }
        if (gangZhongLvApi.isGangZhongLv(appId)) {
            return gangZhongLvApi.getSubCreditsMessage(message);
        }
        if (qiaQiaApi.isQiaQia(appId)) {
            return qiaQiaApi.getSubCreditsMessage(message);
        }
        return null;
    }

    @Override
    public CreditsMessage getRequestCredits(CreditsMessage request) throws BizException {//NOSONAR
        if (request.getAppId() == null) {
            return request;
        }
        Long appId = Long.valueOf(request.getAppId());
        if (miaojieApi.isMiaojieApp(appId)) {
            return miaojieApi.getSubCreditsMessage(request);
        }
        if (suningApi.isSuningApp(appId)) {
            return suningApi.getSubCreditsMessage(request);
        }
        if (isMogujie(appId)) {
            return mogujieApi.getMogujieRequestCredits(request);
        }
        if (isPajk(appId)) {
            return pajkApi.getPajkRequestCredits(request);
        }
        if (isTaojinbi(appId)) {
            return taojinbiApi.getCreditsMessage(request);
        }
        if(isMobike(appId)){
            return mobikeApi.buildSubCreditsRequest(request);
        }
        if (isFengJin(appId)) {
            return fengJinApi.getSubCreditsMessage(request);
        }
        if (isIqiyi(appId)) {
            return iqiyiApi.getSubCreditsMessage(request);
        }
        if (CainiaoApi.isCainiao(appId)) {
            return cainiaoApi.getRequestCredits(request);
        }
        if (isYouku(appId)) {
            return youkuApi.getSubCreditsMessage(request);
        }
        if (isTaopiaopiao(appId)) {
            return taopiaopiaoApi.getSubCreditsMessage(request);
        }
        if(isHaiDiLao(appId)){
            return haidilaoApi.getSubCreditsMessage(request);
        }
        if(isWeibo(appId)){
            return weiboApi.getSubCreditsMessage(request);
        }
        if(isRenrenTv(appId)) {
            return renrenTvApi.getSubCreditsMessage(request);
        }
        if (isPayqb(appId)){
            return payqbApi.getSubCreditsMessage(request);
        }
        if (jjyApi.isJJY(appId)) {
            return jjyApi.getSubCreditsMessage(request);
        }
        if(isBaidu(appId)){
            return baiduApi.getSubCreditsMessage(request);
        }
        if(erweihuoApi.isErweihuo(appId)){
            return erweihuoApi.getSubCredits(request);
        }
        if (zhCreditsApi.isZHApp(appId)) {
            return zhCreditsApi.getSubCreditsMessage(request);
        }
        if(icbcElifeApi.isIcbcApp(appId)){
            return icbcElifeApi.getSubCreditsMessage(request);
        }
        if (shandongChinaMobileApi.isShandongChinaMobile(appId)) {
            return shandongChinaMobileApi.getSubCreditsMessage(request);
        }
        if (cebBankApi.isCebBank(appId)){
            return cebBankApi.getSubCreditsMessage(request);
        }
        if(isReceipt360(appId)){
            return receipt360Api.getSubCreditsMessage(request);
        }
        return request;
    }

    @Override
    public SubCreditsMsgWrapper getRequestCredits(SubCreditsMsgWrapper subCreditsMsgWrapper) throws BizException { //NOSONAR
        if (subCreditsMsgWrapper.getSubCreditsMsg().getAppId() == null) {
            return subCreditsMsgWrapper;
        }
        Long appId = subCreditsMsgWrapper.getSubCreditsMsg().getAppId();
        if (miaojieApi.isMiaojieApp(appId)) {
            return miaojieApi.getSubCreditsMessage(subCreditsMsgWrapper);
        }
        if (suningApi.isSuningApp(appId)) {
            return suningApi.getSubCreditsMessage(subCreditsMsgWrapper);
        }
        if (isMogujie(appId)) {
            return mogujieApi.getMogujieRequestCredits(subCreditsMsgWrapper);
        }
        if (isPajk(appId)) {
            return pajkApi.getPajkRequestCredits(subCreditsMsgWrapper);
        }
        if (isTaojinbi(appId)) {
            return taojinbiApi.getCreditsMessage(subCreditsMsgWrapper);
        }
        if(isMobike(appId)){
            return mobikeApi.buildSubCreditsRequest(subCreditsMsgWrapper);
        }
        if (isFengJin(appId)) {
            return fengJinApi.getSubCreditsMessage(subCreditsMsgWrapper);
        }
        if (isIqiyi(appId)) {
            return iqiyiApi.getSubCreditsMessage(subCreditsMsgWrapper);
        }
        if (CainiaoApi.isCainiao(appId)) {
            return cainiaoApi.getRequestCredits(subCreditsMsgWrapper);
        }
        if (isYouku(appId)) {
            return youkuApi.getRequestCredits(subCreditsMsgWrapper);
        }
        if(isHaiDiLao(appId)){
            return haidilaoApi.getRequestCredits(subCreditsMsgWrapper);
        }
        if(isWeibo(appId)){
            return weiboApi.getRequestCredits(subCreditsMsgWrapper);
        }
        //对接过ezr平台的开发者
        if(ezrApiService.isEzr(appId)){
            return ezrApiService.getRequestCredits(subCreditsMsgWrapper);
        }
        if(isFunHeadlines(appId)){
            return funHeadlinesApi.getRequestCredits(subCreditsMsgWrapper);
        }
        if(isRenrenTv(appId)) {
            return renrenTvApi.getRequestCredits(subCreditsMsgWrapper);
        }
        if(isPayqb(appId)){
            return payqbApi.getRequestCredits(subCreditsMsgWrapper);
        }
        if (jjyApi.isJJY(appId)) {
            return jjyApi.getSubCreditsMessage(subCreditsMsgWrapper);
        }
        if(isAbchinaApp(appId)){
            return abchinaApi.getSubCreditsMessage(subCreditsMsgWrapper);
        }
        if(isBaidu(appId)){
            return baiduApi.getSubCreditsMessage(subCreditsMsgWrapper);
        }
        if (erweihuoApi.isErweihuo(appId)) {
            return erweihuoApi.getSubCredits(subCreditsMsgWrapper);
        }
        if (customParamService.isCustomParamApp(appId)) {
            return customParamService.getSubCreditsMessage(subCreditsMsgWrapper);
        }
        if (zhCreditsApi.isZHApp(appId)) {
            return zhCreditsApi.getSubCreditsMessage(subCreditsMsgWrapper);
        }
        if (icbcElifeApi.isIcbcApp(appId)) {
            return icbcElifeApi.getSubCreditsMessage(subCreditsMsgWrapper);
        }
        if (mengJieCreditsApi.isMengJie(appId)) {
            return mengJieCreditsApi.getMogujieRequestCredits(subCreditsMsgWrapper);
        }
        if (shandongChinaMobileApi.isShandongChinaMobile(appId)) {
            return shandongChinaMobileApi.getSubCreditsMessage(subCreditsMsgWrapper);
        }
        if (cebBankApi.isCebBank(appId)) {
            return cebBankApi.getSubCreditsMessage(subCreditsMsgWrapper);
        }

        if (kunshanRCBApi.isKunshanRCBApp(appId)) {
            return kunshanRCBApi.getSubCreditsMessage(subCreditsMsgWrapper);
        }
        if (isWatsons(appId)) {
            return watsonsApi.getSubCredits(subCreditsMsgWrapper);
        }

        if(isReceipt360(appId)){
            return receipt360Api.getSubCreditsMessage(subCreditsMsgWrapper);
        }
        return subCreditsMsgWrapper;
    }

    @SuppressWarnings("squid:S3776")
    @Override
    public String getResponseCredits(Long appId, String body, Boolean addCredits, Map<String, String> authParams) {//NOSONAR
        if (appId == null) {
            return body;
        }
        HttpRequestLog.logUrl("[action subCredits response][appId " + appId + "] [type completed] [body " + body + "]");
        if (miaojieApi.isMiaojieApp(appId)) {
            return miaojieApi.getMiaojieResponseCredis(body,authParams);
        }
        if (suningApi.isSuningApp(appId)) {
            return suningApi.getSuningResponseCredis(body,authParams);
        }
        if (isMogujie(appId)) {
            return mogujieApi.getMogujieResponseCredis(body);
        }
        if (isPajk(appId)) {
            return pajkApi.getPajkResponseCredits(appId, body);
        }
        if (isTaojinbi(appId)) {
            return taojinbiApi.parseCreditsRsp(body);
        }
        if (CainiaoApi.isCainiao(appId)) {
            return cainiaoApi.parseCreditsRsp(body);
        }
        if (isYouku(appId)) {
            return youkuApi.parseCreditsRsp(body);
        }
        if (isTaopiaopiao(appId)) {
            return taopiaopiaoApi.parseCreditsRsp(body);
        }
        if(ezrApiService.isEzr(appId)){
            return ezrApiService.parseCreditsRsp(body);
        }
        if (zhCreditsApi.isZHApp(appId)) {
            return zhCreditsApi.parseCreditsRsp(body,authParams);
        }
        if (qqBrowserApi.isQqBrowserApp(appId)) {
            return qqBrowserApi.parseCreditsRsp(body);
        }
        if (mengJieCreditsApi.isMengJie(appId)) {
            return mengJieCreditsApi.parseCreditsRsp(body);
        }
        if (kunshanRCBApi.isKunshanRCBApp(appId)) {
            return kunshanRCBApi.parseCreditsRsp(body);
        }
        if(gangZhongLvApi.isGangZhongLv(appId)){
            return gangZhongLvApi.parseCreditsRsp(body,addCredits,authParams);
        }
        if (sinaCreditsApi.isSinaApp(appId) && addCredits) {
            return sinaCreditsApi.parseResponse(body);
        }
        if(qiaQiaApi.isQiaQia(appId)){
            return qiaQiaApi.parseCreditsRsp(body,addCredits,authParams);
        }
        return getRes(appId,body,addCredits);
    }

    private String getRes(Long appId, String body, Boolean addCredits){//NOSONAR
        if(isFunHeadlines(appId)){
            return funHeadlinesApi.parseCreditsRsp(body);
        }
        if(isRenrenTv(appId)) {
            return renrenTvApi.parseCreditsRsp(body);
        }
        if(isPayqb(appId)){
            return payqbApi.parseCrditsRsp(body);
        }
        if (isWjrcb(appId)) {
            return wjrcbApi.parseCreditsRsp(body);
        }
        if (shandongChinaMobileApi.isShandongChinaMobile(appId)) {
            return shandongChinaMobileApi.parseCreditsRsp(body);
        }
        if (jjyApi.isJJY(appId)) {
            return jjyApi.parseCrditsRsp(body);
        }
        if (isWatsons(appId)) {
            return watsonsApi.parseCreditsRsp(body, addCredits);
        }
        if(isSns(appId)){
            return snsApi.parseCreditsRsp(body);
        }
        if(erweihuoApi.isErweihuo(appId)){
            return erweihuoApi.parseCrditsRsp(body);
        }
        if (isAbchinaApp(appId)){
            return abchinaApi.parseCreditsRsp(body);
        }
        if(icbcElifeApi.isIcbcApp(appId)){
            return icbcElifeApi.parseCreditsRsp(body);
        }
        return body;
    }

    @Override
    public HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record,String time, AppDO appDO, CreditNotifyParams params) {//NOSONAR
        try {
            if (miaojieApi.isMiaojieApp(record.getAppId())) {
                return miaojieApi.getMiaojieRequestNotify(record);
            }
            if (isMogujie(record.getAppId())) {
                return mogujieApi.getMogujieRequestNotify(notifyUrl, record);
            }
            if (isPajk(record.getAppId())) {
                return pajkApi.getPajkRequestNotify(notifyUrl, record);
            }
            if(isMobike(record.getAppId())){
                return mobikeApi.getMobikeNotifyUrl(notifyUrl,record,time);
            }
            if (isFengJin(record.getAppId())) {
                return fengJinApi.getRequestNotify(notifyUrl, record, appDO);
            }
            if (isIqiyi(record.getAppId())) {
                return iqiyiApi.getRequestNotify(notifyUrl, record);
            }
            if(isCainiao(record.getAppId())){
                return cainiaoApi.getRequestNotify(notifyUrl, record, appDO, params);
            }
            if (isYouku(record.getAppId())) {
                return youkuApi.getRequestNotify(notifyUrl,record);
            }
            if(isHaiDiLao(record.getAppId())){
                return haidilaoApi.getRequestNotify(notifyUrl, record, appDO, params);
            }
            //对接过ezr平台的开发者
            if(ezrApiService.isEzr(record.getAppId())){
                return ezrApiService.getRequestNotify(notifyUrl,record,appDO);
            }
            if(isRenrenTv(record.getAppId())) {
                return renrenTvApi.getRequestNotify(notifyUrl, params);
            }
            if (isWjrcb(record.getAppId())) {
                return wjrcbApi.getRequestNotify(notifyUrl, record);
            }
            if (isBaidu(record.getAppId())) {
                return baiduApi.getRequestNotify(notifyUrl, record, params);
            }
            if (cebBankApi.isCebBank(record.getAppId())){
                return cebBankApi.getRequestNotify(notifyUrl, record, appDO);
            }
            if(isReceipt360(record.getAppId())){
                return receipt360Api.getRequestNotify(record, appDO, params);
            }

            return null;

        } catch (Exception e) {
            log.error("getRequestNotify", e.getMessage());
            throw new IllegalStateException("notify error", e);
        }
    }

    @Override
    public String getResponseNotify(Long appId, String body) {
        try {
            if (miaojieApi.isMiaojieApp(appId)) {
                HttpRequestLog.logUrl("[action notify response][appId " + appId + "] [type completed] [body " + body + "]");
                return miaojieApi.getMiaojieResponseNotify(body);
            }
            if (isMogujie(appId)) {
                HttpRequestLog.logUrl("[action notify response][appId " + appId + "] [type completed] [body " + body + "]");
                return mogujieApi.getMogujieResponseNotify(body);
            }
            else if (isPajk(appId)) {
                HttpRequestLog.logUrl("[action notify response][appId " + appId + "] [type completed] [body " + body + "]");
                return pajkApi.getPajkResponseNotify(body);
            }
            else if(isRenrenTv(appId)) {
                HttpRequestLog.logUrl("[action notify response][appId " + appId + "] [type completed] [body " + body + "]");
                return renrenTvApi.getResponseNotify(body);
            }
            else if (isWjrcb(appId)) {
                HttpRequestLog.logUrl("[action notify response][appId " + appId + "] [type completed] [body " + body + "]");
                return wjrcbApi.getResponseNotify(body);
            }
        } catch (Exception e) {
            log.error("getResponseNotify", e);
        }
        return body;
    }

    @Override
    public boolean isNotifyWithTransfer(Long appId) {
        return NOTIFY_WITH_TRANSFER.contains(appId);
    }

    @Override
    public Map<String, String> toRequestMapWithTransfer(String appSecret, CreditNotifyParams p, String transfer, String uid) {//uid没有get方法
        HashMap map = new HashMap();
        map.put("success", Boolean.toString(p.isSuccess()));
        map.put("errorMessage", getString(p.getErrorMessage()));
        map.put("bizId", getString(p.getBizId()));
        map.put("appKey", getString(p.getAppKey()));
        map.put("appSecret", getString(appSecret));
        map.put("timestamp", getString(Long.valueOf(p.getTimestamp().getTime())));
        map.put("uid", getString(uid));
        map.put("orderNum", getString(p.getOrderNum()));
        map.put("transfer", getString(transfer));
        String sign = SignTool.sign(map);
        map.remove("appSecret");
        map.put("sign", sign);
        return map;
    }

    private String getString(Object o) {
        return o == null ? "" : o.toString();
    }

    @Override
    public SupplierRequest getVirturalRequest(SupplierRequest request) {//NOSONAR
        if(request.getAppId() == null){
            return request;
        }
        //如果是蘑菇街的魔豆
        Long appId=Long.valueOf(request.getAppId());
        if(isMogujie(appId)){
            return mogujieApi.getMogujieRequestSendCredits(request);
        }
        if(isMobike(appId)){
            return mobikeApi.getVirtualRequest(request);
        }
        if(isIqiyi(appId)){
            return iqiyiApi.getVirtualRequest(request);
        }
        if(isAliTrip(appId)){
            return aliTripApi.getVirtualRequest(request);
        }
        if(isHaiDiLao(appId)){
            return haidilaoApi.getVirtualRequest(request);
        }
        if(isYouku(appId)){
            return youkuApi.getVirtualRequest(request);
        }
        if(isWeibo(appId)){
            return weiboApi.getVirtualRequest(request);
        }
        if(isWatsons(appId)){
            return watsonsApi.getVirtualRequest(request);
        }
        if(isFunHeadlines(appId)){
            return funHeadlinesApi.getVirturalRequest(request);
        }
        if(isCiticApp(appId)){
            return citicApi.getVirturalRequest(request);
        }
        if(isRenrenTv(appId)) {
            return renrenTvApi.getVirtualRequest(request);
        }
        if(isPayqb(appId)){
            return payqbApi.getVirtualRequest(request);
        }
        if (isYunJi(appId)){
            return yunJiApi.getVirtualRequest(request);
        }
        if(isSns(appId)){
            return snsApi.getVirtualRequest(request);
        }
        if(isHello(appId)){
            return helloApi.getVirtualRequest(request);
        }
        if (pinganCardApi.isPingan(appId)){
            return pinganCardApi.getVirturalRequest(request);
        }
        if (isBaidu(appId)) {
            return baiduApi.getVirtualRequest(request);
        }
        if (isBeingmate(appId)) {
            return beingmateApi.getVirtualRequest(request);
        }
        if (suningApi.isSuningApp(appId)) {
            return suningApi.getVirtualRequest(request);
        }
        if(ruixinApi.isRuixin(appId)){
            return ruixinApi.getVirtualRequest(request);
        }
        if (cebBankApi.isCebBank(appId)){
            return cebBankApi.getVirtualRequest(request);
        }
        if (heBeiMobileApi.isHeBeiMobile(appId)){
            return heBeiMobileApi.getVirtualRequest(request);
        }
        return request;
    }

    @Override
    public String getVirturalResponse(SupplierRequest message, String body) {//NOSONAR
        if(message.getAppId() == null){
            return body;
        }
        //蘑菇街魔豆,以后有扩展还需要进一步划分
        Long appId=Long.valueOf(message.getAppId());
        if(isMogujie(appId)){
            return mogujieApi.getVirtualRespone(body);
        }
        if(isIqiyi(appId)){
            return iqiyiApi.getVirtualRespone(body);
        }
        if(isAliTrip(appId)){
            return aliTripApi.getVirtualRespone(body);
        }
        if(isHaiDiLao(appId)){
            return haidilaoApi.getVirtualRespone(message,body);
        }
        if(isYouku(appId)){
            return youkuApi.getVirtualRespone(body);
        }
        if (isWatsons(appId)){
            return watsonsApi.getVirtualRespone(body);
        }
        if(isFunHeadlines(appId)){
            return funHeadlinesApi.getVirturalResponse(message, body);
        }
        if(isCiticApp(appId)){
            return citicApi.getVirturalResponse(message, body);
        }
        if(isRenrenTv(appId)) {
            return renrenTvApi.getVirtualRespone(body);
        }
        if (isYunJi(appId)) {
            return yunJiApi.getVirtualResponse(message, body);
        }
        if(isSns(appId)){
            return snsApi.getVirtualResponse(body);
        }
        if (pinganCardApi.isPingan(appId)){
            return pinganCardApi.getVirturalResponse(body);
        }
        if (beingmateConfig.beLongToBeingmate(appId)){
            return beingmateApi.getVirtualResponse(message, body);
        }
        if (suningApi.isSuningApp(appId)){
            return suningApi.getVirtualResponse(message, body);
        }
        if(ruixinApi.isRuixin(appId)){
            return ruixinApi.getVirtualResponse(message,body);
        }
        if (gangZhongLvApi.isGangZhongLv(appId)){
            return gangZhongLvApi.getVirtualResponse(message,body);
        }
        if (heBeiMobileApi.isHeBeiMobile(appId)){
            return heBeiMobileApi.getVirtualResponse(message, body);
        }
        if(qiaQiaApi.isQiaQia(appId)){
            return qiaQiaApi.getVirtualResponse(message,body);
        }
        return body;
    }

    @Override
    public HttpRequestBase getCrecordHttpRequest(HttpRequestMessageDto msg, AppDO app) {
        if(app == null){
            return null;
        }

        if(isCainiao(app.getId())){
            return cainiaoApi.getCrecordNotify(msg, app);
        }else if(isZHBApp(app.getId())){
            return zhbSyncApi.getCrecordNotify(msg, app);
        }
        return null;
    }

    @Override
    public CreditsMessageDto getRequestAddCredits(CreditsMessageDto request) throws BizException {//NOSONAR
        if (request.getAppId() == null) {
            return request;
        }
        Long appId = Long.valueOf(request.getAppId());
        if (miaojieApi.isMiaojieApp(appId)) {
            return miaojieApi.getAddCreditsMessage(request);
        }
        if (isTaopiaopiao(appId)) {
            return taopiaopiaoApi.getAddCreditsMessage(request);
        }
        if (isPajk(appId)) {
            return pajkApi.getAddCreditsMessage(request);
        }
        if(isHaiDiLao(appId)){
            return haidilaoApi.getAddCreditsMessage(request);
        }
        if(isWeibo(appId)){
            return weiboApi.getAddCreditsMessage(request);
        }
        //对接过ezr平台的开发者
        if(ezrApiService.isEzr(appId)){
            return ezrApiService.getAddCreditsMessage(request);
        }
        if(isFunHeadlines(appId)){
            return funHeadlinesApi.getAddCreditsMessage(request);
        }
        if(isRenrenTv(appId)) {
            return renrenTvApi.getAddCreditsMessage(request);
        }
        if(isPayqb(appId)){
            return payqbApi.getAddCreditsMessage(request);
        }
        if (jjyApi.isJJY(appId)) {
            return jjyApi.getAddCreditsMessage(request);
        }
        if (isWatsons(appId)) {
            return watsonsApi.getAddCreditsMessage(request);
        }
        if(isSns(appId)){
            return snsApi.getAddCreditsMessage(request);
        }
        if(erweihuoApi.isErweihuo(appId)){
            return erweihuoApi.getAddCreditsMessage(request);
        }
        if (zhCreditsApi.isZHApp(appId)) {
            return zhCreditsApi.getAddCreditsMessage(request);
        }
        if(icbcElifeApi.isIcbcApp(appId)){
            return icbcElifeApi.getAddCreditsMessage(request);
        }
        if (mengJieCreditsApi.isMengJie(appId)) {
            return mengJieCreditsApi.getAddCreditsMessage(request);
        }
        if (cebBankApi.isCebBank(appId)){
            return cebBankApi.getAddCreditsMessage(request);
        }
        if(kunshanRCBApi.isKunshanRCBApp(appId)){
            return kunshanRCBApi.getAddCreditsMessage(request);
        }
        if (sinaCreditsApi.isSinaApp(appId)) {
            return sinaCreditsApi.getAddCreditsMessage(request);
        }
        return getRequestAddCreditsAgain(request, appId);
    }

    /**
     * 解决sonar复杂度分成两个方法
     * @param request
     * @param appId
     * @return
     * @throws BizException
     */
    public CreditsMessageDto getRequestAddCreditsAgain(CreditsMessageDto request, Long appId) throws BizException{
        if (qqBrowserApi.isQqBrowserApp(appId)){
            return qqBrowserApi.getAddCreditsMessage(request);
        }
        return request;
    }
    @Override
    public void setHaidilaoSubAndAddHttpHeader(CreditsMessage request, HttpRequestBase http) {
        haidilaoApi.setHttpHeader(request,http,true);
    }

    @Override
    public void setRenrenTvSubOrAddHttpHeader(Map<String, String> authParams, HttpRequestBase http) {
        renrenTvApi.setHttpHeader(authParams, http);
    }

    @Override
    public void setSnsAddHttpHeader(Map<String, String> authParams,HttpRequestBase http) {
        snsApi.setHttpHeader(authParams,http);
    }

    @Override
    public void setJiuJiuHttpHeader(Map<String, String> authParams, HttpRequestBase http) {
        jjyApi.setJJYHttpHead(authParams, http);
    }

    @Override
    public void setBeingmateHttpHeader(HttpRequestBase http) {
        beingmateApi.setHttpHeader(http);
    }

    @Override
    public HttpRequestBase  setHaidilaoVirtualHttpHeader(SupplierRequest message,HttpRequestBase http) {
        return haidilaoApi.setHaidilaoVirtualHttpHeader(message,http);
    }

    @Override
    public HttpRequestBase setRenrenVirtualHttpHeader(SupplierRequest message) {
        return renrenTvApi.setVirtualHttpHeader(message);
    }

    @Override
    public boolean isPostApp(Long appId) {
        return null != appId && usePostAppIds.contains(appId);
    }

    @Override
    public boolean isFunHeadlines(Long appId) {
        return funHeadlinesApi.isFunHeadlines(appId);
    }

    @Override
    public boolean isCiticApp(Long appId) {
        return citicApi.isCiticApp(appId);
    }

    @Override
    public HttpRequestBase resetFunHeadlinesVirtualHttpType(SupplierRequest message, HttpRequestBase http) {
        return funHeadlinesApi.resetFunHeadlinesVirtualHttpType(message,http);
    }

    @Override
    public boolean isAbchinaApp(Long appId) {
        return abchinaApi.isAbchinaApp(appId);
    }

    @Override
    public boolean isBaidu(Long appId) {
        return null != appId && baiduAppIds.contains(appId);
    }
}
