/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.constant.JiuJiuYaConstants;
import cn.com.duiba.domain.RequestTypeEnum;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.net.URLDecoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JJYApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(JJYApi.class);
    @Autowired
    private JiuJiuYaConstants jiuJiuYaConstants;
    private static Map<String, String> codeAppIdMaps = new ImmutableMap.Builder().put((Object)"310117", (Object)"$1$UZlOGk6B$/2X97agCaZOkGzgqXF4.R1").put((Object)"6543", (Object)"$1$oyfHoWps$3euCg.HlWrGHoqVKG/8050").build();
    private static Map<String, String> codeSecrets = new ImmutableMap.Builder().put((Object)"310117", (Object)"$1$u5dzVzFY$BOi6AE87LPpXONj099JJ11").put((Object)"6543", (Object)"$1$kYGw9ATM$EcLzJLvHPcuzmBfrz8KCI0").build();
    private static ImmutableSet<Long> jjyAppIds = ImmutableSet.of((Object)64115L, (Object)64116L, (Object)73131L);
    private static final String POSTTYPE = "postType";
    private static final String RAW = "raw";

    public boolean isJJY(Long appId) {
        return null != appId && this.jiuJiuYaConstants.getDuibaAppIds().contains(appId);
    }

    private boolean isValid() {
        return System.currentTimeMillis() > this.jiuJiuYaConstants.getValidTime();
    }

    public void setJJYHttpHead(Map<String, String> authParams, HttpRequestBase http) {
        if (this.isValid()) {
            this.setNewHeader(authParams, http);
            return;
        }
        String storeCode = authParams.get("storeCode");
        if (StringUtils.isBlank((String)storeCode) || !codeAppIdMaps.containsKey(storeCode)) {
            LOGGER.warn("\u4f20\u5165\u7684storeCode\u5f02\u5e38, storeCode={}", (Object)storeCode);
            return;
        }
        String appId = codeAppIdMaps.get(storeCode);
        String appSecret = codeSecrets.get(storeCode);
        http.setHeader("app_id", appId);
        http.setHeader("secret", appSecret);
        String ts = DateUtils.getMillisecond().substring(0, 14);
        http.setHeader("ts", ts);
        http.setHeader("model", "customer");
        http.setHeader("store_code", storeCode);
        http.setHeader("method", "updatePoint");
        http.setHeader("Content-Type", "application/json");
        authParams.remove(POSTTYPE);
        authParams.remove("unicodeType");
        authParams.remove("storeCode");
        String msg = JsonTool.objectToJson(authParams);
        String origin = appId + appSecret + ts + msg;
        String sign = DigestUtils.md5Hex((String)origin).toLowerCase();
        http.setHeader("sign", sign);
    }

    private void setNewHeader(Map<String, String> authParams, HttpRequestBase http) {
        String storeCode = authParams.get("store_code");
        authParams.remove(POSTTYPE);
        authParams.remove("unicodeType");
        authParams.remove("storeCode");
        TreeMap<String, String> params = new TreeMap<String, String>(authParams);
        String appId = this.jiuJiuYaConstants.getJjyAppId();
        String appSecret = this.jiuJiuYaConstants.getJjySecret();
        params.put("store_code", storeCode);
        String msg = JSON.toJSONString(params);
        String ts = DateUtils.getMillisecond().substring(0, 14);
        String str = appId + appSecret + ts + msg;
        String sign = DigestUtils.md5Hex((String)str).toLowerCase();
        http.setHeader("app_id", appId);
        http.setHeader("ts", ts);
        http.setHeader("sign", sign);
        http.setHeader("model", "customer");
        http.setHeader("store_code", storeCode);
        http.setHeader("method", "updatePoint");
        http.setHeader("request-channel", "6866");
        http.setHeader("Content-Type", "application/json");
    }

    public CreditsMessage getSubCreditsMessage(CreditsMessage request) {
        String url = request.getHttpUrl();
        String host = url.substring(0, url.indexOf(63));
        request.setHttpUrl(host);
        String params = url.substring(url.indexOf(63) + 1, url.length());
        Map<String, String> crediMap = AssembleTool.getUrlParams(params);
        Map<String, String> jjyMap = this.transferToJJYMap(crediMap, RequestTypeEnum.SUB_CREDITS.getCode());
        jjyMap.put(POSTTYPE, RAW);
        jjyMap.put("unicodeType", "UTF-8");
        if (this.isValid()) {
            jjyMap.put("store_code", crediMap.get("transfer"));
        } else {
            jjyMap.put("storeCode", crediMap.get("transfer"));
        }
        request.setAuthParams(jjyMap);
        request.setHttpType("post");
        return request;
    }

    public SubCreditsMsgWrapper getSubCreditsMessage(SubCreditsMsgWrapper subCreditsMsgWrapper) {
        String url = subCreditsMsgWrapper.getHttpUrl();
        String host = url.substring(0, url.indexOf(63));
        subCreditsMsgWrapper.setHttpUrl(host);
        String urlParams = url.substring(url.indexOf(63) + 1, url.length());
        Map<String, String> crediMap = AssembleTool.getUrlParams(urlParams);
        Map<String, String> jjyMap = this.transferToJJYMap(crediMap, RequestTypeEnum.SUB_CREDITS.getCode());
        jjyMap.put(POSTTYPE, RAW);
        jjyMap.put("unicodeType", "UTF-8");
        if (this.isValid()) {
            jjyMap.put("store_code", crediMap.get("transfer"));
        } else {
            jjyMap.put("storeCode", crediMap.get("transfer"));
        }
        subCreditsMsgWrapper.getSubCreditsMsg().setAuthParams(jjyMap);
        subCreditsMsgWrapper.getSubCreditsMsg().setHttpType(2);
        return subCreditsMsgWrapper;
    }

    public CreditsMessageDto getAddCreditsMessage(CreditsMessageDto request) {
        String url = request.getHttpUrl();
        String host = url.substring(0, url.indexOf(63));
        request.setHttpUrl(host);
        String urlParams = url.substring(url.indexOf(63) + 1, url.length());
        Map<String, String> crediMap = AssembleTool.getUrlParams(urlParams);
        Map<String, String> jjyMap = this.transferToJJYMap(crediMap, RequestTypeEnum.ADD_CREDITS.getCode());
        jjyMap.put(POSTTYPE, RAW);
        jjyMap.put("unicodeType", "UTF-8");
        jjyMap.put("transfer", crediMap.get("transfer"));
        if (this.isValid()) {
            jjyMap.put("store_code", crediMap.get("transfer"));
        }
        request.setAuthParams(jjyMap);
        request.setHttpType("post");
        return request;
    }

    private Map<String, String> transferToJJYMap(Map<String, String> map, int type) {
        HashMap jjyMap = Maps.newHashMap();
        if (this.isValid()) {
            jjyMap.put("open_id", map.get("uid"));
            jjyMap.put("third_party_type", "1");
        } else {
            jjyMap.put("customer_id", map.get("uid"));
        }
        String point = map.get("credits");
        if (type == RequestTypeEnum.SUB_CREDITS.getCode()) {
            jjyMap.put("point", "-" + point);
            jjyMap.put("remark", "\u5151\u5427\u7cfb\u7edf\u6263\u79ef\u5206");
        } else if (type == RequestTypeEnum.ADD_CREDITS.getCode()) {
            jjyMap.put("point", point);
            jjyMap.put("remark", "\u5151\u5427\u7cfb\u7edf\u52a0\u79ef\u5206");
        }
        jjyMap.put("serial_id", map.get("orderNum"));
        return jjyMap;
    }

    public String parseCrditsRsp(String body) {
        try {
            String bodyTemp = URLDecoder.decode(body, "utf-8");
            JSONObject jsonObject = JSONObject.parseObject((String)bodyTemp);
            HashMap map = Maps.newHashMap();
            if ("1".equals(jsonObject.getString("code"))) {
                map.put("status", "ok");
                map.put("bizId", String.valueOf(new Date().getTime()));
            } else {
                map.put("status", "no");
                map.put("errorMessage", jsonObject.getString("message"));
            }
            return JsonTool.objectToJson(map);
        }
        catch (Exception e) {
            LOGGER.info("JJY parseCrditsRsp error,boby is {}", (Object)body, (Object)e);
            return body;
        }
    }

    class MsgInfo {
        private String customer_id;
        private String point;
        private String remark;
        private String serial_id;

        MsgInfo() {
        }

        public String getCustomer_id() {
            return this.customer_id;
        }

        public void setCustomer_id(String customer_id) {
            this.customer_id = customer_id;
        }

        public String getPoint() {
            return this.point;
        }

        public void setPoint(String point) {
            this.point = point;
        }

        public String getRemark() {
            return this.remark;
        }

        public void setRemark(String remark) {
            this.remark = remark;
        }

        public String getSerial_id() {
            return this.serial_id;
        }

        public void setSerial_id(String serial_id) {
            this.serial_id = serial_id;
        }
    }
}

