/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.api.bo.subcredits.SubCreditsMsgDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.constant.KunshanRCBConfig;
import cn.com.duiba.credits.sdk.CreditConsumeParams;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.tool.kunshanRCB.EncryptAPI;
import cn.com.duiba.tool.kunshanRCB.RadixConvertUtils;
import cn.com.duiba.vo.KunshanRCBCreditsChangeVo;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class KunshanRCBApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(KunshanRCBApi.class);
    private static DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    @Resource
    private KunshanRCBConfig bankConfig;

    public boolean isKunshanRCBApp(Long appId) {
        return appId != null && appId.equals(this.bankConfig.getAppId());
    }

    public SubCreditsMsgWrapper getSubCreditsMessage(SubCreditsMsgWrapper subCreditsMsgWrapper) throws BizException {
        String[] env;
        LOGGER.info("kunshanRCB\u6d88\u606f\u961f\u5217\u65b9\u5f0f\u6263\u79ef\u5206\uff0c\u63a5\u6536\u5230SubCreditsMsgWrapper[{}]", (Object)JSON.toJSONString((Object)subCreditsMsgWrapper));
        subCreditsMsgWrapper.setHttpUrl(this.bankConfig.getCreditsUrl());
        SubCreditsMsgDto msg = subCreditsMsgWrapper.getSubCreditsMsg();
        CreditConsumeParams consumeParams = msg.getCreditConsumeParams();
        KunshanRCBCreditsChangeVo creditsChangeVo = new KunshanRCBCreditsChangeVo();
        creditsChangeVo.setVersionNo("V1.0");
        creditsChangeVo.setPointsChannelType("010");
        creditsChangeVo.setFrontDateTime(DATE_TIME_FORMATTER.format(LocalDateTime.now()));
        creditsChangeVo.setAuthoCode("123456");
        String fixedOrderNum = this.getKunshanOrderNum(consumeParams.getOrderNum());
        creditsChangeVo.setReqSeqNo(fixedOrderNum);
        creditsChangeVo.setBackServiceMethod("000002");
        creditsChangeVo.setPointsCertiType("HCNO");
        creditsChangeVo.setCertiNo(consumeParams.getUid());
        creditsChangeVo.setPointsTypeNo("0001");
        creditsChangeVo.setDebcreFlag("D");
        creditsChangeVo.setPointsTranType("0009");
        creditsChangeVo.setTranAmt(BigDecimal.valueOf(consumeParams.getCredits()));
        creditsChangeVo.setSummary(consumeParams.getDescription());
        creditsChangeVo.setSystemTraceNo(fixedOrderNum);
        creditsChangeVo.setTransId("CUF00001");
        creditsChangeVo.setSceneId("A01");
        String data = JSON.toJSONString((Object)creditsChangeVo);
        LOGGER.info("kunshanRCB\u6d88\u606f\u961f\u5217\u65b9\u5f0f\u6263\u79ef\u5206,\u52a0\u5bc6\u524d\u8bf7\u6c42\u660e\u6587:[{}]", (Object)data);
        try {
            env = EncryptAPI.encryptDataEnvelop(this.bankConfig.getKunshanPublicKey(), data);
        }
        catch (Exception e) {
            throw new BizException("kunshanRCB\u6d88\u606f\u961f\u5217\u65b9\u5f0f\u6263\u79ef\u5206,\u52a0\u5bc6\u4fe1\u606f\u62a5\u9519");
        }
        HashMap authParams = Maps.newHashMap();
        authParams.put("key", env[0]);
        authParams.put("data", env[1]);
        authParams.put("postType", "raw");
        msg.setAuthParams((Map)authParams);
        msg.setHttpType(2);
        LOGGER.info("kunshanRCB\u6d88\u606f\u961f\u5217\u65b9\u5f0f\u6263\u79ef\u5206,\u52a0\u5bc6\u540e\u8bf7\u6c42\u4f53\u4e3a:[{}]", (Object)JSON.toJSONString((Object)authParams));
        return subCreditsMsgWrapper;
    }

    private String getKunshanOrderNum(String orderNum) {
        if (StringUtils.isBlank((CharSequence)orderNum)) {
            return orderNum;
        }
        return RadixConvertUtils.transRadix(orderNum, 36, 62);
    }

    private String getDuibaOrderNum(String orderNum) {
        if (StringUtils.isBlank((CharSequence)orderNum)) {
            return orderNum;
        }
        return StringUtils.leftPad((String)RadixConvertUtils.transRadix(orderNum, 36, 62), (int)32, (char)'0');
    }

    public String parseCreditsRsp(String body) {
        LOGGER.info("kunshanRCB\u6d88\u606f\u961f\u5217\u65b9\u5f0f\u52a0\u51cf\u79ef\u5206,\u89e3\u5bc6\u524d\u54cd\u5e94\u4f53\u4e3a:[{}]", (Object)body);
        try {
            JSONObject encryptResponse = JSONObject.parseObject((String)body);
            String key = encryptResponse.getString("key");
            String data = encryptResponse.getString("data");
            String[] decryptData = EncryptAPI.decryptDataEnvelop(this.bankConfig.getDuibaPrivateKey(), key, data);
            JSONObject responseBody = JSONObject.parseObject((String)decryptData[1]);
            LOGGER.info("kunshanRCB\u6d88\u606f\u961f\u5217\u65b9\u5f0f\u52a0\u51cf\u79ef\u5206,\u89e3\u5bc6\u540e\u54cd\u5e94\u4f53\u4e3a:[{}]", (Object)responseBody.toJSONString());
            String status = responseBody.getString("ResCode");
            String message = responseBody.getString("ErrorProm");
            HashMap<String, String> duibaDoc = new HashMap<String, String>();
            if (status != null && "0000".equals(status)) {
                duibaDoc.put("status", "ok");
                duibaDoc.put("bizId", responseBody.getString("HostSeqNo"));
            } else {
                duibaDoc.put("status", "fail");
                if (message != null) {
                    duibaDoc.put("errorMessage", message);
                }
            }
            return JsonTool.objectToJson(duibaDoc);
        }
        catch (Exception e) {
            LOGGER.error("kunshanRCB\u6d88\u606f\u961f\u5217\u65b9\u5f0f\u52a0\u51cf\u79ef\u5206,\u5904\u7406\u54cd\u5e94\u6d88\u606f\u51fa\u9519", (Throwable)e);
            return body;
        }
    }

    public CreditsMessageDto getAddCreditsMessage(CreditsMessageDto messageDto) throws BizException {
        String[] env;
        LOGGER.info("kunshanRCB\u6d88\u606f\u961f\u5217\u65b9\u5f0f\u52a0\u79ef\u5206\uff0c\u63a5\u6536\u5230CreditsMessageDto[{}]", (Object)JSON.toJSONString((Object)messageDto));
        messageDto.setHttpType("post");
        messageDto.setHttpUrl(this.bankConfig.getCreditsUrl());
        Map originAuthParams = messageDto.getAuthParams();
        KunshanRCBCreditsChangeVo creditsChangeVo = new KunshanRCBCreditsChangeVo();
        creditsChangeVo.setVersionNo("V1.0");
        creditsChangeVo.setPointsChannelType("010");
        creditsChangeVo.setFrontDateTime(DATE_TIME_FORMATTER.format(LocalDateTime.now()));
        creditsChangeVo.setAuthoCode("123456");
        creditsChangeVo.setReqSeqNo((String)originAuthParams.get("orderNum"));
        creditsChangeVo.setBackServiceMethod("000002");
        creditsChangeVo.setPointsCertiType("HCNO");
        creditsChangeVo.setCertiNo((String)originAuthParams.get("uid"));
        creditsChangeVo.setPointsTypeNo("0001");
        creditsChangeVo.setDebcreFlag("C");
        creditsChangeVo.setPointsTranType("0009");
        creditsChangeVo.setTranAmt(new BigDecimal((String)originAuthParams.get("credits")));
        creditsChangeVo.setSummary((String)originAuthParams.get("description"));
        creditsChangeVo.setSystemTraceNo((String)originAuthParams.get("orderNum"));
        creditsChangeVo.setPointsDueDateTime(this.bankConfig.getPointsDueDateTime());
        creditsChangeVo.setBrcNo("0000000");
        creditsChangeVo.setBelgtoDept("01000101");
        creditsChangeVo.setTransId("CUF00001");
        creditsChangeVo.setSceneId("A01");
        String data = JSON.toJSONString((Object)creditsChangeVo);
        LOGGER.info("kunshanRCB\u6d88\u606f\u961f\u5217\u65b9\u5f0f\u52a0\u79ef\u5206,\u52a0\u5bc6\u524d\u8bf7\u6c42\u660e\u6587:[{}]", (Object)data);
        try {
            env = EncryptAPI.encryptDataEnvelop(this.bankConfig.getKunshanPublicKey(), data);
        }
        catch (Exception e) {
            throw new BizException("kunshanRCB\u6d88\u606f\u961f\u5217\u65b9\u5f0f\u52a0\u79ef\u5206,\u52a0\u5bc6\u4fe1\u606f\u62a5\u9519");
        }
        HashMap authParams = Maps.newHashMap();
        authParams.put("key", env[0]);
        authParams.put("data", env[1]);
        authParams.put("postType", "raw");
        messageDto.setAuthParams((Map)authParams);
        LOGGER.info("kunshanRCB\u6d88\u606f\u961f\u5217\u65b9\u5f0f\u52a0\u79ef\u5206,\u52a0\u5bc6\u540e\u8bf7\u6c42\u4f53\u4e3a:[{}]", (Object)JSON.toJSONString((Object)messageDto));
        return messageDto;
    }
}

