/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.api.bo.subcredits.SubCreditsMsgDto;
import cn.com.duiba.constant.ReconciliationConfig;
import cn.com.duiba.credits.sdk.CreditConsumeParams;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.service.reconciliation.ReconciliationRecordService;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.thirdparty.dto.reconciliation.ReconciliationRecordDto;
import cn.com.duiba.thirdparty.enums.reconciliation.ReconciliationLogTypeEnum;
import cn.com.duiba.thirdparty.enums.reconciliation.ReconciliationRespStatusEnum;
import cn.com.duiba.tool.AssembleTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReconciliationBizService {
    private static final Logger logger = LoggerFactory.getLogger(ReconciliationBizService.class);
    @Autowired
    private ReconciliationConfig reconciliationConfig;
    @Resource(name="httpCallbackExecutorService")
    private ExecutorService executorService;
    @Autowired
    private ReconciliationRecordService reconciliationRecordService;

    private boolean isReconcile(Long appId) {
        if (appId == null || CollectionUtils.isEmpty(this.reconciliationConfig.getAppIdSet())) {
            return false;
        }
        return this.reconciliationConfig.getAppIdSet().contains(appId);
    }

    public void saveRpcSubCreditsMsg(CreditsMessage request) {
        if (!this.isReconcile(Long.valueOf(request.getAppId()))) {
            return;
        }
        this.executorService.execute(() -> {
            try {
                Map<String, String> authParamMap;
                String url = request.getHttpUrl();
                String orderNum = request.getRelationId();
                if (Objects.equals(request.getHttpType(), "post")) {
                    authParamMap = request.getAuthParams();
                    if (MapUtils.isNotEmpty((Map)authParamMap) && StringUtils.isNotBlank((CharSequence)((CharSequence)authParamMap.get("orderNum")))) {
                        orderNum = authParamMap.get("orderNum");
                    }
                } else {
                    String authParams = url.substring(url.indexOf(63) + 1);
                    authParamMap = AssembleTool.getUrlParams(authParams);
                }
                ReconciliationRecordDto dto = this.wrapReconciliationLog(Long.valueOf(request.getAppId()), orderNum, request.getRelationType(), authParamMap, request.getParams(), ReconciliationLogTypeEnum.SUB_CREDITS);
                this.reconciliationRecordService.saveOrUpdate(dto);
            }
            catch (Exception e) {
                logger.error("save\u5bf9\u8d26\u8bb0\u5f55\u51fa\u9519, appId:{}, relationId:{}, relationType:{}, ", new Object[]{request.getAppId(), request.getRelationId(), request.getRelationType(), e});
            }
        });
    }

    public void saveMqSubCreditsMsg(SubCreditsMsgWrapper subCreditsMsgWrapper) {
        if (!this.isReconcile(subCreditsMsgWrapper.getSubCreditsMsg().getAppId())) {
            return;
        }
        this.executorService.execute(() -> {
            try {
                ReconciliationRecordDto dto = this.wrapReconciliationLog(subCreditsMsgWrapper);
                this.reconciliationRecordService.saveOrUpdate(dto);
            }
            catch (Exception e) {
                logger.error("save\u5bf9\u8d26\u8bb0\u5f55\u51fa\u9519, appId:{}, relationId:{}, relationType:{}, ", new Object[]{subCreditsMsgWrapper.getSubCreditsMsg().getAppId(), subCreditsMsgWrapper.getSubCreditsMsg().getRelationId(), subCreditsMsgWrapper.getSubCreditsMsg().getRelationType(), e});
            }
        });
    }

    private ReconciliationRecordDto wrapReconciliationLog(SubCreditsMsgWrapper subCreditsMsgWrapper) {
        SubCreditsMsgDto subCreditsMsgDto = subCreditsMsgWrapper.getSubCreditsMsg();
        CreditConsumeParams creditConsumeParams = subCreditsMsgDto.getCreditConsumeParams();
        Map paramMap = subCreditsMsgDto.getParams();
        ReconciliationRecordDto reconciliationRecordDto = new ReconciliationRecordDto();
        reconciliationRecordDto.setOrderNum(subCreditsMsgDto.getRelationId());
        reconciliationRecordDto.setPartnerUserId(creditConsumeParams.getUid());
        reconciliationRecordDto.setLogType(Integer.valueOf(ReconciliationLogTypeEnum.SUB_CREDITS.getCode()));
        reconciliationRecordDto.setSendTime(new Date());
        if (MapUtils.isNotEmpty((Map)paramMap)) {
            reconciliationRecordDto.setOptId((String)paramMap.get("opId"));
        }
        if (subCreditsMsgDto.getRelationType() != null) {
            reconciliationRecordDto.setOptType(subCreditsMsgDto.getRelationType().getMsg());
        }
        reconciliationRecordDto.setCredits(creditConsumeParams.getCredits());
        reconciliationRecordDto.setAppId(subCreditsMsgDto.getAppId());
        return reconciliationRecordDto;
    }

    private ReconciliationRecordDto wrapReconciliationLog(Long appId, String relationId, String relationType, Map<String, String> authParamMap, Map<String, String> paramMap, ReconciliationLogTypeEnum logTypeEnum) {
        String credits;
        ReconciliationRecordDto reconciliationRecordDto = new ReconciliationRecordDto();
        reconciliationRecordDto.setOrderNum(relationId);
        reconciliationRecordDto.setPartnerUserId(authParamMap.get("uid"));
        reconciliationRecordDto.setLogType(Integer.valueOf(logTypeEnum.getCode()));
        reconciliationRecordDto.setSendTime(new Date());
        if (MapUtils.isNotEmpty(paramMap)) {
            reconciliationRecordDto.setOptId(paramMap.get("opId"));
        }
        if (StringUtils.isNotBlank((CharSequence)relationType)) {
            reconciliationRecordDto.setOptType(relationType);
        }
        if (StringUtils.isNotBlank((CharSequence)(credits = authParamMap.get("credits")))) {
            reconciliationRecordDto.setCredits(Long.valueOf(credits));
        }
        reconciliationRecordDto.setAppId(appId);
        return reconciliationRecordDto;
    }

    public void saveAddCreditsMsg(CreditsMessageDto request) {
        if (!this.isReconcile(Long.valueOf(request.getAppId()))) {
            return;
        }
        this.executorService.execute(() -> {
            try {
                Map<String, String> authParamMap;
                String url = request.getHttpUrl();
                String orderNum = request.getRelationId();
                if (Objects.equals(request.getHttpType(), "post")) {
                    authParamMap = request.getAuthParams();
                    if (MapUtils.isNotEmpty((Map)authParamMap) && StringUtils.isNotBlank((CharSequence)((CharSequence)authParamMap.get("orderNum")))) {
                        orderNum = authParamMap.get("orderNum");
                    }
                } else {
                    String authParams = url.substring(url.indexOf(63) + 1);
                    authParamMap = AssembleTool.getUrlParams(authParams);
                }
                ReconciliationRecordDto dto = this.wrapReconciliationLog(Long.valueOf(request.getAppId()), orderNum, request.getRelationType(), authParamMap, request.getParams(), ReconciliationLogTypeEnum.ADD_CREDITS);
                this.reconciliationRecordService.saveOrUpdate(dto);
            }
            catch (Exception e) {
                logger.error("save\u5bf9\u8d26\u8bb0\u5f55\u51fa\u9519, appId:{}, relationId:{}, relationType:{}, ", new Object[]{request.getAppId(), request.getRelationId(), request.getRelationType(), e});
            }
        });
    }

    public void mallExchangeNotify(ReconciliationRecordDto dto) {
        if (!this.isReconcile(dto.getAppId())) {
            return;
        }
        this.reconciliationRecordService.saveOrUpdate(dto);
    }

    public void updateCreditsRsp(Long appId, String body, Boolean addCredits, String relationId, String relationType) {
        if (!this.isReconcile(appId)) {
            return;
        }
        this.executorService.execute(() -> {
            try {
                ReconciliationRecordDto reconciliationRecordDto = new ReconciliationRecordDto();
                reconciliationRecordDto.setOrderNum(relationId);
                reconciliationRecordDto.setLogType(Integer.valueOf(ReconciliationLogTypeEnum.SUB_CREDITS.getCode()));
                reconciliationRecordDto.setAppId(appId);
                reconciliationRecordDto.setOptType(relationType);
                if (addCredits.booleanValue()) {
                    reconciliationRecordDto.setLogType(Integer.valueOf(ReconciliationLogTypeEnum.ADD_CREDITS.getCode()));
                }
                this.parseRespBody(body, reconciliationRecordDto);
                this.reconciliationRecordService.update(reconciliationRecordDto);
            }
            catch (Exception e) {
                logger.error("update\u54cd\u5e94\u7ed3\u679c\u51fa\u9519, appId:{}, relationId:{}, relationType:{}, body:{}, ", new Object[]{appId, relationId, relationType, body, e});
            }
        });
    }

    private void parseRespBody(String body, ReconciliationRecordDto dto) {
        String respBody = body;
        if (StringUtils.isNotBlank((CharSequence)body)) {
            dto.setResponseStatus(Integer.valueOf(ReconciliationRespStatusEnum.FAIL.getCode()));
            JSONObject json = JSON.parseObject((String)body);
            if (json != null && ("success".equalsIgnoreCase(json.getString("status")) || "ok".equalsIgnoreCase(json.getString("status")))) {
                dto.setResponseStatus(Integer.valueOf(ReconciliationRespStatusEnum.SUCCESS.getCode()));
            }
            if (respBody.length() > 255) {
                respBody = respBody.substring(0, 255);
            }
            dto.setResponseBody(respBody);
        }
    }
}

