/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.config.SinaCreditsConfig;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.JsonTool;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SinaCreditsApi {
    private static final Logger LOGGRER = LoggerFactory.getLogger(SinaCreditsApi.class);
    public static final String SIGN_TYPE = "md5";
    public static final Set<Long> SINA_APPIDS = Sets.newHashSet((Object[])new Long[]{56617L});
    private static final String DELIMITER = "?";
    @Autowired
    private SinaCreditsConfig sinaCreditsConfig;

    public boolean isSinaApp(Long appId) {
        return SINA_APPIDS.contains(appId);
    }

    public CreditsMessageDto getAddCreditsMessage(CreditsMessageDto request) throws BizException {
        Map originAuthParams = request.getAuthParams();
        TreeMap<String, String> treeMap = this.convertParam(originAuthParams);
        String sign = this.getSign(treeMap, this.sinaCreditsConfig.getSecertKey());
        treeMap.put("sign", sign);
        treeMap.put("sign_type", SIGN_TYPE);
        request.setAuthParams(treeMap);
        request.setHttpType("get");
        String host = this.getGateway(request.getHttpUrl());
        request.setHttpUrl(AssembleTool.assembleUrl(host, treeMap));
        return request;
    }

    public String parseResponse(String body) {
        HashMap<String, String> duibaDoc = new HashMap<String, String>();
        JSONObject resultJson = new JSONObject();
        if (StringUtils.isEmpty((CharSequence)body) || body.trim().startsWith("[")) {
            duibaDoc.put("status", "fail");
            duibaDoc.put("message", "\u8fd4\u56de\u4f53 body \u5f02\u5e38");
            LOGGRER.info("[SinaCreditsApi-parseResponse]\u65b0\u6d6a\u5fae\u535a\u54cd\u5e94\u5f02\u5e38[body={}]", (Object)body);
            return JsonTool.objectToJson(duibaDoc);
        }
        try {
            resultJson = JSONObject.parseObject((String)body);
        }
        catch (Exception e) {
            LOGGRER.error("\u65b0\u6d6a\u5fae\u535a\u8f6c\u8d26\u52a0\u79ef\u5206\u63a5\u53e3\u8fd4\u56de json\u53cd\u5e8f\u5217\u5316\u5931\u8d25, body={}", (Object)body, (Object)e);
        }
        String code = resultJson.getString("code");
        if ("100000".equals(code)) {
            duibaDoc.put("status", "success");
            duibaDoc.put("transfer_id", resultJson.getString("transfer_id"));
        } else {
            duibaDoc.put("status", "fail");
            duibaDoc.put("message", resultJson.getString("msg"));
        }
        duibaDoc.put("data", body);
        return JsonTool.objectToJson(duibaDoc);
    }

    public TreeMap<String, String> convertParam(Map<String, String> originAuthParams) throws BizException {
        String out_apply_id = originAuthParams.get("orderNum");
        String granted_uid = originAuthParams.get("uid");
        String jf = originAuthParams.get("credits");
        String subject = originAuthParams.get("description");
        if (StringUtils.isEmpty((CharSequence)out_apply_id) || StringUtils.isEmpty((CharSequence)granted_uid) || !NumberUtils.isNumber((String)jf)) {
            LOGGRER.info("sinaCredit request params: " + JSONObject.toJSONString(originAuthParams));
            throw new BizException("\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38");
        }
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put("source", this.sinaCreditsConfig.getSource());
        treeMap.put("type", this.sinaCreditsConfig.getDefaultType());
        treeMap.put("out_apply_id", out_apply_id);
        treeMap.put("grant_uid", this.sinaCreditsConfig.getGrantUid());
        treeMap.put("granted_uid", granted_uid);
        treeMap.put("jf", jf);
        treeMap.put("subject", StringUtils.isNotBlank((CharSequence)subject) ? subject : this.sinaCreditsConfig.getDefaultSubject());
        return treeMap;
    }

    private String byte2hex(byte[] b) {
        StringBuilder hs = new StringBuilder();
        String stmp = "";
        for (byte aB : b) {
            stmp = Integer.toHexString(aB & 0xFF);
            if (stmp.length() == 1) {
                hs.append("0").append(stmp);
                continue;
            }
            hs.append(stmp);
        }
        return hs.toString().toUpperCase();
    }

    private String getSign(TreeMap<String, String> params, String secret) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        StringBuilder orgin = new StringBuilder();
        for (String key : keys) {
            orgin.append(key).append("=");
            if (StringUtils.isNotBlank((CharSequence)params.get(key))) {
                orgin.append(params.get(key));
            }
            orgin.append("&");
        }
        String paramStr = orgin.substring(0, orgin.length() - 1) + secret;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return this.byte2hex(md.digest(paramStr.getBytes(StandardCharsets.UTF_8))).toLowerCase();
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getGateway(String url) {
        int index;
        if (StringUtils.isNotBlank((CharSequence)url) && (index = url.indexOf(DELIMITER)) > 0) {
            return url.substring(0, index);
        }
        return url;
    }
}

