/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.domain.ResultGeneralModel;
import cn.com.duiba.domain.TopStarResultVO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.CaiNiaoTool;
import cn.com.duiba.tool.JsonTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TaopiaopiaoApi {
    private static Logger logger = LoggerFactory.getLogger(TaopiaopiaoApi.class);
    private static final String TAOPIAOPIAO_APPKEY = "24327934";
    private static final String TAOPIAOPIAO_APPSECRET = "c290043acee4a46c99c47c6382b99f2c";
    private static final String TAOPIAOPIAO_VERSION = "2.0";
    private static final String TAOPIAOPIAO_METHOD = "taobao.film.star.operate";
    private static final String TAOPIAOPIAO_SIGN_METHOD = "hmac";
    private static final String TAOPIAOPIAO_FORMAT = "json";
    private static final String TAOPIAOPIAO_PARTNER_ID = "DUIBA";
    private static final String OPERATE_ADD = "ADD";
    private static final String OPERATE_CONSUME = "CONSUME";
    private static final String DELIMITER = "?";

    public CreditsMessage getSubCreditsMessage(CreditsMessage request) {
        try {
            String url = request.getHttpUrl();
            String host = this.getGateway(url);
            Map originalParams = request.getAuthParams();
            Map<String, String> paramsMap = this.bulidParms(originalParams, OPERATE_CONSUME);
            request.setHttpType("get");
            request.setHttpUrl(AssembleTool.assembleUrl(host, paramsMap));
        }
        catch (Exception e) {
            logger.error("[TaopiaopiaoApi-getSubCreditsMessage]error:{}", (Throwable)e);
        }
        return request;
    }

    public CreditsMessageDto getAddCreditsMessage(CreditsMessageDto request) {
        try {
            String url = request.getHttpUrl();
            String host = this.getGateway(url);
            Map originalParams = request.getAuthParams();
            Map<String, String> paramsMap = this.bulidParms(originalParams, OPERATE_ADD);
            request.setHttpType("get");
            request.setHttpUrl(AssembleTool.assembleUrl(host, paramsMap));
        }
        catch (Exception e) {
            logger.error("[TaopiaopiaoApi-getAddCreditsMessage]error:{}", (Throwable)e);
        }
        return request;
    }

    @Nullable
    private String getGateway(String url) {
        int index;
        if (StringUtils.isNotBlank((String)url) && (index = url.indexOf(DELIMITER)) != -1) {
            return url.substring(0, index);
        }
        return url;
    }

    @NotNull
    private Map<String, String> bulidParms(Map<String, String> params, String operate) throws IOException {
        HashMap paramsMap = Maps.newHashMap();
        paramsMap.put("timestamp", this.getTimestamp());
        paramsMap.put("v", TAOPIAOPIAO_VERSION);
        paramsMap.put("app_key", TAOPIAOPIAO_APPKEY);
        paramsMap.put("method", TAOPIAOPIAO_METHOD);
        paramsMap.put("sign_method", TAOPIAOPIAO_SIGN_METHOD);
        paramsMap.put("partner_id", TAOPIAOPIAO_PARTNER_ID);
        paramsMap.put("format", TAOPIAOPIAO_FORMAT);
        paramsMap.put("operate_type", operate);
        paramsMap.put("open_id", params.get("uid"));
        JSONObject paramJson = new JSONObject();
        paramJson.put("starPoint", (Object)params.get("credits"));
        paramJson.put("describe", (Object)params.get("description"));
        paramJson.put("bizKey", (Object)params.get("orderNum"));
        paramJson.put("channel", (Object)"2001");
        paramsMap.put("params", paramJson.toString());
        paramsMap.put("sign", CaiNiaoTool.signTopRequest(paramsMap, TAOPIAOPIAO_APPSECRET));
        return paramsMap;
    }

    private String getTimestamp() {
        SimpleDateFormat dateTimeformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dateTimeformat.format(new Date());
    }

    public String parseCreditsRsp(String body) {
        try {
            JSONObject jsonBody = JSON.parseObject((String)body);
            JSONObject response = jsonBody.getJSONObject("film_star_operate_response");
            ResultGeneralModel resultGeneralModel = (ResultGeneralModel)JSONObject.parseObject((String)response.getString("result"), ResultGeneralModel.class);
            TopStarResultVO topStarResultVO = resultGeneralModel.getReturnValue();
            HashMap<String, String> duibaDoc = new HashMap<String, String>();
            duibaDoc.put("errorMessage", topStarResultVO.getErrorMessage());
            duibaDoc.put("status", topStarResultVO.getStatus());
            duibaDoc.put("bizId", topStarResultVO.getBizId());
            duibaDoc.put("credits", topStarResultVO.getStarPoint());
            return JsonTool.objectToJson(duibaDoc);
        }
        catch (Exception e) {
            logger.error("[TaopiaopiaoApi-parseCreditsRsp]\u6dd8\u7968\u7968\u8bf7\u6c42\u5f02\u5e38\uff0c\u54cd\u5e94\u89e3\u6790\u51fa\u9519:{}", (Throwable)e);
            return body;
        }
    }
}

