/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits.impl;

import cn.com.duiba.api.bo.custom.funheadlines.FunheadLinesAppMapping;
import cn.com.duiba.biz.credits.FunHeadlinesApi;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.constant.FunHeadlinesConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.thirdparty.enums.funheadlines.FunHeadlinesErrorCode;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.FunHeadlinesSignTool;
import cn.com.duiba.tool.JsonTool;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FunHeadlinesApiImpl
implements FunHeadlinesApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(FunHeadlinesApiImpl.class);
    public static final String CREDITS = "5000";
    private static final String DELIMITER = "?";
    @Autowired
    private FunHeadlinesConfig funHeadlinesConfig;

    @Override
    public Boolean isFunHeadlines(Long appId) {
        return this.funHeadlinesConfig.getAppIds().contains(appId);
    }

    @Override
    public SubCreditsMsgWrapper getRequestCredits(SubCreditsMsgWrapper subCreditsMsgWrapper) {
        Map<String, String> newParams;
        Map originParams = subCreditsMsgWrapper.getSubCreditsMsg().getAuthParams();
        try {
            newParams = this.rebuildCreditsParams(originParams);
        }
        catch (BizException e) {
            LOGGER.info("[FunHeadlinesApiImpl-getRequestCredits]info:", (Throwable)e);
            return subCreditsMsgWrapper;
        }
        subCreditsMsgWrapper.getSubCreditsMsg().setAuthParams(newParams);
        subCreditsMsgWrapper.getSubCreditsMsg().setHttpType(2);
        String url = subCreditsMsgWrapper.getHttpUrl();
        String host = url.indexOf(63) == -1 ? url : url.substring(0, url.indexOf(63));
        subCreditsMsgWrapper.setHttpUrl(host);
        return subCreditsMsgWrapper;
    }

    @Override
    public CreditsMessageDto getAddCreditsMessage(CreditsMessageDto request) {
        Map<String, String> newParams;
        Map originParams = request.getAuthParams();
        try {
            newParams = this.rebuildCreditsParams(originParams);
        }
        catch (BizException e) {
            LOGGER.info("[FunHeadlinesApiImpl-getAddCreditsMessage]info:", (Throwable)e);
            return request;
        }
        request.setAuthParams(newParams);
        request.setHttpType("post");
        String url = request.getHttpUrl();
        String host = url.indexOf(63) == -1 ? url : url.substring(0, url.indexOf(63));
        request.setHttpUrl(host);
        return request;
    }

    @Override
    public SupplierRequest getVirturalRequest(SupplierRequest request) {
        Map<String, String> newParams;
        String url = request.getHttpUrl();
        List<String> analysisList = FunHeadlinesApiImpl.analysisUrl(url);
        if (CollectionUtils.isEmpty(analysisList)) {
            return request;
        }
        String host = analysisList.get(0);
        Map<String, String> params = AssembleTool.getUrlParams(analysisList.get(1));
        HashMap authParams = Maps.newHashMap();
        authParams.put("uid", params.get("uid"));
        authParams.put("orderNum", params.get("orderNum"));
        authParams.put("credits", params.get("params"));
        authParams.put("transfer", params.get("transfer"));
        try {
            newParams = this.rebuildCreditsParams(authParams);
        }
        catch (BizException e) {
            LOGGER.info("[FunHeadlinesApiImpl-getVirturalRequest]info:", (Throwable)e);
            return request;
        }
        request.setAuthParams(newParams);
        request.setHttpUrl(host);
        return request;
    }

    @Override
    public String getVirturalResponse(SupplierRequest message, String body) {
        HashMap<String, String> duibaDoc = new HashMap<String, String>();
        try {
            String data = this.checkResponse(body);
            duibaDoc.put("status", "success");
            duibaDoc.put("data", data);
        }
        catch (Exception e) {
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", e.getMessage());
            LOGGER.info("[FunHeadlinesApiImpl-getVirturalResponse]\u8da3\u5934\u6761-\u865a\u62df\u5546\u54c1\u8bf7\u6c42\u54cd\u5e94\u89e3\u6790\u5f02\u5e38:", (Throwable)e);
        }
        return JsonTool.objectToJson(duibaDoc);
    }

    @Override
    public String parseCreditsRsp(String body) {
        HashMap duibaDoc = Maps.newHashMap();
        try {
            this.checkResponse(body);
            duibaDoc.put("status", "ok");
        }
        catch (Exception e) {
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", e.getMessage());
            LOGGER.info("[FunHeadlinesApiImpl-parseCreditsRsp]\u8da3\u5934\u6761-\u52a0/\u51cf\u79ef\u5206\u8bf7\u6c42\u54cd\u5e94\u89e3\u6790\u5f02\u5e38:", (Throwable)e);
        }
        duibaDoc.put("credits", CREDITS);
        return JsonTool.objectToJson(duibaDoc);
    }

    @Override
    public HttpRequestBase resetFunHeadlinesVirtualHttpType(SupplierRequest request, HttpRequestBase http) {
        return AssembleTool.assembleRequest(request.getHttpUrl(), request.getAuthParams());
    }

    private Map<String, String> rebuildCreditsParams(Map<String, String> originParams) throws BizException {
        String transfer = originParams.get("transfer");
        FunheadLinesAppMapping mapping = this.getMapping(transfer);
        HashMap<String, String> authParams = new HashMap<String, String>();
        authParams.put("app_id", mapping.getAppId());
        authParams.put("open_id", originParams.get("uid"));
        authParams.put("coin_num", originParams.get("credits"));
        authParams.put("trade_no", originParams.get("orderNum"));
        String sign = FunHeadlinesSignTool.sign(authParams, mapping.getAppkey());
        authParams.put("sign", sign);
        return authParams;
    }

    private String checkResponse(String result) throws BizException {
        JSONObject resultJson = JSONObject.parseObject((String)result);
        if (null == resultJson) {
            throw new BizException(FunHeadlinesErrorCode.E20001.getDesc());
        }
        String code = resultJson.getString("code");
        FunHeadlinesErrorCode funHeadlinesErrorCode = FunHeadlinesErrorCode.valueOfCode((String)code);
        if (!Objects.equals(FunHeadlinesErrorCode.SUCCESS, funHeadlinesErrorCode)) {
            throw new BizException(funHeadlinesErrorCode.getDesc());
        }
        String dataString = resultJson.getString("data");
        if (StringUtils.isBlank((String)dataString)) {
            throw new BizException(FunHeadlinesErrorCode.E20002.getDesc());
        }
        return dataString;
    }

    private FunheadLinesAppMapping getMapping(String appId) throws BizException {
        FunheadLinesAppMapping mapping = this.funHeadlinesConfig.getFunheadLinesAppMappingByAppId(appId);
        if (mapping == null) {
            throw new BizException(FunHeadlinesErrorCode.E20005.getDesc()).withCode(FunHeadlinesErrorCode.E20005.getCode());
        }
        return mapping;
    }

    private static List<String> analysisUrl(String url) {
        ArrayList analysis = Lists.newArrayList();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)url)) {
            int index = url.indexOf(DELIMITER);
            if (index != -1) {
                analysis.add(url.substring(0, index));
                analysis.add(url.substring(index + 1, url.length()));
            } else {
                analysis.add(url);
                analysis.add("");
            }
        }
        return analysis;
    }
}

