/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.mq;

import cn.com.duiba.boot.profiler.DBTimeProfiler;
import cn.com.duiba.mq.MqSentCallback;
import cn.com.duiba.wolf.utils.GZIPUtils;
import com.alibaba.ttl.threadpool.TtlExecutors;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RocketMQMsgProducer {
    private static final Logger LOG = LoggerFactory.getLogger(RocketMQMsgProducer.class);
    @Autowired
    private DefaultMQProducer rocketMqProducer;
    private static final int MAX_RETRY_TIMES = 3;
    @Autowired
    private ExecutorService executorService;
    private final ExecutorService mqRetryExecutor = TtlExecutors.getTtlExecutorService((ExecutorService)new ThreadPoolExecutor(4, 8, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(10000), new ThreadFactory(){
        private int index = 0;

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "rocketmq-producer-retry" + this.index++);
        }
    }));

    @DBTimeProfiler
    public void sendMsg(String topic, String tag, String key, String message, boolean useGzip, MqSentCallback callback) {
        MqResult ret = this.doSendMsg(topic, tag, key, message, useGzip, callback);
        if (!ret.success && ret.msg != null) {
            this.mqRetryExecutor.execute(() -> this.retry(ret));
        } else {
            if (callback == null) {
                return;
            }
            this.executorService.execute(() -> {
                try {
                    callback.onSuccess();
                }
                catch (Exception e) {
                    LOG.error("", (Throwable)e);
                }
            });
        }
    }

    @DBTimeProfiler
    private MqResult doSendMsg(String topic, String tag, String key, String message, boolean useGzip, MqSentCallback callback) {
        Message msg = null;
        try {
            SendResult ret;
            boolean success;
            byte[] body = useGzip ? GZIPUtils.gzip((String)message) : message.getBytes("utf-8");
            msg = new Message(topic, tag, body);
            if (StringUtils.isNotEmpty((String)key)) {
                msg.setKeys(key);
            }
            boolean bl = success = SendStatus.SEND_OK == (ret = this.rocketMqProducer.send(msg)).getSendStatus() || SendStatus.FLUSH_SLAVE_TIMEOUT == ret.getSendStatus() || SendStatus.SLAVE_NOT_AVAILABLE == ret.getSendStatus();
            if (!success) {
                LOG.warn("MQ\u53d1\u9001\u5931\u8d25, sendStatus={}, topic={}, tag={}, key={}, msg={}", new Object[]{ret.getSendStatus(), topic, tag, key, message});
            }
            MqResult mqResult = new MqResult();
            mqResult.success = success;
            mqResult.msg = msg;
            mqResult.callback = callback;
            return mqResult;
        }
        catch (Exception e) {
            LOG.error("Send mq failed, topic={}, tag={}, key={}, msg={}", new Object[]{topic, tag, key, message, e});
            MqResult mqResult = new MqResult();
            mqResult.success = false;
            mqResult.msg = msg;
            mqResult.callback = callback;
            return mqResult;
        }
    }

    @DBTimeProfiler
    void retry(MqResult mqResult) {
        mqResult.retryTimes++;
        try {
            if (mqResult.retryTimes > 3) {
                LOG.error("MQ\u53d1\u9001\u5931\u8d25\u91cd\u8bd5{}\u6b21\uff0c\u4f9d\u65e7\u5931\u8d25\uff0c\u53d6\u6d88\u91cd\u8bd5\uff0ctopic={}, tag={}", new Object[]{3, mqResult.msg.getTopic(), mqResult.msg.getTags()});
                if (mqResult.callback != null) {
                    mqResult.callback.onFail();
                }
                return;
            }
            TimeUnit.SECONDS.sleep(1 << mqResult.retryTimes);
            SendResult sendResult = this.rocketMqProducer.send(mqResult.msg);
            if (mqResult.callback != null && (SendStatus.SEND_OK == sendResult.getSendStatus() || SendStatus.FLUSH_SLAVE_TIMEOUT == sendResult.getSendStatus() || SendStatus.SLAVE_NOT_AVAILABLE == sendResult.getSendStatus())) {
                mqResult.callback.onSuccess();
            } else {
                this.retry(mqResult);
            }
        }
        catch (InterruptedException e) {
            LOG.warn("", (Throwable)e);
        }
        catch (Exception e) {
            LOG.warn("", (Throwable)e);
            this.retry(mqResult);
        }
    }

    private class MqResult {
        private boolean success;
        private Message msg;
        private int retryTimes = 0;
        private MqSentCallback callback;

        private MqResult() {
        }
    }
}

