/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.impl;

import cn.com.duiba.service.DingService;
import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.remoteservice.RemoteAdminService;
import cn.com.duiba.tool.CodeException;
import cn.com.duiba.tool.ErrorCode;
import com.dingHelper.auth.AuthHelper;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.DingTalkRequest;
import com.dingtalk.api.request.CorpMessageCorpconversationAsyncsendRequest;
import com.dingtalk.api.response.CorpMessageCorpconversationAsyncsendResponse;
import com.dingtalk.chatbot.DingtalkChatbotClient;
import com.dingtalk.chatbot.SendResult;
import com.dingtalk.chatbot.message.Message;
import com.dingtalk.chatbot.message.TextMessage;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.RateLimiter;
import com.taobao.api.ApiException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DingServiceImpl
implements DingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DingServiceImpl.class);
    private static Cache<String, String> cache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private static Map<String, RateLimiter> rateLimiterMap = new ConcurrentHashMap<String, RateLimiter>();
    private static final String DING_MESSAGE_URL = "https://oapi.dingtalk.com/robot/send?access_token=";
    @Value(value="${ding.app.secret}")
    private String secret;
    @Value(value="${ding.app.appId}")
    private String appId;
    @Value(value="${ding.app.agentId}")
    private String dingAgentId;
    @Value(value="${ding.app.restApi}")
    private String dingRestAPi;
    @Autowired
    private RemoteAdminService remoteAdminService;

    @Override
    public void sendPersonalDingTextMsgByEmail(List<String> emails, String text) {
        ArrayList dingUserIds = Lists.newArrayList();
        emails.forEach(email -> {
            AdminDto adminDto = this.remoteAdminService.findByEmail(email);
            if (adminDto != null && StringUtils.isNotEmpty((String)adminDto.getDingUserId())) {
                dingUserIds.add(adminDto.getDingUserId());
            }
        });
        this.sendDingTextMsg(dingUserIds, text);
    }

    @Override
    public void sendPersonalDingTextMsgByDingId(List<String> dingIds, String text) {
        this.sendDingTextMsg(dingIds, text);
    }

    public boolean sendDingTextMsg(List<String> dingUserIds, String text) {
        String userIds = String.join((CharSequence)",", dingUserIds);
        CorpMessageCorpconversationAsyncsendRequest req = new CorpMessageCorpconversationAsyncsendRequest();
        req.setMsgtype("text");
        req.setAgentId(Long.valueOf(this.dingAgentId));
        req.setUseridList(userIds);
        req.setToAllUser(Boolean.valueOf(false));
        req.setMsgcontent("{\"content\": \"" + text + "\"}");
        return this.getResult(req);
    }

    private boolean getResult(CorpMessageCorpconversationAsyncsendRequest req) {
        DefaultDingTalkClient client = new DefaultDingTalkClient(this.dingRestAPi);
        try {
            CorpMessageCorpconversationAsyncsendResponse rsp = (CorpMessageCorpconversationAsyncsendResponse)client.execute((DingTalkRequest)req, this.getAccessToken());
            if (rsp == null) {
                throw new RuntimeException("send" + req.getMsgcontent() + " , result: null");
            }
            return rsp.getResult().getSuccess();
        }
        catch (ApiException e) {
            throw new CodeException(ErrorCode.E9999999, (Throwable)e);
        }
    }

    private String getAccessToken() {
        String cacheKey = "Access_Token";
        try {
            return (String)cache.get((Object)"Access_Token", () -> AuthHelper.getAccessToken((String)this.appId, (String)this.secret));
        }
        catch (ExecutionException e) {
            throw new CodeException(ErrorCode.E9999999, (Throwable)e);
        }
    }

    @Override
    public boolean sendDingQunMessage(String dingTalkToken, String message, boolean isAtAll) {
        RateLimiter temp;
        RateLimiter rateLimiter = rateLimiterMap.get(dingTalkToken);
        if (rateLimiter == null && (temp = rateLimiterMap.putIfAbsent(dingTalkToken, rateLimiter = RateLimiter.create((double)0.3))) != null) {
            rateLimiter = temp;
        }
        rateLimiter.acquire(1);
        TextMessage textMessage = new TextMessage(message);
        textMessage.setIsAtAll(isAtAll);
        DingtalkChatbotClient client = new DingtalkChatbotClient();
        SendResult sendResult = null;
        try {
            sendResult = client.send(DING_MESSAGE_URL + dingTalkToken, (Message)textMessage);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return sendResult.isSuccess();
    }
}

