/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.impl;

import cn.com.duiba.api.bo.credits.CreditsRequest;
import cn.com.duiba.api.bo.credits.CreditsResponse;
import cn.com.duiba.order.center.api.dto.CreditsCallbackMessage;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.service.impl.AbstractCreditsLogExtractor;
import cn.com.duiba.thirdparty.dto.ConsumerCreditsLogSaveDto;
import cn.com.duiba.thirdparty.enums.CreditsLogChangeTypeEnum;
import cn.com.duiba.thirdparty.enums.CreditsLogStatusEnum;
import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
class RpcSubCreditsLogExtractor
extends AbstractCreditsLogExtractor {
    RpcSubCreditsLogExtractor() {
    }

    @Override
    public boolean supportsInternal(CreditsRequest request, CreditsResponse response) {
        return request instanceof CreditsMessage && response instanceof CreditsCallbackMessage;
    }

    @Override
    protected Map<String, String> extractRequestParams(CreditsRequest request) {
        CreditsMessage req = (CreditsMessage)request;
        return req.getAuthParams();
    }

    @Override
    protected ConsumerCreditsLogSaveDto extractInternal(CreditsRequest request, CreditsResponse response) {
        CreditsMessage req = (CreditsMessage)request;
        CreditsCallbackMessage resp = (CreditsCallbackMessage)response;
        ConsumerCreditsLogSaveDto creditsLog = new ConsumerCreditsLogSaveDto();
        creditsLog.setConsumerId(Long.valueOf(req.getConsumerId()));
        creditsLog.setAppId(Long.valueOf(req.getAppId()));
        creditsLog.setChangeType(CreditsLogChangeTypeEnum.SUB);
        creditsLog.setLogStatus(CreditsLogStatusEnum.SUCCESS);
        creditsLog.setOrderTime(new Date(req.getTimestamp()));
        creditsLog.setDeveloperBizId(JSON.parseObject((String)resp.getMessage()).getString("bizId"));
        creditsLog.setBizId(req.getBizId());
        creditsLog.setRelationType(req.getRelationType());
        creditsLog.setRelationId(req.getRelationId());
        return creditsLog;
    }
}

