/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tool;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.tool.sn.InitData;
import cn.com.duiba.tool.sn.Permutation;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssembleTool {
    private static Logger log = LoggerFactory.getLogger(AssembleTool.class);
    private static final String POSTTYPE = "postType";
    private static final String RAW = "raw";
    private static final String UTF8 = "utf-8";
    private static final String SPERATOR = "/";
    private static final List<String> TRANSCODE_LIST = Arrays.asList("snb.duiba.market.active.sign", "snb.duiba.market.active.exchange");

    private AssembleTool() {
    }

    public static Map<String, String> getUrlParams(String urlParams) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isBlank((String)urlParams)) {
            return map;
        }
        String[] params = urlParams.split("&");
        for (int i = 0; i < params.length; ++i) {
            String[] p = params[i].split("=");
            if (p.length != 2) continue;
            String key = p[0];
            String value = p[1];
            if (StringUtils.isNotEmpty((String)value)) {
                try {
                    value = URLDecoder.decode(value, UTF8);
                }
                catch (UnsupportedEncodingException e) {
                    log.error("URLDecoder.decode error:" + value, (Throwable)e);
                }
            }
            map.put(key, value);
        }
        return map;
    }

    public static String assembleUrl(String urlPar, Map<String, String> params) {
        StringBuilder str = new StringBuilder(urlPar);
        if (str.toString().contains("?")) {
            str.append("&");
        } else {
            str.append("?");
        }
        for (Map.Entry<String, String> entry : params.entrySet()) {
            try {
                if (entry.getValue() == null || entry.getValue().length() == 0) {
                    str.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
                    continue;
                }
                str.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), UTF8)).append("&");
            }
            catch (UnsupportedEncodingException e) {
                log.error("assembleUrl", (Throwable)e);
            }
        }
        return str.toString();
    }

    public static String assembleUrlEncodeTwice(String urlPar, Map<String, String> params) {
        StringBuilder str = new StringBuilder(urlPar);
        if (str.toString().contains("?")) {
            str.append("&");
        } else {
            str.append("?");
        }
        for (Map.Entry<String, String> entry : params.entrySet()) {
            try {
                if (StringUtils.isBlank((String)entry.getValue())) {
                    str.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
                    continue;
                }
                str.append(entry.getKey()).append("=").append(URLEncoder.encode(URLEncoder.encode(entry.getValue(), UTF8), UTF8)).append("&");
            }
            catch (UnsupportedEncodingException e) {
                log.error("assembleUrlEncodeTwice", (Throwable)e);
            }
        }
        return str.toString();
    }

    private static HttpPost getSnsHttpPost(String url, Map<String, String> argParams) {
        String finalUrl = url.endsWith(SPERATOR) ? url : url + SPERATOR;
        HttpPost post = new HttpPost(finalUrl + argParams.get("transCode"));
        try {
            String sendStr = Permutation.sort(argParams, InitData.CHARSET_UTF8);
            post.setEntity((HttpEntity)new ByteArrayEntity(sendStr.getBytes()));
        }
        catch (Exception e) {
            log.error("assembleRequest", (Throwable)e);
        }
        return post;
    }

    private static HttpPost getSouHuHttpPost(HttpPost post, Map<String, String> argParams) throws Exception {
        JSONObject jsonObject;
        Boolean isUtfUnicode = StringUtils.isNotBlank((String)argParams.get("unicodeType")) && argParams.get("unicodeType").equals("UTF-8");
        argParams.remove(POSTTYPE);
        argParams.remove("unicodeType");
        String storeCode = argParams.get("storeCode");
        if (StringUtils.isNotBlank((String)storeCode)) {
            argParams.remove("storeCode");
            jsonObject = JSONObject.fromObject(argParams);
            argParams.put("storeCode", storeCode);
        } else {
            jsonObject = JSONObject.fromObject(argParams);
        }
        String json = jsonObject.toString();
        StringEntity postingString = isUtfUnicode != false ? new StringEntity(json, Charset.forName(UTF8)) : new StringEntity(json);
        post.setHeader("Content-Type", "application/json");
        post.setEntity((HttpEntity)postingString);
        return post;
    }

    public static HttpPost assembleRequest(String url, Map<String, String> argParams) {
        if (MapUtils.isNotEmpty(argParams) && argParams.containsKey("transCode") && TRANSCODE_LIST.contains(argParams.get("transCode"))) {
            return AssembleTool.getSnsHttpPost(url, argParams);
        }
        HttpPost post = new HttpPost(url);
        if (argParams == null) {
            argParams = new HashMap<String, String>();
        }
        if (StringUtils.isNotBlank((String)argParams.get(POSTTYPE)) && argParams.get(POSTTYPE).equals(RAW)) {
            try {
                return AssembleTool.getSouHuHttpPost(post, argParams);
            }
            catch (Exception e) {
                log.error("assembleRequest", (Throwable)e);
            }
        }
        if (argParams.get("isZhCreditsRequest") != null) {
            StringEntity postEntity = new StringEntity(argParams.get("body"), UTF8);
            log.info(argParams.get("body"));
            postEntity.setContentEncoding(UTF8);
            postEntity.setContentType("application/json");
            post.setEntity((HttpEntity)postEntity);
            return post;
        }
        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>(argParams.size());
        for (Map.Entry<String, String> entry : argParams.entrySet()) {
            String value = entry.getValue();
            if (value == null) continue;
            pairs.add(new BasicNameValuePair(entry.getKey(), value));
        }
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, Charset.forName(UTF8)));
        return post;
    }

    public static HttpPost assembleRequestJson(String url, String argParams) {
        HttpPost method = new HttpPost(url);
        StringEntity entity = new StringEntity(argParams, UTF8);
        entity.setContentEncoding("UTF-8");
        entity.setContentType("application/json");
        method.setEntity((HttpEntity)entity);
        return method;
    }

    public static HttpPost assemblePostRequest(String url, String jsonParam) {
        HttpPost post = new HttpPost(url);
        if (StringUtils.isBlank((String)jsonParam)) {
            return post;
        }
        try {
            String encoderJson = URLEncoder.encode(jsonParam, "UTF-8");
            StringEntity postingString = new StringEntity(encoderJson, ContentType.create((String)"application/json", (String)"UTF-8"));
            post.setEntity((HttpEntity)postingString);
            return post;
        }
        catch (Exception e) {
            log.error("assembleRequest", (Throwable)e);
            throw new ThirdpatyException(e);
        }
    }

    public static String paramSplic(Map<String, String> params) {
        StringBuilder paramStr = new StringBuilder();
        for (String key : params.keySet()) {
            try {
                if (params.get(key) != null && params.get(key).length() != 0) {
                    paramStr = paramStr.append(key).append("=").append(URLEncoder.encode(params.get(key), UTF8)).append("&");
                    continue;
                }
                paramStr = paramStr.append(key).append("=").append(params.get(key)).append("&");
            }
            catch (UnsupportedEncodingException var5) {
                log.error("\u53c2\u6570={}", (Object)paramStr, (Object)var5.getMessage());
            }
        }
        if (paramStr.lastIndexOf("&") == paramStr.length() - 1) {
            paramStr = paramStr.deleteCharAt(paramStr.length() - 1);
        }
        return paramStr.toString();
    }

    public static List<String> analysisUrl(String url) {
        ArrayList analysisList = Lists.newArrayList();
        if (StringUtils.isNotBlank((String)url)) {
            int index = url.indexOf(63);
            if (index != -1) {
                analysisList.add(url.substring(0, index));
                analysisList.add(url.substring(index + 1, url.length()));
            } else {
                analysisList.add(url);
                analysisList.add("");
            }
        }
        return analysisList;
    }
}

