package cn.com.duiba.biz.credits;

import cn.com.duiba.api.bo.subcredits.SubCreditsMsgDto;
import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.constant.InoherbConstant;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.enums.redis.RedisKeyEnum;
import cn.com.duiba.order.center.api.constant.RedisKeyFactory;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriComponentsBuilder;

import javax.annotation.Resource;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

/**
 * Created by fangdong on 2020/08/17
 */
@Service
public class InoherbApi {
    private static final Logger log = LoggerFactory.getLogger(InoherbApi.class);

    @Resource
    private InoherbConstant inoherbConstant;
    @Resource(name = "httpClient")
    private CloseableHttpClient httpClient;
    @Resource(name = "stringRedisTemplate")
    private StringRedisTemplate redisTemplate;

    /**
     * 是否是该应用
     */
    public boolean isInoherb(Long appId) {
        return inoherbConstant.getAppId().contains(appId);
    }

    /**
     * 加积分
     */
    public HttpRequestBase getAddCreditsHttpRequest(CreditsMessageDto message) {
        String url = message.getHttpUrl();
        String newUrl = url.substring(0, url.indexOf('?'));
        String paramsStr = url.substring(url.indexOf('?') + 1);
        Map<String, String> authParams = AssembleTool.getUrlParams(paramsStr);

        // body
        Map<String, String> body = this.getCreditsHttpBody(authParams,true);

        newUrl = UriComponentsBuilder.fromHttpUrl(newUrl)
                .queryParam("token", this.getAccessToken())
                .build().toUri().toString();

        message.setHttpType(CreditsMessageDto.HTTP_POST);
        message.setHttpUrl(newUrl);
        message.setAuthParams(body);

        return this.getHttpPost(message.getHttpUrl(), JSON.toJSONString(body));
    }

    /**
     * 减积分
     */
    public HttpRequestBase getSubCreditsHttpRequest(SubCreditsMsgWrapper message) {
        String url = message.getHttpUrl();
        String newUrl = url.substring(0, url.indexOf('?'));
        String paramsStr = url.substring(url.indexOf('?') + 1);
        Map<String, String> authParams = AssembleTool.getUrlParams(paramsStr);

        // body
        Map<String, String> body = this.getCreditsHttpBody(authParams, false);

        newUrl = UriComponentsBuilder.fromHttpUrl(newUrl)
                .queryParam("token", this.getAccessToken())
                .build().toUri().toString();

        message.getSubCreditsMsg().setHttpType(SubCreditsMsgDto.HTTP_POST);
        message.setHttpUrl(newUrl);
        message.getSubCreditsMsg().setAuthParams(body);

        return this.getHttpPost(message.getHttpUrl(), JSON.toJSONString(body));
    }

    /**
     * 解析积分响应
     */
    public String parseCreditsResponse(String body, Boolean addCredits, Map<String, String> authParams) {
        log.info("相宜本草加减积分response, add={}, body={}", addCredits, body);

        JSONObject jsonBody = JSON.parseObject(body);

        JSONObject result = new JSONObject();
        if (Objects.equals(0, jsonBody.getInteger("errcode"))) {
            result.put("status", "ok");
            // 开发者不返回订单号，自定义
            result.put("bizId", System.currentTimeMillis() + RandomStringUtils.randomNumeric(6));
            result.put("credits", jsonBody.getJSONObject("result").getLongValue("totalPoint"));
        } else {
            // 若返回token过期,则删除token
            dealTokenExpire(jsonBody);
            result.put("status", "fail");
            result.put("errorMessage", jsonBody.getString("errmsg"));
        }

        return result.toString();
    }

    private void dealTokenExpire(JSONObject jsonBody) {
        try {
            // {"errorMessage":"access_token无效","status":"fail"}
            String errmsg = Optional.ofNullable(jsonBody.getString("errorMessage"))
                    .orElse(jsonBody.getString("errmsg"));
            if (StringUtils.isNotBlank(errmsg) && errmsg.contains("access_token无效")) {
                redisTemplate.delete(getTokenKey());
                log.info("相宜本草获取token,删除过期token成功");
            }
        } catch (Exception e) {
            log.warn("相宜本草获取token,删除过期token失败", e);
        }
    }

    /**
     * 虚拟商品请求
     */
    public HttpRequestBase getVirtualRequest(SupplierRequest request) {
        String url = request.getHttpUrl();
        String newUrl = url.substring(0, url.indexOf('?'));
        String paramsStr = url.substring(url.indexOf('?') + 1);
        Map<String, String> authParams = AssembleTool.getUrlParams(paramsStr);

        String timestamp = String.valueOf(System.currentTimeMillis());
        String[] params = StringUtils.split(authParams.get("params"), "|");

        Map<String, String> body = Maps.newHashMap();
        body.put("code", "sendCouponsInfo");
        body.put("unionId", authParams.get("uid"));
        body.put("cardId", params[0]);
        body.put("money", params[1]);
        body.put("activityId", String.valueOf(System.currentTimeMillis() / 1000));
        body.put("timestamp", timestamp);
        body.put("token", this.getToken(timestamp));

        request.setHttpUrl(newUrl);
        request.setAuthParams(body);
        log.info("相宜本草 虚拟商品发货 url = {}, 数据 = {}", newUrl, JSON.toJSONString(body));
        return this.getHttpPost(newUrl, JSON.toJSONString(body));
    }

    /**
     * 解析虚拟商品充值响应结果
     */
    public String getVirtualResponse(SupplierRequest message, String body) {
        log.info("相宜本草虚拟商品充值响应结果response, body={}", body);

        JSONObject jsonBody = JSON.parseObject(body);

        JSONObject result = new JSONObject();
        if (!Objects.equals(1, jsonBody.getInteger("status"))) {
            result.put("status", "fail");
            result.put("errorMessage", ObjectUtils.firstNonNull(jsonBody.getString("refusereason"), jsonBody.getString("msg")));

            return result.toString();
        }

        result.put("status", "success");
        return result.toString();
    }

    /**
     * 获取加减积分http请求
     */
    private HttpRequestBase getHttpPost(String httpUrl, String jsonBody) {
        HttpPost request = new HttpPost(httpUrl);
        request.setEntity(new StringEntity(jsonBody, ContentType.APPLICATION_JSON));

        return request;
    }

    /**
     * 获取加减积分请求体
     */
    private Map<String, String> getCreditsHttpBody(Map<String, String> authParams, boolean isAdd) {
        Map<String, String> map = Maps.newHashMap();
        map.put("unionid", authParams.get("uid"));
        if (isAdd) {
            map.put("changePoint", authParams.get("credits"));
        }else {
            map.put("changePoint", "-" + authParams.get("credits"));
        }
        map.put("changeRemark", authParams.get("description"));
        map.put("changeId", authParams.get("orderNum"));

        return map;
    }

    /**
     * 获取开发者access_token
     */
    public String getAccessToken() {
        String redisKey = getTokenKey();
        if (inoherbConstant.getOldToken()) {
            redisTemplate.delete(redisKey);
            return getOldAccessToken();
        }
        //先从redis获取token
        String token = redisTemplate.opsForValue().get(redisKey);
        if (StringUtils.isNotBlank(token)) {
            return token;
        }
        String redisLockKey = RedisKeyEnum.K003.toString() + DateUtil.today();
        while (!redisTemplate.opsForValue().setIfAbsent(redisLockKey, "")) {
            try {
                Thread.sleep(1000L);
                token = redisTemplate.opsForValue().get(redisKey);
                if (StringUtils.isNotBlank(token)) {
                    return token;
                }
            } catch (InterruptedException e) {
                log.error("相宜本草加锁失败", e);
            }
        }
        token = redisTemplate.opsForValue().get(redisKey);
        if (StringUtils.isNotBlank(token)) {
            return token;
        }
        redisTemplate.expire(redisLockKey, 10, TimeUnit.SECONDS);
        return HttpGetToken(redisKey, redisLockKey);
    }

    @NotNull
    private String getTokenKey() {
        return RedisKeyEnum.K002.toString() + DateUtil.today();
    }

    private String HttpGetToken(String redisKey, String redisLockKey) {
        String token;
        URI uri = UriComponentsBuilder.fromHttpUrl(inoherbConstant.getDeveloperApiDomain() + "/api/token")
                .queryParam("appid", inoherbConstant.getDeveloperAppId())
                .queryParam("secret", inoherbConstant.getDeveloperAppSecret())
                .build().toUri();

        HttpGet request = new HttpGet(uri);

        String response = null;
        log.info("相宜本草获取token,开始");
        try (CloseableHttpResponse resp = httpClient.execute(request)) {
            response = EntityUtils.toString(resp.getEntity());
            JSONObject jsonResult = JSON.parseObject(response);
            if (!Objects.equals(0, jsonResult.getInteger("errcode"))) {
                log.error("相宜本草获取token失败, response={}, request={}", response, request);
                throw new ThirdpatyException("相宜本草获取token失败");
            }
            token = jsonResult.getJSONObject("result").getString("token");
            redisTemplate.opsForValue().set(redisKey, token, 1L, TimeUnit.DAYS);
            log.info("相宜本草获取token,成功");
            return token;
        } catch (ThirdpatyException e) {
            throw e;
        } catch (Exception e) {
            log.error("相宜本草获取token失败, response={}, request={}", response, request, e);
            throw new ThirdpatyException("相宜本草获取token失败");
        } finally {
            redisTemplate.delete(redisLockKey);
        }
    }

    public String getOldAccessToken() {
        URI uri = UriComponentsBuilder.fromHttpUrl(inoherbConstant.getDeveloperApiDomain() + "/api/token")
                .queryParam("appid", inoherbConstant.getDeveloperAppId())
                .queryParam("secret", inoherbConstant.getDeveloperAppSecret())
                .build().toUri();

        HttpGet request = new HttpGet(uri);

        String response = null;
        log.info("相宜本草获取token,开始");
        try (CloseableHttpResponse resp = httpClient.execute(request)) {
            response = EntityUtils.toString(resp.getEntity());
            JSONObject jsonResult = JSON.parseObject(response);
            if (!Objects.equals(0, jsonResult.getInteger("errcode"))) {
                log.error("相宜本草获取token失败, response={}, request={}", response, request);
                throw new ThirdpatyException("相宜本草获取token失败");
            }
            String token = jsonResult.getJSONObject("result").getString("token");
            log.info("相宜本草获取token,成功");
            return token;
        } catch (ThirdpatyException e) {
            throw e;
        } catch (Exception e) {
            log.error("相宜本草获取token失败, response={}, request={}", response, request, e);
            throw new ThirdpatyException("相宜本草获取token失败");
        }
    }

    /**
     * 获取开发者第三方token
     */
    public String getToken(String timestamp) {
        return DigestUtils.md5Hex(inoherbConstant.getDeveloperThirdPartySecret() + timestamp).toUpperCase();
    }
}
