package cn.com.duiba.biz.credits;

import cn.com.duiba.api.bo.subcredits.SubCreditsMsgDto;
import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.config.JiuYangConfig;
import cn.com.duiba.credits.sdk.CreditNotifyParams;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.nascent.ecrp.opensdk.core.executeClient.ApiClient;
import com.nascent.ecrp.opensdk.core.executeClient.ApiClientImpl;
import com.nascent.ecrp.opensdk.core.util.SignUtils;
import com.nascent.ecrp.opensdk.domain.basis.AccessTokenDetail;
import com.nascent.ecrp.opensdk.request.basis.AccessTokenRegisterRequest;
import com.nascent.ecrp.opensdk.response.basis.AccessTokenRegisterResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * Created by liukai on 2020/10/20.
 */
@Service
public class JiuYangApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(JiuYangApi.class);

    //运营组编码：具体枚举值待确定
    private static final String OPERATIONGROUPCODE = "JYSY";

    //品牌编码：具体枚举值待确认
    private static final String BRANDCODE = "Joyoung";

    //渠道编码:具体枚举值待确认
    private static final String CHANNELCODE = "JYQDJFSC";

    private static final String SPILT = "_";

    private static final String REIDS_TOKENKEY = "jiuyangToken_key";

    private static final String REIDS_VISUAL_TOKENKEY = "jiuyangToken_virual_key";


    @Autowired
    private JiuYangConfig jiuYangConfig;

    @Resource(name = "httpClient")
    private CloseableHttpClient httpClient;

    @Resource(name = "stringRedisTemplate")
    private StringRedisTemplate stringRedisTemplate;

    public Boolean isJiuYangAppid(Long appId) {
        return jiuYangConfig.isJiuYangAppid(appId);
    }

    /**
     * 九阳定制扣积分
     *
     * @param subCreditsMsgWrapper
     * @return
     */
    public SubCreditsMsgWrapper getSubCreditsMessage(SubCreditsMsgWrapper subCreditsMsgWrapper) {
        try {
            SubCreditsMsgDto subCreditsMsgDto = subCreditsMsgWrapper.getSubCreditsMsg();
            subCreditsMsgDto.setHttpType(SubCreditsMsgDto.HTTP_POST);
            String url = subCreditsMsgWrapper.getHttpUrl();
            String host = url.substring(0, url.indexOf('?'));
            subCreditsMsgWrapper.setHttpUrl(host);
            Map<String, String> originAuthParams = subCreditsMsgDto.getAuthParams();
            Map<String, String> authParams = Maps.newHashMap();
            authParams.put("operationGroupCode", OPERATIONGROUPCODE);
            authParams.put("brandCode", BRANDCODE);
            authParams.put("phone", originAuthParams.get("uid"));
            authParams.put("pointEventCode", "duihuan");
            authParams.put("productDescription", originAuthParams.get("description"));
            authParams.put("point", originAuthParams.get("credits"));
            authParams.put("channelCode", CHANNELCODE);
            authParams.put("bizOrder", originAuthParams.get("orderNum"));
            authParams.put("changeDate", DateUtils.getSecondStr(new Date()));
            authParams.put("isJiuYangRequest", "ok");
            SubCreditsMsgDto msg = subCreditsMsgWrapper.getSubCreditsMsg();
            msg.setAuthParams(authParams);
            return subCreditsMsgWrapper;
        } catch (Exception e) {
            LOGGER.info("AbchinaApi call getSubCreditsMessage error , subCreditsMsgWrapper = {}", JSONObject.toJSONString(subCreditsMsgWrapper), e);
            return subCreditsMsgWrapper;
        }
    }


    public void setJiuYangHttpHead(HttpRequestBase http,String appId) {
        String token = getToken(appId);
        http.setHeader("Authorization", token);
    }


    private static String sendGet(HttpClient httpClient, String url, Charset encoding) {
        HttpGet httpget = new HttpGet(url);
        String resp = "";
        // 执行get请求.
        CloseableHttpResponse response = null;
        try {
            response = (CloseableHttpResponse) httpClient.execute(httpget);
            resp = EntityUtils.toString(response.getEntity(), encoding);
        } catch (IOException e) {
            LOGGER.warn("九阳 获取token发送get请求失败，url={}", url, e);
        } finally {
            if (response != null) {
                try {
                    response.close();
                } catch (IOException e) {
                    LOGGER.warn("九阳  获取token关闭response失败", e);
                }
            }
        }
        return resp;
    }

    public String parseCreditsRsp(String body) {
        JSONObject jsonBody;
        try {
            jsonBody = JSON.parseObject(body);
        } catch (Exception e) {
            LOGGER.error("jiuyangapi JSON.parseObject:body={},error={}", body, e.getMessage());
            return body;
        }
        JSONObject json = JsonTool.getAllJson(jsonBody);
        Map<String, String> duibaDoc = new HashMap<>();
        Boolean wasSuccess = json.getBoolean("success");
        if (wasSuccess != null && wasSuccess) {
            duibaDoc.put("status", "ok");
        } else {
            duibaDoc.put("status", "fail");
        }
        duibaDoc.put("errorMessage", json.getString("message"));
        duibaDoc.put("bizId", String.valueOf(System.currentTimeMillis()));
        //获取用户积分
        duibaDoc.put("credits", json.getString("leftPoint"));
        return JsonTool.objectToJson(duibaDoc);
    }

    public CreditsMessageDto getAddCreditsMessage(CreditsMessageDto request) {
        String url = request.getHttpUrl();
        //post请求,截取出url去除参数的部分,设置为请求url
        String host = url.substring(0, url.indexOf('?'));
        request.setHttpUrl(host);
        /** 取出原始参数*/
        Map<String, String> originalParams = request.getAuthParams();

        Map<String, String> authParams = Maps.newHashMap();
        authParams.put("operationGroupCode", "JYSY");
        authParams.put("brandCode", "Joyoung");
        authParams.put("phone", originalParams.get("uid"));
        authParams.put("pointEventCode", "dbqiandao");
        authParams.put("point", originalParams.get("credits"));
        authParams.put("channelCode", "JYQDJFSC");
        authParams.put("description", originalParams.get("description"));
        authParams.put("bizOrder",  originalParams.get("orderNum"));
        authParams.put("changeDate", DateUtils.getSecondStr(new Date()));
        authParams.put("isJiuYangRequest", "ok");
        request.setAuthParams(authParams);
        request.setHttpType(CreditsMessage.HTTP_POST);
        return request;
    }

    public String getResponseNotify(String body) {
        try {
            JSONObject object = JSON.parseObject(body);
            if (object.getBoolean("success")) {
                return "ok";
            }
        } catch (Exception e) {
            LOGGER.warn(" jiuyangapi  getResponseNotify  body = {}", body, e);
        }
        return body;
    }

    /**
     * 积分撤销请求HttpPost对象生成
     *
     * @param notifyUrl 请求地址
     * @param params 积分参数
     * @param appId appId
     * @return 请求实体
     */
    public HttpRequestBase getRequestNotify(String notifyUrl, CreditNotifyParams params, Long appId) {
        HttpPost request = new HttpPost(notifyUrl);


        Map<String, String> data = Maps.newHashMap();
        data.put("bizOrder", params.getOrderNum());
        //10 = 积分增加 20 = 积分扣减
        data.put("type", "20");
        //update [20201112] 增加手机号码
        Map<String, String> paramsMap = params.toRequestMap("");
        if(paramsMap.containsKey("uid")){
            data.put("phone",paramsMap.get("uid"));
        }
        request.setHeader("Authorization", getToken(String.valueOf(appId)));
        request.setEntity(new StringEntity(JSON.toJSONString(data), ContentType.APPLICATION_JSON));
        request.addHeader("Accept", "application/json");
        request.addHeader("ContentType", "application/json;charset=UTF-8");
        return request;

    }

    public SupplierRequest getVirtualRequest(SupplierRequest request) {
        String url = request.getHttpUrl();
        String host = url.substring(0, url.indexOf('?'));
        String urlParams = url.substring(url.indexOf('?') + 1, url.length());
        // 1.将请求URL的参数转换为MAP
        Map<String, String> crediMap = AssembleTool.getUrlParams(urlParams);
        //区分经验值还是积分
        Map<String, Object> data = Maps.newHashMap();
        data.put("appKey", jiuYangConfig.getVirualAppkey());
        data.put("nonce", System.currentTimeMillis());
        data.put("accessToken", getVirualToken(request.getAppId()));
        String[] customNums =  crediMap.get("params").split("\\|");
        data.put("shopId",(customNums!=null && customNums.length== 2) ? customNums[1] : jiuYangConfig.getVirualShopId());
        data.put("couponCode",customNums[0]);
        data.put("groupId", jiuYangConfig.getVirualGroupId());
        List<VirualRequest.CustomerNickInfoBean> customerNickInfoBeans = Lists.newArrayList();
        VirualRequest.CustomerNickInfoBean customerNickInfoBean = new VirualRequest.CustomerNickInfoBean();
        customerNickInfoBean.setNick(crediMap.get("uid"));
        customerNickInfoBean.setPlatform(0);
        customerNickInfoBean.setSysCustomerId(0L);
        customerNickInfoBean.setOutCouponId("");
        customerNickInfoBeans.add(customerNickInfoBean);
        data.put("customerNickInfo",customerNickInfoBeans);
        data.put("sendChannelType",2);
        data.put("sendChannelId",0);
        data.put("sign",SignUtils.getSign(data, jiuYangConfig.getVirualAppSerect()));
        data.put("isJiuYangRequest", "ok");
        request.setHttpUrl(host);
        request.setAuthDatas(data);
        Map<String, String> authData = Maps.newHashMap();
        authData.put("isJiuYangRequest", "ok");
        authData.put("getAuthDatas","ok");
        request.setAuthParams(authData);
        return request;
    }

    public String getToken(String appId) {
        final String contentEncoding = "UTF-8";
        final String contentType = "application/json";

        String token = stringRedisTemplate.opsForValue().get(REIDS_TOKENKEY+appId);
        if (StringUtils.isBlank(token)) {
            //String respon = sendGet(httpClient, jiuYangConfig.getGetTokenUrl(), Charset.forName("utf-8"));
            HttpPost httpPost = new HttpPost(jiuYangConfig.getGetTokenUrl());

            List<NameValuePair> pairs = new ArrayList<>(2);
            pairs.add(new BasicNameValuePair("appid", jiuYangConfig.getJiuYangAppid()));
            pairs.add(new BasicNameValuePair("secret", jiuYangConfig.getJiuYangSercret()));
            httpPost.setEntity(new UrlEncodedFormEntity(pairs, Charset.forName("UTF-8")));

            CloseableHttpResponse httpResponse = null;
            String respon = "";
            try {
                httpResponse = httpClient.execute(httpPost);
                if(httpResponse != null){
                    respon = EntityUtils.toString(httpResponse.getEntity(), contentEncoding);
                }
            } catch (IOException e) {
                LOGGER.warn("九阳 获取token发送get请求失败，url = {}", jiuYangConfig.getGetTokenUrl(), e);
            }finally {
                if (httpResponse != null) {
                    try {
                        httpResponse.close();
                    } catch (IOException e) {
                        LOGGER.warn("九阳  获取token关闭response失败", e);
                    }
                }
            }

            if (StringUtils.isNotBlank(respon)) {
                JSONObject dataStr = JSON.parseObject(respon);
                if ("success".equals(dataStr.getString("code"))) {
                    TokenResponData data = JSON.parseObject(dataStr.getString("data"), TokenResponData.class);
                    String accessToken = data.getAccessToken();
                    Integer expiresIn = data.getExpiresIn();
                    //提前10s 失效 保证token 可用
                    stringRedisTemplate.opsForValue().set(REIDS_TOKENKEY+appId, accessToken, (expiresIn > 10 ? expiresIn - 10 : expiresIn), TimeUnit.SECONDS);
                    return accessToken;
                } else {
                    LOGGER.warn("setJiuYangHttpHead 请求token 失败  = {}", respon);
                    return null;
                }
            }
            return null;
        } else {
            return token;
        }
    }


    private String getVirualToken(String appId) {
        String token = stringRedisTemplate.opsForValue().get(REIDS_VISUAL_TOKENKEY+appId);
        if (StringUtils.isBlank(token)) {
            AccessTokenRegisterRequest request = new AccessTokenRegisterRequest();
            request.setServerUrl(jiuYangConfig.getGetVirualTokenUrl());
            request.setAppKey(jiuYangConfig.getVirualAppkey());
            request.setGroupId(Long.valueOf(jiuYangConfig.getVirualGroupId()));
            request.setAppSecret(jiuYangConfig.getVirualAppSerect());
            ApiClient apiClient = new ApiClientImpl(request);
            try {
                AccessTokenRegisterResponse response = apiClient.execute(request);
                if(response!=null && response.success){
                    AccessTokenDetail tokenData = response.getResult();
                    Long time = tokenData.getExpiredTime().getTime() - System.currentTimeMillis();
                    if(time.compareTo(0L)<0){
                        LOGGER.warn("getVirualToken tokenData fail ={}",JSON.toJSONString(tokenData));
                        return null;
                    }
                    stringRedisTemplate.opsForValue().set(REIDS_VISUAL_TOKENKEY+appId, tokenData.getAccessToken(), (time/1000 - 10), TimeUnit.SECONDS);
                    return tokenData.getAccessToken();
                }
            } catch (Exception e) {
                LOGGER.warn("getVirualToken fail",e);
                return null;
            }
            return null;
        } else {
            return token;
        }
    }

    public String getVirtualResponse( String body) {
        Map<String, String> map = new HashMap<>();
        if (StringUtils.isBlank(body)) {
            throw new ThirdpatyException("jiuyang,虚拟商品定制，返回结果为空");
        }
        try {
            VirualRespData data = JSON.parseObject(body,VirualRespData.class);
            Boolean isOk =data.isSuccess() && data.getResult()!=null && ObjectUtils.equals(data.getResult().getSuccessCount(),1);
            map.put("status",isOk ? "success" :"fail");
            if(!isOk){
                if(data.getResult()==null){
                    map.put("errorMessage",data.getMsg());
                    map.put("code", data.getCode());
                } else {
                    List<VirualRespData.ResultBean.FailedCustomerInfoBean> failedCustomerInfo = data.getResult().getFailedCustomerInfo();
                    map.put("errorMessage", CollectionUtils.isNotEmpty(failedCustomerInfo) ? failedCustomerInfo.get(0).getFailedMessage() :null);
                    map.put("code", data.getCode());
                }

            }
        } catch (Exception e) {
            LOGGER.error("jiuyang,虚拟商品定制，结果解析错误:{}", body, e);
            map.put("status", "fail");
            map.put("errorMessage", "虚拟商品充值接口响应解析错误");
        }
        return JSON.toJSONString(map);
    }





    public static class TokenResponData {

        @JSONField(name = "access_token")
        private String accessToken;

        private String type;

        @JSONField(name = "expires_in")
        private Integer expiresIn;

        public String getAccessToken() {
            return accessToken;
        }

        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Integer getExpiresIn() {
            return expiresIn;
        }

        public void setExpiresIn(Integer expiresIn) {
            this.expiresIn = expiresIn;
        }
    }


    public static String getMD5(String str) {
        MessageDigest messageDigest = null;

        try {
            messageDigest = MessageDigest.getInstance("MD5");

            messageDigest.reset();

            messageDigest.update(str.getBytes("UTF-8"));
        } catch (NoSuchAlgorithmException e) {
            System.out.println("NoSuchAlgorithmException caught!");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }

        byte[] byteArray = messageDigest.digest();

        StringBuffer md5StrBuff = new StringBuffer();

        for (int i = 0; i < byteArray.length; i++) {
            if (Integer.toHexString(0xFF & byteArray[i]).length() == 1) {
                md5StrBuff.append("0").append(Integer.toHexString(0xFF & byteArray[i]));
            } else {
                md5StrBuff.append(Integer.toHexString(0xFF & byteArray[i]));
            }
        }
        return md5StrBuff.toString();
    }


    public static class VirualRequest{
        /**
         * appKey :
         * nonce : 0
         * sign :
         * accessToken :
         * groupId : 0
         * shopId : 0
         * outShopId :
         * customerNickInfo : [{"nick":"","platform":0,"sysCustomerId":0,"outCouponId":""}]
         * couponCode :
         * sendChannelType : 0
         * extJson :
         * sendChannelId : 0
         * sysTradeId : 0
         * guideId : 0
         */

        private String appKey;
        private Long nonce;
        private String sign;
        private String accessToken;
        private Long groupId;
        private Long shopId;
        private String outShopId;
        private String couponCode;
        private Integer sendChannelType;
        private String extJson;
        private Long sendChannelId;
        private Long sysTradeId;
        private Long guideId;
        private List<CustomerNickInfoBean> customerNickInfo;

        public String getAppKey() {
            return appKey;
        }

        public void setAppKey(String appKey) {
            this.appKey = appKey;
        }

        public Long getNonce() {
            return nonce;
        }

        public void setNonce(Long nonce) {
            this.nonce = nonce;
        }

        public String getSign() {
            return sign;
        }

        public void setSign(String sign) {
            this.sign = sign;
        }

        public String getAccessToken() {
            return accessToken;
        }

        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public Long getGroupId() {
            return groupId;
        }

        public void setGroupId(Long groupId) {
            this.groupId = groupId;
        }

        public Long getShopId() {
            return shopId;
        }

        public void setShopId(Long shopId) {
            this.shopId = shopId;
        }

        public String getOutShopId() {
            return outShopId;
        }

        public void setOutShopId(String outShopId) {
            this.outShopId = outShopId;
        }

        public String getCouponCode() {
            return couponCode;
        }

        public void setCouponCode(String couponCode) {
            this.couponCode = couponCode;
        }

        public Integer getSendChannelType() {
            return sendChannelType;
        }

        public void setSendChannelType(Integer sendChannelType) {
            this.sendChannelType = sendChannelType;
        }

        public String getExtJson() {
            return extJson;
        }

        public void setExtJson(String extJson) {
            this.extJson = extJson;
        }

        public Long getSendChannelId() {
            return sendChannelId;
        }

        public void setSendChannelId(Long sendChannelId) {
            this.sendChannelId = sendChannelId;
        }

        public Long getSysTradeId() {
            return sysTradeId;
        }

        public void setSysTradeId(Long sysTradeId) {
            this.sysTradeId = sysTradeId;
        }

        public Long getGuideId() {
            return guideId;
        }

        public void setGuideId(Long guideId) {
            this.guideId = guideId;
        }

        public List<CustomerNickInfoBean> getCustomerNickInfo() {
            return customerNickInfo;
        }

        public void setCustomerNickInfo(List<CustomerNickInfoBean> customerNickInfo) {
            this.customerNickInfo = customerNickInfo;
        }

        public static class CustomerNickInfoBean {
            /**
             * nick :
             * platform : 0
             * sysCustomerId : 0
             * outCouponId :
             */

            private String nick;
            private Integer platform;
            private Long sysCustomerId;
            private String outCouponId;

            public String getNick() {
                return nick;
            }

            public void setNick(String nick) {
                this.nick = nick;
            }

            public Integer getPlatform() {
                return platform;
            }

            public void setPlatform(Integer platform) {
                this.platform = platform;
            }

            public Long getSysCustomerId() {
                return sysCustomerId;
            }

            public void setSysCustomerId(Long sysCustomerId) {
                this.sysCustomerId = sysCustomerId;
            }

            public String getOutCouponId() {
                return outCouponId;
            }

            public void setOutCouponId(String outCouponId) {
                this.outCouponId = outCouponId;
            }
        }
    }

    public static String getSign(Map<String, Object> params, String secret) {
        JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(params));
        String[] keys = (String[])params.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        StringBuilder query = new StringBuilder(secret);
        String[] var5 = keys;
        int var6 = keys.length;

        for(int var7 = 0; var7 < var6; ++var7) {
            String key = var5[var7];
            String value = jsonObject.getString(key);
            if (value != null && !"".equals(value) && !value.startsWith("[") && !value.startsWith("{")) {
                query.append(key).append(value);
            }
        }

        try {
            return encryptMD5(query.toString());
        } catch (IOException var10) {
            LOGGER.error("MD5加密异常", var10);
            return null;
        }
    }

    private static String encryptMD5(String data) throws IOException {
        Object var1 = null;

        byte[] bytes;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            bytes = md.digest(data.getBytes("utf-8"));
        } catch (GeneralSecurityException var3) {
            throw new IOException(var3.getMessage());
        }

        return byte2hex(bytes);
    }

    private static String byte2hex(byte[] b) {
        StringBuilder hs = new StringBuilder();

        for(int n = 0; b != null && n < b.length; ++n) {
            String stmp = Integer.toHexString(b[n] & 255);
            if (stmp.length() == 1) {
                hs.append('0');
            }

            hs.append(stmp);
        }

        return hs.toString().toUpperCase();
    }

    public static class VirualRespData{


        /**
         * code :
         * msg :
         * success : true
         * result : {"failedCount":0,"failedCustomerInfo":[{"failedMessage":"","nick":"","sysCustomerId":0}],"remaining":0,"successCount":0,"successCustomerInfo":[{"couponId":"","nick":"","sysCustomerId":0}]}
         * requestId :
         */

        private String code;
        private String msg;
        private boolean success;
        private ResultBean result;
        private String requestId;

        public String getCode() {
            return code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getMsg() {
            return msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public boolean isSuccess() {
            return success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public ResultBean getResult() {
            return result;
        }

        public void setResult(ResultBean result) {
            this.result = result;
        }

        public String getRequestId() {
            return requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public static class ResultBean {
            /**
             * failedCount : 0
             * failedCustomerInfo : [{"failedMessage":"","nick":"","sysCustomerId":0}]
             * remaining : 0
             * successCount : 0
             * successCustomerInfo : [{"couponId":"","nick":"","sysCustomerId":0}]
             */

            private int failedCount;
            private int remaining;
            private int successCount;
            private List<FailedCustomerInfoBean> failedCustomerInfo;
            private List<SuccessCustomerInfoBean> successCustomerInfo;

            public int getFailedCount() {
                return failedCount;
            }

            public void setFailedCount(int failedCount) {
                this.failedCount = failedCount;
            }

            public int getRemaining() {
                return remaining;
            }

            public void setRemaining(int remaining) {
                this.remaining = remaining;
            }

            public int getSuccessCount() {
                return successCount;
            }

            public void setSuccessCount(int successCount) {
                this.successCount = successCount;
            }

            public List<FailedCustomerInfoBean> getFailedCustomerInfo() {
                return failedCustomerInfo;
            }

            public void setFailedCustomerInfo(List<FailedCustomerInfoBean> failedCustomerInfo) {
                this.failedCustomerInfo = failedCustomerInfo;
            }

            public List<SuccessCustomerInfoBean> getSuccessCustomerInfo() {
                return successCustomerInfo;
            }

            public void setSuccessCustomerInfo(List<SuccessCustomerInfoBean> successCustomerInfo) {
                this.successCustomerInfo = successCustomerInfo;
            }

            public static class FailedCustomerInfoBean {
                /**
                 * failedMessage :
                 * nick :
                 * sysCustomerId : 0
                 */

                private String failedMessage;
                private String nick;
                private int sysCustomerId;

                public String getFailedMessage() {
                    return failedMessage;
                }

                public void setFailedMessage(String failedMessage) {
                    this.failedMessage = failedMessage;
                }

                public String getNick() {
                    return nick;
                }

                public void setNick(String nick) {
                    this.nick = nick;
                }

                public int getSysCustomerId() {
                    return sysCustomerId;
                }

                public void setSysCustomerId(int sysCustomerId) {
                    this.sysCustomerId = sysCustomerId;
                }
            }

            public static class SuccessCustomerInfoBean {
                /**
                 * couponId :
                 * nick :
                 * sysCustomerId : 0
                 */

                private String couponId;
                private String nick;
                private int sysCustomerId;

                public String getCouponId() {
                    return couponId;
                }

                public void setCouponId(String couponId) {
                    this.couponId = couponId;
                }

                public String getNick() {
                    return nick;
                }

                public void setNick(String nick) {
                    this.nick = nick;
                }

                public int getSysCustomerId() {
                    return sysCustomerId;
                }

                public void setSysCustomerId(int sysCustomerId) {
                    this.sysCustomerId = sysCustomerId;
                }
            }
        }
    }




}
