package cn.com.duiba.biz.credits;

import cn.com.duiba.constant.MingYuJiuDianConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.wolf.utils.UUIDUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.*;

/**
 * @date: $ $
 * @auther: linzhou$
 * @description: TODO  $
 */
@Service
public class MingYuJiuDianApi {
    private static final Logger logger = LoggerFactory.getLogger(MingYuJiuDianApi.class);

    private static final String PROMOTIONTAG = "DUIBA";
    private static final String REMARK = "兑吧积分记录DUIBA_POINT";

    @Autowired
    private MingYuJiuDianConfig mingYuJiuDianConfig;
    @Resource(name = "httpClient")
    private CloseableHttpClient httpClient;

    public boolean isAppId(Long appId) {
        return mingYuJiuDianConfig.getAppIds().contains(appId);
    }


    public HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message) {

        Map<String, String> newParams = new HashMap<>(8);

        String sessionId = mingYuJiuDianConfig.getSessionId(httpClient);
        Long credits = message.getSubCreditsMsg().getCreditConsumeParams().getCredits();
        String memberId = message.getSubCreditsMsg().getAuthParams().get("uid");
        String crsNo = message.getSubCreditsMsg().getRelationId();

        newParams.put("sessionId", sessionId);
        newParams.put("point", credits.toString());
        newParams.put("memberId", memberId);
        newParams.put("promotionTag", PROMOTIONTAG);
        newParams.put("crsNo", crsNo);
        newParams.put("remark", REMARK);

        HttpPost httpPost = new HttpPost(mingYuJiuDianConfig.getSubCreditsUrl());

        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
        httpPost.setHeader("User-Agent", "Apache-HttpClient/4.1.1(java 1.5)");
        httpPost.setHeader("Connection", "Keep-Alive");

        List<NameValuePair> pairList = new ArrayList<>();
        //集团编号，固定是2
        NameValuePair sessionIdPair = new BasicNameValuePair("sessionId", sessionId);
        NameValuePair pointPair = new BasicNameValuePair("point", credits.toString());
        NameValuePair cardIdPair = new BasicNameValuePair("memberId", memberId);
        NameValuePair promotionTagPair = new BasicNameValuePair("promotionTag", PROMOTIONTAG);
        NameValuePair remarkPair = new BasicNameValuePair("remark", REMARK);
        NameValuePair crsNoPair = new BasicNameValuePair("crsNo", crsNo);
        NameValuePair signPair = new BasicNameValuePair("sign", mingYuJiuDianConfig.getSign(newParams));
        NameValuePair hotelGroupIdPair = new BasicNameValuePair("hotelGroupId", mingYuJiuDianConfig.getHotelGroupId());
        NameValuePair appKeyPair = new BasicNameValuePair("appKey", mingYuJiuDianConfig.getLvYunAppKey());

        pairList.add(sessionIdPair);
        pairList.add(pointPair);
        pairList.add(cardIdPair);
        pairList.add(promotionTagPair);
        pairList.add(remarkPair);
        pairList.add(crsNoPair);
        pairList.add(signPair);
        pairList.add(hotelGroupIdPair);
        pairList.add(appKeyPair);

        httpPost.setEntity(new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));
        return httpPost;
    }

    public String getResponseCredits(String body, Long appId, Boolean addCredits, Map<String, String> authParams) {

        JSONObject jsonObject = JSONObject.parseObject(body);

        if (jsonObject == null || jsonObject.getInteger("resultCode") != 0) {
            logger.warn("MingYuJiuDian sub credits error,body:{}", body);
            return body;
        }

        Map<String, String> param = new HashMap<>();

        if (addCredits) {
            Long pointPayId = jsonObject.getLong("pointPayId");
            if (pointPayId == null) {
                logger.warn("MingYuJiuDian add credits error,pointPayId is null,body:{}", body);
                return body;
            }
            param.put("bizId", pointPayId.toString());
        } else {

            JSONArray resultJSONArray = jsonObject.getJSONArray("result");
            if (resultJSONArray == null || resultJSONArray.size() == 0) {
                logger.warn("MingYuJiuDian sub credits error,pointApplyId is null,body:{}", body);
                return body;
            }
            JSONObject result = resultJSONArray.getJSONObject(0);
            if (result == null) {
                logger.warn("MingYuJiuDian sub credits error,pointApplyId is null,body:{}", body);
                return body;
            }
            Integer pointId = result.getInteger("pointId");
            if (pointId == null) {
                logger.warn("MingYuJiuDian sub credits error,pointApplyId is null,body:{}", body);
                return body;
            }
            param.put("bizId", String.valueOf(pointId));
        }

        param.put("status", "ok");
        try {
            String uid = authParams.get("uid");
            String credits = mingYuJiuDianConfig.getCredits(uid, httpClient);
            if (!"0".equals(credits)) {
                param.put("credits", String.valueOf(new BigDecimal(credits).longValue()));
            }

        } catch (Exception e) {
            logger.warn("get Credits error");
        }


        return JSONObject.toJSONString(param);


    }

    public HttpRequestBase getAddCreditsHttpRequest(CreditsMessageDto message) {
        Map<String, String> newParams = new HashMap<>();

        String httpUrl = message.getHttpUrl();
        String paramsStr = httpUrl.substring(httpUrl.indexOf('?') + 1);
        Map<String, String> authParams = cn.com.duiba.tool.AssembleTool.getUrlParams(paramsStr);

        String sessionId = mingYuJiuDianConfig.getSessionId(httpClient);
        String credits = authParams.get("credits");
        String cardId = message.getParams().get("cardId");

        newParams.put("sessionId", sessionId);
        newParams.put("point", credits);
        newParams.put("cardId", cardId);
        newParams.put("promotionTag", PROMOTIONTAG);
        newParams.put("remark", REMARK);

        HttpPost httpPost = new HttpPost(mingYuJiuDianConfig.getAddCreditsUrl());

        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
        httpPost.setHeader("User-Agent", "Apache-HttpClient/4.1.1(java 1.5)");
        httpPost.setHeader("Connection", "Keep-Alive");

        List<NameValuePair> pairList = new ArrayList<>();
        //集团编号，固定是2
        NameValuePair sessionIdPair = new BasicNameValuePair("sessionId", sessionId);
        NameValuePair pointPair = new BasicNameValuePair("point", credits);
        NameValuePair cardIdPair = new BasicNameValuePair("cardId", cardId);
        NameValuePair promotionTagPair = new BasicNameValuePair("promotionTag", PROMOTIONTAG);
        NameValuePair signPair = new BasicNameValuePair("sign", mingYuJiuDianConfig.getSign(newParams));
        NameValuePair hotelGroupIdPair = new BasicNameValuePair("hotelGroupId", mingYuJiuDianConfig.getHotelGroupId());
        NameValuePair appKeyPair = new BasicNameValuePair("appKey", mingYuJiuDianConfig.getLvYunAppKey());
        NameValuePair remarkPair = new BasicNameValuePair("remark", REMARK);

        pairList.add(sessionIdPair);
        pairList.add(pointPair);
        pairList.add(cardIdPair);
        pairList.add(promotionTagPair);
        pairList.add(signPair);
        pairList.add(hotelGroupIdPair);
        pairList.add(appKeyPair);
        pairList.add(remarkPair);

        httpPost.setEntity(new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));

        return httpPost;
    }

    /**
     * 虚拟商品发货
     *
     * @param message
     * @return
     */
    public HttpRequestBase getVirtualRequest(SupplierRequest message) {
        String url = message.getHttpUrl();
        String authParams = url.substring(url.indexOf('?') + 1);
        Map<String, String> authParamMap = AssembleTool.getUrlParams(authParams);
        String goodsNum = authParamMap.get("params");

        if (StringUtils.isNotBlank(goodsNum)) {
            //如果是礼包商品
            if (goodsNum.startsWith(mingYuJiuDianConfig.getCoupons1())) {
                return getCoupons1VirtualRequest(message, authParamMap);
            }
            //如果是电子券商品
            if (goodsNum.startsWith(mingYuJiuDianConfig.getCoupons2())) {
                return getCoupons2VirtualRequest(message, authParamMap);
            }
        }
        return new HttpGet(url);
    }

    /**
     * 礼包商品
     *
     * @param message
     * @param authParamMap
     * @return
     */
    private HttpRequestBase getCoupons1VirtualRequest(SupplierRequest message, Map<String, String> authParamMap) {
        String goodsNum = authParamMap.get("params").replace(mingYuJiuDianConfig.getCoupons1(), "");

        String sessionId = mingYuJiuDianConfig.getSessionId(httpClient);
        String cardId = message.getParams().get("cardId");
        String cardNo = message.getParams().get("cardNo");

        Map<String, String> newParams = new HashMap<>();
        newParams.put("sessionId", sessionId);
        newParams.put("cardId", cardId);
        newParams.put("couponPackCode", goodsNum);
        newParams.put("remark", REMARK);
        newParams.put("cardNo", cardNo);


        HttpPost httpPost = new HttpPost(mingYuJiuDianConfig.getCoupons1Url());

        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
        httpPost.setHeader("User-Agent", "Apache-HttpClient/4.1.1(java 1.5)");
        httpPost.setHeader("Connection", "Keep-Alive");

        List<NameValuePair> pairList = new ArrayList<>();
        //集团编号，固定是2
        NameValuePair sessionIdPair = new BasicNameValuePair("sessionId", sessionId);
        NameValuePair cardIdPair = new BasicNameValuePair("cardId", cardId);
        NameValuePair couponPackCodePair = new BasicNameValuePair("couponPackCode", goodsNum);
        NameValuePair signPair = new BasicNameValuePair("sign", mingYuJiuDianConfig.getSign(newParams));
        NameValuePair hotelGroupIdPair = new BasicNameValuePair("hotelGroupId", mingYuJiuDianConfig.getHotelGroupId());
        NameValuePair appKeyPair = new BasicNameValuePair("appKey", mingYuJiuDianConfig.getLvYunAppKey());
        NameValuePair remarkPair = new BasicNameValuePair("remark", REMARK);
        NameValuePair cardNoPair = new BasicNameValuePair("cardNo", cardNo);

        pairList.add(sessionIdPair);
        pairList.add(cardIdPair);
        pairList.add(couponPackCodePair);
        pairList.add(signPair);
        pairList.add(hotelGroupIdPair);
        pairList.add(appKeyPair);
        pairList.add(remarkPair);
        pairList.add(cardNoPair);


        httpPost.setEntity(new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));

        return httpPost;
    }

    /**
     * 电子券商品
     *
     * @param message
     * @param authParamMap
     * @return
     */
    private HttpRequestBase getCoupons2VirtualRequest(SupplierRequest message, Map<String, String> authParamMap) {
        Map<String, String> newParams = new HashMap<>();
        String goodsNum = authParamMap.get("params").replace(mingYuJiuDianConfig.getCoupons2(), "");

        String sessionId = mingYuJiuDianConfig.getSessionId(httpClient);
        String memberId = authParamMap.get("uid");

        newParams.put("sessionId", sessionId);
        newParams.put("couponCode", goodsNum);
        newParams.put("remark", REMARK);
        newParams.put("number", "1");
        newParams.put("memberId", memberId);

        HttpPost httpPost = new HttpPost(mingYuJiuDianConfig.getCoupons2Url());

        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
        httpPost.setHeader("User-Agent", "Apache-HttpClient/4.1.1(java 1.5)");
        httpPost.setHeader("Connection", "Keep-Alive");

        List<NameValuePair> pairList = new ArrayList<>();
        //集团编号，固定是2
        NameValuePair sessionIdPair = new BasicNameValuePair("sessionId", sessionId);
        NameValuePair couponPackCodePair = new BasicNameValuePair("couponCode", goodsNum);
        NameValuePair signPair = new BasicNameValuePair("sign", mingYuJiuDianConfig.getSign(newParams));
        NameValuePair hotelGroupIdPair = new BasicNameValuePair("hotelGroupId", mingYuJiuDianConfig.getHotelGroupId());
        NameValuePair appKeyPair = new BasicNameValuePair("appKey", mingYuJiuDianConfig.getLvYunAppKey());
        NameValuePair remarkPair = new BasicNameValuePair("remark", REMARK);
        NameValuePair numberPair = new BasicNameValuePair("number", "1");
        NameValuePair memberIdPair = new BasicNameValuePair("memberId", memberId);

        pairList.add(sessionIdPair);
        pairList.add(couponPackCodePair);
        pairList.add(signPair);
        pairList.add(hotelGroupIdPair);
        pairList.add(appKeyPair);
        pairList.add(remarkPair);
        pairList.add(numberPair);
        pairList.add(memberIdPair);


        httpPost.setEntity(new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));

        return httpPost;
    }

    public String getVirtualResponse(SupplierRequest message, String body) {

        JSONObject jsonObject = JSONObject.parseObject(body);
        Integer resultCode = jsonObject.getInteger("resultCode");
        Map<String, String> param = new HashMap<>();

        if (resultCode != null && 0 == resultCode) {
            String url = message.getHttpUrl();
            String authParams = url.substring(url.indexOf('?') + 1);
            Map<String, String> authParamMap = AssembleTool.getUrlParams(authParams);
            String uid = authParamMap.get("uid");
            String credits = mingYuJiuDianConfig.getCredits(uid, httpClient);
            if (!"0".equals(credits)) {
                param.put("credits", String.valueOf(new BigDecimal(credits).longValue()));
            }
            param.put("status", "success");
        } else {
            param.put("status", "fail");
            param.put("errorMessage", jsonObject.getString("resultMsg"));
        }
        param.put("supplierBizId", UUIDUtils.createUUID());
        return JSON.toJSONString(param);
    }


}
