package cn.com.duiba.biz.credits;

import cn.com.duiba.constant.ShanXiSecuritiesConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.MD5;
import cn.com.duiba.wolf.utils.UUIDUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author 林周
 * @version 1.0.0
 * @ClassName ShanXiSecuritiesApi.java
 * @Description 山西证券定制
 */
@Service
public class ShanXiSecuritiesApi {

    private static final Logger logger = LoggerFactory.getLogger(ShanXiSecuritiesApi.class);

    public static final String ADD_FLAG = "1";
    public static final String SUB_FLAG = "3";
    public static final String RESULT_CODE = "resultCode";
    public static final String INSERT_RESULT = "insertResult";
    public static final String POINT = "point";
    public static final String DATA = "data";
    public static final int SUCCESS = 1000;
    public static final String UID = "uid";

    @Autowired
    private ShanXiSecuritiesConfig shanXiSecuritiesConfig;
    @Resource(name = "httpClient")
    private CloseableHttpClient httpClient;


    public boolean isAppId(Long appId) {
        return shanXiSecuritiesConfig.getAppIds().contains(appId);
    }

    public HttpRequestBase getSubCreditsHttpRequest(SubCreditsMsgWrapper message) {
        Long credits = message.getSubCreditsMsg().getCreditConsumeParams().getCredits();
        String uid = message.getSubCreditsMsg().getAuthParams().get(UID);
        String remark = message.getSubCreditsMsg().getAuthParams().get("description");
        String url = message.getHttpUrl();
        String newUrl = url.substring(0, url.indexOf('?'));
        return getCreditsHttpRequest(SUB_FLAG, String.valueOf(credits), uid,newUrl,remark);
    }

    public HttpRequestBase getAddCreditsHttpRequest(CreditsMessageDto message) {

        String httpUrl = message.getHttpUrl();
        String paramsStr = httpUrl.substring(httpUrl.indexOf('?') + 1);
        Map<String, String> authParams = cn.com.duiba.tool.AssembleTool.getUrlParams(paramsStr);

        String credits = authParams.get("credits");
        String uid = authParams.get(UID);
        String remark = authParams.get("description");
        String newUrl = httpUrl.substring(0, httpUrl.indexOf('?'));
        return getCreditsHttpRequest(ADD_FLAG, credits, uid,newUrl, remark);
    }

    public String getResponseCredits(String body, Map<String, String> authParams) {
        logger.info("getResponseCredits body:{}", body);
        JSONObject jsonObject = JSON.parseObject(body);
        if (jsonObject == null || jsonObject.getInteger(RESULT_CODE) != SUCCESS) {
            logger.warn("MingYuJiuDian sub credits error,body:{}", body);
            return body;
        }

        JSONObject data = jsonObject.getJSONObject("data");
        if (data == null || data.getInteger(INSERT_RESULT) != 1) {
            logger.warn("MingYuJiuDian sub credits error,body:{}", body);
            return body;
        }

        Map<String, String> param = Maps.newHashMap();
        param.put("status", "ok");
        param.put("bizId", UUIDUtils.createUUID());
        String uid = authParams.get(UID);
        String credits = getCredits(uid);
        if (StringUtils.isNotBlank(credits)) {
            param.put("credits", credits);
        }

        String result = JSON.toJSONString(param);
        logger.info("getResponseCredits result:{}",result);
        return result;
    }

    public String getCredits(String uid) {
        Map<String, String> newParams = Maps.newHashMap();
        newParams.put("phoneNo", uid);
        newParams.put("detailId", String.valueOf(System.currentTimeMillis()));
        newParams.put("appCode", shanXiSecuritiesConfig.getAppCode());
        String sign = getSign(newParams);
        newParams.put("sign", sign);


        String url = AssembleTool.assembleUrl(shanXiSecuritiesConfig.getGetCustomerPointUrl(), newParams);
        logger.info("getCredits url:{}", url);
        HttpPost httpPost = new HttpPost(url);

        //执行http请求
        try (CloseableHttpResponse httpResponse = httpClient.execute(httpPost)) {
            String responseEntity = EntityUtils.toString(httpResponse.getEntity());
            logger.info("getCredits uid:{},responseEntity:{}", uid, responseEntity);
            JSONObject jsonObject = JSON.parseObject(responseEntity);
            if (!Objects.equals(SUCCESS, jsonObject.getInteger(RESULT_CODE))) {
                return null;
            }
            JSONObject data = jsonObject.getJSONObject(DATA);
            if (data == null || !data.containsKey(POINT)) {
                return null;
            }

            return String.valueOf(data.getInteger(POINT));
        } catch (Exception e) {
            logger.error("getCredits error:", e);
        }

        return null;
    }


    private HttpGet getCreditsHttpRequest(String isAddFlag, String credits, String uid, String newUrl, String remark) {
        Map<String, String> newParams = Maps.newHashMap();
        newParams.put("phoneNo", uid);
        newParams.put(POINT, String.valueOf(credits));
        newParams.put("isAddFlag", isAddFlag);
        newParams.put("accessChannel", "4");
        newParams.put("type", "3");
        newParams.put("detailId", String.valueOf(System.currentTimeMillis()));
        if (StringUtils.isNotBlank(remark) && remark.length() > shanXiSecuritiesConfig.getLength()) {
            //如果备注字段不为空，并且长度大于8 后面用...
            remark = remark.substring(0, shanXiSecuritiesConfig.getLength()) + "...";
        }
        newParams.put("remark", remark);

        newParams.put("appCode", shanXiSecuritiesConfig.getAppCode());
        String sign = getSign(newParams);

        newParams.put("sign", sign);


        String url = AssembleTool.assembleUrl(newUrl, newParams);
        logger.info("getCreditsHttpRequest url:{}", url);
        return new HttpGet(url);
    }

    private String getSign(Map<String, String> params) {
        List<String> sortKey = new ArrayList<>(params.keySet());
        sortKey.sort(String::compareTo);
        StringBuilder sb = new StringBuilder();
        for (String key : sortKey) {
            sb.append(key).append("=").append(params.get(key)).append("&");
        }
        sb.append("apiSecret=").append(shanXiSecuritiesConfig.getApiSecret());

        String str = sb.toString();
        logger.info("getSign old str:{}", str);
        try {
            return MD5.md5(str);
        } catch (Exception e) {
            e.printStackTrace();
            logger.warn("签名计算失败，原串：{}", str);
        }
        return null;
    }

}
