package cn.com.duiba.biz.credits;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.constant.SiChuanLianTongConfig;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.tool.AssembleTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * 四川联通定制api
 *
 * @Author chenxiangge
 * @Date 2020/12/15
 */
@Service
public class SiChuanLianTongApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(SiChuanLianTongApi.class);


    private static final String CHARACTER_ENCODE = "UTF-8";

    private static final String SUCCESS_CODE = "0000";

    @Autowired
    private SiChuanLianTongConfig siChuanLianTongConfig;

    public Boolean isSiChuanLianTongApp(Long appId) {
        return siChuanLianTongConfig.isSiChuanLianTongApp(appId);
    }

    /**
     * 虚拟商品请求
     *
     * @param request
     * @return
     */
    public HttpRequestBase getVirtualRequest(SupplierRequest request) {
        String url = request.getHttpUrl();
        String newUrl = url.substring(0, url.indexOf('?'));
        String queryString = url.substring(newUrl.length() + 1);
        // 1.将请求URL的参数转换为MAP
        Map<String, String> params = AssembleTool.getUrlParams(queryString);

        String appId = siChuanLianTongConfig.getClientId();
        String appSecret = siChuanLianTongConfig.getClientSecret();

        Long timestamp = System.currentTimeMillis();
        String sign = DigestUtils.md5Hex("appId=" + appId + ",timestamp=" + timestamp + "," + siChuanLianTongConfig.getSignUrl() + "," + appSecret);

        //签名并获取token
        // {appId:{appId, timestamp:{timestamp}, sign:{1步骤的签名串}}}
        JSONObject json = new JSONObject();
        json.put("appId", appId);
        json.put("timestamp", timestamp);
        json.put("sign", sign);
        String token = "";
        try {
            token = Hex.encodeHexString(JSON.toJSONString(json).getBytes(CHARACTER_ENCODE));
        } catch (Exception e) {
            LOGGER.warn("四川联通 虚拟商品定制，生成token异常", e);
        }

        //拼接请求url
        newUrl = newUrl + "?accessTokenKind=2&accessToken=" + token;


        LOGGER.info("10010 url:{}", newUrl);

        Map<String, String> requestParams = new HashMap<>();
        requestParams.put("acceptWay", siChuanLianTongConfig.getAcceptWay());
        requestParams.put("phoneNumber", params.get("uid"));
        requestParams.put("rightsId", params.get("params"));

        String requestJson = JSON.toJSONString(requestParams);

        HttpPost httpPost = new HttpPost(newUrl);
        httpPost.setEntity(new StringEntity(requestJson, ContentType.APPLICATION_JSON));

        LOGGER.info("10010 body:{}", requestJson);

        request.setHttpUrl(url);
        request.setAuthParams(requestParams);

        return httpPost;
    }


    /**
     * 开发者虚拟商品返回解析
     *
     * @param body
     * @return
     */
    public String getVirtualResponse(String body) {
        LOGGER.info("四川联通,虚拟商品定制 返回结果:{}",body);
        Map<String, String> map = new HashMap<>();
        if (StringUtils.isBlank(body)) {
            throw new ThirdpatyException("四川联通,虚拟商品定制，返回结果为空");
        }
        try {
            SiChuanLianTongResponse data = JSON.parseObject(body, SiChuanLianTongResponse.class);
            Boolean isOk = SUCCESS_CODE.equals(data.getBusiCode()) && SUCCESS_CODE.equals(data.getCode());
            map.put("status", isOk ? "success" : "fail");
            if (!isOk) {
                LOGGER.info("四川联通,虚拟商品定制 错误返回:{}",body);
                map.put("errorMessage", data.getBusiDetail());
                map.put("code", data.getBusiCode());
            }
        } catch (Exception e) {
            LOGGER.error("四川联通,虚拟商品定制，结果解析错误:{}", body, e);
            map.put("status", "fail");
            map.put("errorMessage", "虚拟商品充值接口响应解析错误");
        }
        return JSON.toJSONString(map);
    }

    static class SiChuanLianTongResponse {
        private String code;
        private String detail;
        private String busiCode;
        private String busiDetail;

        public String getCode() {
            return code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getDetail() {
            return detail;
        }

        public void setDetail(String detail) {
            this.detail = detail;
        }

        public String getBusiCode() {
            return busiCode;
        }

        public void setBusiCode(String busiCode) {
            this.busiCode = busiCode;
        }

        public String getBusiDetail() {
            return busiDetail;
        }

        public void setBusiDetail(String busiDetail) {
            this.busiDetail = busiDetail;
        }
    }

}
