package cn.com.duiba.biz.credits.strategy;

import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.thirdparty.dto.HttpRequestMessageDto;
import org.apache.http.client.methods.HttpRequestBase;

import java.util.Map;

/**
 * @Date 2020/12/28
 * @Created by cmm
 * 目前getAppIds和扣积分、加积分、获取兑换结果通知http包装类、解析扣积分响应是必须要实现的方法，如果发现自己定制的方法用不到某个方法请实现该方法后return null
 * 可参考DemoApiStrategy,DemoConfig
 * {@link cn.com.duiba.biz.credits.strategy.Impl.DemoApiStrategy}
 * {@link cn.com.duiba.constant.DemoConfig}
 */
//todo 有的方法和入参尚未完善
public interface ApiStrategy {

    /**
     * @param message :
     * @Description:获取扣积分http包装类
     */
    HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message);
    /**
     * @param body       :
     * @param authParams
     * @Description:解析扣积分响应返回兑吧侧通用响应
     */
    String parseCreditsRsp(String body,Boolean addCredits, Map<String, String> authParams);
    /**
     * @param message :
     * @Description:获取加积分http包装类
     */
    HttpRequestBase getAddCreditsMessageRequest(CreditsMessageDto message);
    /**
     * 获取兑换结果通知http包装类
     */
    HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record);

    default String getResponseNotify(String body) {
        return null;
    }
    /**
     * 是否是定制同步兑换记录
     * @param dto
     * @return
     */
    default boolean isCustomCrecord(HttpRequestMessageDto dto) {
        return false;
    }
    /**
     * @param msg :
     * @param app :
     * @Description:获取兑换记录同步http包装类
     */
    default HttpRequestBase getCrecordNotify(HttpRequestMessageDto msg, AppDO app) {
        return null;
    }

    default String getCrecordResponse(String body) {
        return null;
    }
    /**
     * 虚拟商品请求
     */
    default HttpRequestBase getVirtualRequest(SupplierRequest request) {
        return null;
    }
    /**
     * 解析虚拟商品充值响应结果
     */
    default String getVirtualResponse(SupplierRequest request, String body) {
        return null;
    }


}
