package cn.com.duiba.biz.credits.strategy;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * 策略路由类
 * @Date 2020/12/28
 * @Created by cmm
 */
public class ApiStrategyRouter{

    private static final Logger log = LoggerFactory.getLogger(ApiStrategyRouter.class);

    private static Map<Long, ApiStrategy> apiStrategyMap = new HashMap();


   public static void register(ApiStrategy apiStrategy,Set<Long> appIds) {
       log.info("策略路由类注册 apiStrategy:{},appIds:{}",apiStrategy,appIds);
       //将策略实现类加到map里
       for (Long appId : appIds) {
           apiStrategyMap.put(appId, apiStrategy);
       }
       log.info("apiStrategyMap:{}", apiStrategyMap);
    }
    /**
     * 策略路由方法 通过appId找对对应的策略实现方法
     * @param appId
     * @return
     */
    public static ApiStrategy route(Long appId) {
        ApiStrategy apiStrategy = apiStrategyMap.get(appId);
        return apiStrategy;
    }
}
