package cn.com.duiba.constant;

import com.google.common.collect.Sets;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Set;

/**
 * @Author chenxiangge
 * @Date 2020/12/15
 */
@Configuration
@ConfigurationProperties(prefix = "hongqi")
public class HongQiConfig {
    private Set<Long> appIds = Sets.newHashSet(80316L);;

    private String clientId = "AC-duiba";
    private String tacticsCode = "PR-DUIBA-LIMIT";

    /**
     * 获取token的参数
     */
    private String authSecret = "LmvDrlW2O5ufOCJkG6a18QZgd8Gq5QNQ";
    private String authClientId = "faw-open-c6199028-9d12-4872-bcec-0b897ee8f912";
    /**
     * 获取token的url
     */
    private String authServerUrl = "https://auth.faw.cn/auth/realms/";

    private String realms = "openapi";

    public String getTacticsCode() {
        return tacticsCode;
    }

    public void setTacticsCode(String tacticsCode) {
        this.tacticsCode = tacticsCode;
    }

    public String getRealms() {
        return realms;
    }

    public void setRealms(String realms) {
        this.realms = realms;
    }

    public Set<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(Set<Long> appIds) {
        this.appIds = appIds;
    }

    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getAuthSecret() {
        return authSecret;
    }

    public void setAuthSecret(String authSecret) {
        this.authSecret = authSecret;
    }

    public String getAuthClientId() {
        return authClientId;
    }

    public void setAuthClientId(String authClientId) {
        this.authClientId = authClientId;
    }

    public String getAuthServerUrl() {
        return authServerUrl;
    }

    public void setAuthServerUrl(String authServerUrl) {
        this.authServerUrl = authServerUrl;
    }

    public Boolean isHongQiAppId(Long appId) {
        return appIds != null && appIds.contains(appId);
    }
}
