package cn.com.duiba.constant;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.*;

/**
 * @date: $ $
 * @auther: linzhou$
 * @description: TODO  $
 */
public class LvYunSin {

    public String getSign(Map<String,Object> signParams ,String appSecret)
    {
        //2.1    获取signParams中的key值
        StringBuilder    sb    =    new    StringBuilder();
        List<String> keyList    =    new ArrayList(signParams.size());
        for    (Map.Entry    entry    :    signParams.entrySet())    {
            keyList.add((String) entry.getKey());
        }
        //2.2将key值进行排序
        Collections.sort(keyList);

        //2.3 按照该方式拼接成字符串 appSecret+key+map.get(key)+appSecret
        sb.append(appSecret);
        for (String key : keyList) {
            sb.append(key).append(signParams.get(key));
        }
        sb.append(appSecret);

        System.out.println(sb.toString());
        //2.4 SHA1 加密后 将二进制输出为字符串
        try
        {
            byte[] sha1Digest = getSHA1Digest(sb.toString());
            return byte2hex(sha1Digest);

        } catch (IOException e) {
            throw new RuntimeException("签名失败", e);
        }



    }

    private static byte[] getSHA1Digest(String data) throws IOException {
        byte[] bytes = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            bytes = md.digest(data.getBytes("UTF-8"));
        } catch (GeneralSecurityException gse) {
            throw new IOException(gse.getMessage());
        }
        return bytes;
    }
    private static String byte2hex(byte[] bytes)
    {
        StringBuilder sign = new StringBuilder();
        for (int i = 0; i < bytes.length; i++) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                sign.append("0");
            }
            sign.append(hex.toUpperCase());
        }
        return sign.toString();
    }


    public static void main(String[] args) {

        Map<String,Object> signParams= new HashMap<String, Object>();
        String appSecret = "224f50ddde4550b08f03a4ee0b60bb8d";


        /*
         * sessionId
         */

        signParams.put("hotelGroupCode","MYSLG-TR");
        signParams.put("v","3.0");
        signParams.put("usercode","yjyMYSLGTR");
        signParams.put("method","user.login");
        signParams.put("local","zh_CN");
        signParams.put("format","json");
        signParams.put("appKey","12846");
        signParams.put("password","yjyMYSLGTR");






        LvYunSin t = new  LvYunSin();
        System.out.println(t.getSign(signParams, appSecret));


    }

}
