package cn.com.duiba.constant;

import cn.com.duiba.dto.AppSimpleDto;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.*;

/**
 * @date: $ $
 * @auther: linzhou$
 * @description: TODO  $
 */
@Configuration
@ConfigurationProperties("mingyujiudian.lvyun")
public class MingYuJiuDianConfig {
    private static final Logger logger = LoggerFactory.getLogger(MingYuJiuDianConfig.class);



    private Set<Long> appIds = Sets.newHashSet(78412L);

    private String userName = "yjyMYSLGTR";

    private String password = "yjyMYSLGTR";

    private String lvYunAppKey = "12846";

    private String lvYunAppSecret = "224f50ddde4550b08f03a4ee0b60bb8d";
    /**
     * 绿云的短信验证码校验请求地址
     */
    private String sessionIdUrl = "http://118.25.218.97:8102/ipmsgroup/router";
    /**
     * 绿云的短信验证码校验请求地址http://localhost:8102/ipmsmember/membercard/pointApplyByInterface?hotelGroupId=2&cardId=1580003&point=66&promotionTag=a01&remark=1212
     */
    private String subCreditsUrl = "http://118.25.218.97:8101/ipmsmember/membercard/pointApplyByInterfaceMemberId";
    /**
     * 绿云的短信验证码校验请求地址http://localhost:8102/ipmsmember/membercard/pointPayByInterface?hotelGroupId=1&cardId=1&promotionTag=666&point=66&remark=1234567
     */
    private String addCreditsUrl = "http://118.25.218.97:8101/ipmsmember/membercard/pointPayByInterface";
    /**
     * 绿云获取用户信息接口
     */
    private String getCreditsUrl = "http://118.25.218.97:8101/ipmsmember/membercard/getCardPointTotalByMemberId";
    /**
     * 礼包接口地址
     */
    private String coupons1Url = "http://118.25.218.97:8102/ipmsgroup/coupon/onlineSaleCouponPack";
    /**
     * 电子券接口地址
     */
    private String coupons2Url = "http://118.25.218.97:8102/ipmsgroup/coupon/onlineSalesCoupon";
    /**
     * 集团编号，固定是2
     */
    private String hotelGroupId = "2";
    private String hotelGroupCode = "MYSLG-TR";


    /**
     * 礼包商品前缀
     */
    private String coupons1= "coupons1_";
    /**
     * 电子券商品前缀
     */
    private String coupons2= "coupons2_";


    private String sessionId;

    private Long sessionIdTime;

    public String getSign(){
        Map<String,Object> signParams= new HashMap<>(16);
        String appSecret = lvYunAppSecret;

        signParams.put("hotelGroupCode",hotelGroupCode);
        signParams.put("v","3.0");
        signParams.put("usercode",userName);
        signParams.put("method","user.login");
        signParams.put("local","zh_CN");
        signParams.put("format","json");
        signParams.put("appKey",lvYunAppKey);
        signParams.put("password",password);

        LvYunSin t = new  LvYunSin();
        return t.getSign(signParams, appSecret);
    }
    public String getSign(Map<String,String> signParams){

        Map<String,Object> map = new HashMap<>(signParams);


        String appSecret = lvYunAppSecret;

        map.put("hotelGroupId",hotelGroupId);
//        signParams.put("mobile",mobile);
//        signParams.put("sessionId",sessionId);
        map.put("appKey",lvYunAppKey);
        logger.info("getSign signParams:{}", signParams.toString());

        LvYunSin t = new  LvYunSin();
        return t.getSign(map, appSecret);
    }

    public String getSessionId(CloseableHttpClient httpClient) {

        if (sessionId != null && sessionIdTime!= null && System.currentTimeMillis() > (sessionIdTime + 12 * 60 * 60 * 1000L)) {
            return sessionId;
        }

        HttpPost httpPost = new HttpPost(getSessionIdUrl());

        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
        httpPost.setHeader("User-Agent", "Apache-HttpClient/4.1.1(java 1.5)");
        httpPost.setHeader("Connection", "Keep-Alive");

        List<NameValuePair> pairList = new ArrayList<>();
        //集团编号，固定是2
        NameValuePair methodPair = new BasicNameValuePair("method", "user.login");
        NameValuePair vPair = new BasicNameValuePair("v", "3.0");
        NameValuePair formatPair = new BasicNameValuePair("format", "json");
        NameValuePair localPair = new BasicNameValuePair("local", "zh_CN");
        NameValuePair appKeyPair = new BasicNameValuePair("appKey", getLvYunAppKey());
        NameValuePair hotelGroupCodePair = new BasicNameValuePair("hotelGroupCode", getHotelGroupCode());
        NameValuePair userCodePair = new BasicNameValuePair("usercode",getUserName());
        NameValuePair passwordPair = new BasicNameValuePair("password", getPassword());
        NameValuePair sign = new BasicNameValuePair("sign", getSign());

        pairList.add(methodPair);
        pairList.add(vPair);
        pairList.add(formatPair);
        pairList.add(localPair);
        pairList.add(appKeyPair);
        pairList.add(hotelGroupCodePair);
        pairList.add(userCodePair);
        pairList.add(passwordPair);
        pairList.add(sign);

        httpPost.setEntity(new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));

        //执行http请求
        try (CloseableHttpResponse httpResponse = httpClient.execute(httpPost)) {
            String responseEntity = EntityUtils.toString(httpResponse.getEntity());
            logger.info("getSessionId http response= {}", responseEntity);

            JSONObject jsonObject = JSONObject.parseObject(responseEntity);
            sessionId = jsonObject.getString("resultInfo");
            sessionIdTime = System.currentTimeMillis();
            return sessionId;
        } catch (IOException e) {
            logger.error("getSessionId failure ,e:", e);
            return null;
        }
    }

    /**
     * 通过用户id获取用户的积分信息
     *
     * @param memberId
     * @return
     */
    public String getCredits(String memberId,CloseableHttpClient httpClient){
        if (StringUtils.isBlank(memberId)){
            return "0";
        }

        String sessionId = getSessionId(httpClient);
        //获取httpPost
        Map<String, String> newParams = new HashMap<>();
        newParams.put("sessionId", sessionId);
        newParams.put("memberId", memberId);
        logger.info("LvYunSmsCodeAdapter getSendSmsCodeHttpPost newparams:{}", newParams);

        HttpPost httpPost = new HttpPost(getGetCreditsUrl());

        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
        httpPost.setHeader("User-Agent", "Apache-HttpClient/4.1.1(java 1.5)");
        httpPost.setHeader("Connection", "Keep-Alive");

        List<NameValuePair> pairList = new ArrayList<>();
        //集团编号，固定是2
        NameValuePair sessionIdPair = new BasicNameValuePair("sessionId", sessionId);
        NameValuePair mobilePair = new BasicNameValuePair("memberId", memberId);
        NameValuePair hotelGroupIdPair = new BasicNameValuePair("hotelGroupId", getHotelGroupId());
        NameValuePair appKeyPair = new BasicNameValuePair("appKey", getLvYunAppKey());
        NameValuePair signPair = new BasicNameValuePair("sign", getSign(newParams));

        pairList.add(sessionIdPair);
        pairList.add(mobilePair);
        pairList.add(hotelGroupIdPair);
        pairList.add(signPair);
        pairList.add(appKeyPair);

        httpPost.setEntity(new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));

        //执行http请求
        try (CloseableHttpResponse httpResponse = httpClient.execute(httpPost)) {
            String responseEntity = EntityUtils.toString(httpResponse.getEntity());
            logger.info("smsCode http response= {}", responseEntity);
            //请求结果交给适配器处理，返回map集合
            JSONObject jsonObject = JSONObject.parseObject(responseEntity);
            JSONObject result = jsonObject.getJSONObject("result");
            if (result == null) {
                return "0";
            }
            Double balance = result.getDouble("balance");
            return balance == null ? "0" : balance.toString();
        } catch (IOException e) {
            logger.error("smsCode failure ,e:", e);
            //发生异常后有适配器自己处理异常

        }
        return "0";
    }




    public Set<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(Set<Long> appIds) {
        this.appIds = appIds;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getLvYunAppKey() {
        return lvYunAppKey;
    }

    public void setLvYunAppKey(String lvYunAppKey) {
        this.lvYunAppKey = lvYunAppKey;
    }

    public String getLvYunAppSecret() {
        return lvYunAppSecret;
    }

    public void setLvYunAppSecret(String lvYunAppSecret) {
        this.lvYunAppSecret = lvYunAppSecret;
    }

    public String getHotelGroupId() {
        return hotelGroupId;
    }

    public void setHotelGroupId(String hotelGroupId) {
        this.hotelGroupId = hotelGroupId;
    }

    public String getHotelGroupCode() {
        return hotelGroupCode;
    }

    public void setHotelGroupCode(String hotelGroupCode) {
        this.hotelGroupCode = hotelGroupCode;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getSessionIdUrl() {
        return sessionIdUrl;
    }

    public void setSessionIdUrl(String sessionIdUrl) {
        this.sessionIdUrl = sessionIdUrl;
    }

    public String getSubCreditsUrl() {
        return subCreditsUrl;
    }

    public void setSubCreditsUrl(String subCreditsUrl) {
        this.subCreditsUrl = subCreditsUrl;
    }

    public String getAddCreditsUrl() {
        return addCreditsUrl;
    }

    public void setAddCreditsUrl(String addCreditsUrl) {
        this.addCreditsUrl = addCreditsUrl;
    }

    public String getGetCreditsUrl() {
        return getCreditsUrl;
    }

    public void setGetCreditsUrl(String getCreditsUrl) {
        this.getCreditsUrl = getCreditsUrl;
    }

    public String getCoupons1() {
        return coupons1;
    }

    public void setCoupons1(String coupons1) {
        this.coupons1 = coupons1;
    }

    public String getCoupons2() {
        return coupons2;
    }

    public void setCoupons2(String coupons2) {
        this.coupons2 = coupons2;
    }

    public String getCoupons1Url() {
        return coupons1Url;
    }

    public void setCoupons1Url(String coupons1Url) {
        this.coupons1Url = coupons1Url;
    }

    public String getCoupons2Url() {
        return coupons2Url;
    }

    public void setCoupons2Url(String coupons2Url) {
        this.coupons2Url = coupons2Url;
    }
}
