package cn.com.duiba.constant;

import com.google.common.collect.Sets;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Set;

/**
 * 四川联通配置信息
 *
 * @Author chenxiangge
 * @Date 2020/12/15
 */
@Configuration
@ConfigurationProperties(prefix = "sichuanliantong")
public class SiChuanLianTongConfig {
    private Set<Long> appIds = Sets.newHashSet(80680L);

    private String clientId = "BFxkmPCE5ZcXpiL3ZvoZ";
    private String clientSecret = "htsdWF06KBNBFDuLcck8";
    private String acceptWay = "ST";
    private String signUrl = "/ability/313102";

    public String getSignUrl() {
        return signUrl;
    }

    public void setSignUrl(String signUrl) {
        this.signUrl = signUrl;
    }

    public String getAcceptWay() {
        return acceptWay;
    }

    public void setAcceptWay(String acceptWay) {
        this.acceptWay = acceptWay;
    }

    public Set<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(Set<Long> appIds) {
        this.appIds = appIds;
    }

    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public Boolean isSiChuanLianTongApp(Long appId) {
        return appIds != null && appIds.contains(appId);
    }


}
